/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Map;
import network.minter.blockchain.models.operational.Transaction;
import org.parceler.Parcel;

@Parcel
public class Balance {
    public Map<String, CoinBalance> coins;
    @SerializedName(value="transaction_count")
    public BigInteger txCount;

    public CoinBalance get(String string) {
        return this.coins.get(string.toUpperCase());
    }

    public BigDecimal getFor(String string) {
        if (!this.coins.containsKey(string.toUpperCase())) {
            return new BigDecimal("0");
        }
        return this.coins.get(string.toUpperCase()).getBalance();
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigInteger balance;

        public String getCoin() {
            return this.coin;
        }

        public BigDecimal getBalance() {
            return new BigDecimal(this.balance).setScale(18, RoundingMode.UNNECESSARY).divide(Transaction.VALUE_MUL_DEC, 7);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.coin, this.balance});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && CoinBalance.class == object.getClass()) {
                object = (CoinBalance)object;
                return Objects.equal((Object)this.coin, (Object)((CoinBalance)object).coin) && Objects.equal((Object)this.balance, (Object)((CoinBalance)object).balance);
            }
            return false;
        }
    }
}

