/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.RLPSerializable;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;

public abstract class Operation
extends RLPSerializable
implements Parcelable {
    private final Transaction mTx;

    public Operation(@Nonnull Transaction rawTx) {
        this.mTx = (Transaction)Preconditions.checkNotNull((Object)rawTx, (String)"Transaction must be set");
    }

    protected Operation(Parcel in) {
        this.mTx = (Transaction)in.readValue(Transaction.class.getClassLoader());
    }

    public Transaction build() throws OperationInvalidDataException {
        Transaction tx = this.mTx.setData(this);
        FieldsValidationResult validated = this.validate();
        if (validated == null) {
            validated = tx.validate();
        } else {
            validated.addResult(tx.validate());
        }
        if (validated != null && !validated.isValid()) {
            String title = (String)Preconditions.firstNonNull((Object)validated.getTitle(), (Object[])new String[]{String.format("Invalid %s operation data", this.getType().name())});
            String body = validated.getInvalidFieldsMessages();
            throw new OperationInvalidDataException(String.format("%s\nInvalid fields:\n%s", title, body), validated.getFieldMessageMap());
        }
        return tx;
    }

    public abstract OperationType getType();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mTx);
    }

    @Nullable
    protected abstract FieldsValidationResult validate();

    protected Transaction getTx() {
        return this.mTx;
    }
}

