/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public class TxCreateMultisigAddress
extends Operation {
    public static final Parcelable.Creator<TxCreateMultisigAddress> CREATOR = new Parcelable.Creator<TxCreateMultisigAddress>(){

        public TxCreateMultisigAddress createFromParcel(Parcel in) {
            return new TxCreateMultisigAddress(in);
        }

        public TxCreateMultisigAddress[] newArray(int size) {
            return new TxCreateMultisigAddress[size];
        }
    };
    private BigInteger mThreshold;
    private List<BigInteger> mWeights = new LinkedList<BigInteger>();
    private List<MinterAddress> mAddresses = new LinkedList<MinterAddress>();

    public TxCreateMultisigAddress(@Nonnull Transaction rawTx) {
        super(rawTx);
    }

    protected TxCreateMultisigAddress(Parcel in) {
        super(in);
        this.mThreshold = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        in.readList(this.mWeights, BigInteger.class.getClassLoader());
        in.readList(this.mAddresses, MinterAddressDeserializer.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mThreshold);
        dest.writeList(this.mWeights);
        dest.writeList(this.mAddresses);
    }

    public TxCreateMultisigAddress setThreshold(long threshold) {
        this.mThreshold = new BigInteger(String.valueOf(threshold));
        return this;
    }

    public TxCreateMultisigAddress addWeight(long ... weight) {
        for (long w : weight) {
            this.mWeights.add(new BigInteger(String.valueOf(w)));
        }
        return this;
    }

    public TxCreateMultisigAddress addAddress(MinterAddress address) {
        this.mAddresses.add(address);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.CreateMultisigAddress;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mThreshold", this.mThreshold != null, "Threshold is required").addResult("mWeights", this.mWeights.size() > 0, "You should add at least 1 weight").addResult("mAddresses", this.mAddresses != null, "You should add at least 1 address");
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mThreshold = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(0, decoded));
        Object[] weights = (Object[])decoded[1];
        this.mWeights = new LinkedList<BigInteger>();
        for (Object weightsEncoded : weights) {
            byte[][] weightsBytes;
            for (byte[] weight : weightsBytes = this.objArrToByteArrArr((Object[])weightsEncoded)) {
                this.mWeights.add(BytesHelper.fixBigintSignedByte((byte[])weight));
            }
        }
        Object[] addresses = (Object[])decoded[2];
        this.mAddresses = new LinkedList<MinterAddress>();
        for (Object address : addresses) {
            byte[][] ws;
            for (byte[] w : ws = this.objArrToByteArrArr((Object[])address)) {
                this.mAddresses.add(new MinterAddress(w));
            }
        }
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        BigInteger[] weights = this.mWeights.toArray(new BigInteger[this.mWeights.size()]);
        byte[][] addresses = new byte[this.mAddresses.size()][];
        for (int i = 0; i < this.mAddresses.size(); ++i) {
            addresses[i] = this.mAddresses.get(i).getData();
        }
        return RLP.encode((Object)new Object[]{this.mThreshold, weights, addresses});
    }
}

