/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCoinBuy
extends Operation {
    public static final Parcelable.Creator<TxCoinBuy> CREATOR = new Parcelable.Creator<TxCoinBuy>(){

        public TxCoinBuy createFromParcel(Parcel in) {
            return new TxCoinBuy(in);
        }

        public TxCoinBuy[] newArray(int size) {
            return new TxCoinBuy[size];
        }
    };
    private String mCoinToBuy;
    private BigInteger mValueToBuy;
    private String mCoinToSell;
    private BigInteger mMaxValueToSell;

    public TxCoinBuy(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCoinBuy(Parcel in) {
        super(in);
        this.mCoinToBuy = in.readString();
        this.mValueToBuy = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mCoinToSell = in.readString();
        this.mMaxValueToSell = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoinToBuy);
        dest.writeValue((Object)this.mValueToBuy);
        dest.writeString(this.mCoinToSell);
        dest.writeValue((Object)this.mMaxValueToSell);
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinBuy setCoinToBuy(String coin) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinBuy setCoinToSell(String coin) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public BigInteger getValueToBuyBigInteger() {
        return this.mValueToBuy;
    }

    public BigDecimal getValueToBuy() {
        return Transaction.VALUE_MUL_DEC.divide(new BigDecimal(this.mValueToBuy));
    }

    public double getValueToBuyDouble() {
        return this.getValueToBuy().doubleValue();
    }

    public TxCoinBuy setValueToBuy(BigInteger amount) {
        this.mValueToBuy = amount;
        return this;
    }

    public TxCoinBuy setValueToBuy(double amount) {
        return this.setValueToBuy(new BigDecimal(amount));
    }

    public TxCoinBuy setValueToBuy(BigDecimal amount) {
        return this.setValueToBuy(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCoinBuy setMaxValueToSell(double amount) {
        return this.setMaxValueToSell(new BigDecimal(amount));
    }

    public TxCoinBuy setMaxValueToSell(BigInteger amount) {
        this.mMaxValueToSell = amount;
        return this;
    }

    public TxCoinBuy setMaxValueToSell(BigDecimal amount) {
        return this.setMaxValueToSell(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    @Override
    public OperationType getType() {
        return OperationType.BuyCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoinToBuy", this.mCoinToBuy != null && this.mCoinToBuy.length() > 2 && this.mCoinToBuy.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mCoinToSell", this.mCoinToSell != null && this.mCoinToSell.length() > 2 && this.mCoinToSell.length() < 11, "Coin length must be from 3 to 10 chars").addResult("mValueToBuy", this.mValueToBuy != null, "Value must be set").addResult("mMaxValueToSell", this.mMaxValueToSell != null, "Maximum value to sell must be set");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mCoinToBuy, this.mValueToBuy, this.mCoinToSell, this.mMaxValueToSell});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoinToBuy = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mValueToBuy = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(1, decoded));
        this.mCoinToSell = StringHelper.bytesToString((byte[])this.fromRawRlp(2, decoded));
        this.mMaxValueToSell = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(3, decoded));
    }
}

