/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;

public enum OperationType {
    SendCoin(1, TxSendCoin.class, 10.0),
    SellCoin(2, TxCoinSell.class, 100.0),
    SellAllCoins(3, TxCoinSellAll.class, 100.0),
    BuyCoin(4, TxCoinBuy.class, 100.0),
    CreateCoin(5, TxCreateCoin.class, 1000.0),
    DeclareCandidacy(6, TxDeclareCandidacy.class, 10000.0),
    Delegate(7, TxDelegate.class, 100.0),
    Unbound(8, TxUnbound.class, 100.0),
    RedeemCheck(9, TxRedeemCheck.class, 10.0),
    SetCandidateOnline(10, TxSetCandidateOnline.class, 100.0),
    SetCandidateOffline(11, TxSetCandidateOffline.class, 100.0);

    private static final String FEE_BASE_STRING = "0.001";
    public static final BigDecimal FEE_BASE;
    final BigInteger mValue;
    Class<? extends Operation> mOpClass;
    BigDecimal mFee;

    private OperationType(byte value, Class<? extends Operation> opClass, double fee) {
        this.mValue = new BigInteger(String.valueOf(value));
        this.mOpClass = opClass;
        this.mFee = this.getFeeBase().multiply(new BigDecimal(fee));
    }

    @Nullable
    public static OperationType findByValue(BigInteger type) {
        for (OperationType t : OperationType.values()) {
            if (!t.mValue.equals(type)) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static OperationType findByOpClass(Class<? extends Operation> opClass) {
        for (OperationType t : OperationType.values()) {
            if (!t.getOpClass().equals(opClass)) continue;
            return t;
        }
        return null;
    }

    public BigDecimal getFeeBase() {
        return new BigDecimal(FEE_BASE_STRING);
    }

    public BigDecimal getFee() {
        return this.mFee;
    }

    public Class<? extends Operation> getOpClass() {
        return this.mOpClass;
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public int getValueInt() {
        return this.mValue.intValue();
    }

    static {
        FEE_BASE = new BigDecimal(FEE_BASE_STRING);
    }
}

