/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCoinBuy
extends Operation {
    public static final Parcelable.Creator<TxCoinBuy> CREATOR = new Parcelable.Creator<TxCoinBuy>(){

        public TxCoinBuy createFromParcel(Parcel parcel) {
            return new TxCoinBuy(parcel);
        }

        public TxCoinBuy[] newArray(int n) {
            return new TxCoinBuy[n];
        }
    };
    private String mCoinToBuy;
    private BigInteger mValueToBuy;
    private String mCoinToSell;
    private BigInteger mMaxValueToSell;

    public TxCoinBuy() {
    }

    public TxCoinBuy(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinBuy(Parcel parcel) {
        super(parcel);
        this.mCoinToBuy = parcel.readString();
        this.mValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinToSell = parcel.readString();
        this.mMaxValueToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinBuy txCoinBuy = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txCoinBuy.mCoinToBuy);
        parcel.writeValue((Object)this.mValueToBuy);
        parcel.writeString(this.mCoinToSell);
        parcel.writeValue((Object)this.mMaxValueToSell);
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinBuy setCoinToBuy(String string) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinBuy setCoinToSell(String string) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigDecimal getMaxValueToSell() {
        return Transaction.humanizeValue(this.mMaxValueToSell);
    }

    public BigInteger getValueToBuyBigInteger() {
        return this.mValueToBuy;
    }

    public TxCoinBuy setMaxValueToSell(@Nonnull CharSequence charSequence) {
        return this.setMaxValueToSell(new BigDecimal(charSequence.toString()));
    }

    public TxCoinBuy setValueToBuy(BigInteger bigInteger) {
        this.mValueToBuy = bigInteger;
        return this;
    }

    public TxCoinBuy setMaxValueToSell(BigDecimal bigDecimal) {
        return this.setMaxValueToSell(Transaction.normalizeValue(bigDecimal));
    }

    public BigDecimal getValueToBuy() {
        return Transaction.humanizeValue(this.mValueToBuy);
    }

    public TxCoinBuy setMaxValueToSell(BigInteger bigInteger) {
        this.mMaxValueToSell = bigInteger;
        return this;
    }

    public TxCoinBuy setValueToBuy(BigDecimal bigDecimal) {
        return this.setValueToBuy(Transaction.normalizeValue(bigDecimal));
    }

    public TxCoinBuy setValueToBuy(@Nonnull CharSequence charSequence) {
        return this.setValueToBuy(new BigDecimal(charSequence.toString()));
    }

    @Override
    public OperationType getType() {
        return OperationType.BuyCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        String string2 = ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinToBuy;
        boolean bl = string2 != null && string2.length() > 2 && ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinToBuy.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin length must be from 3 to 10 chars");
        string = "mCoinToSell";
        String string3 = ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinToSell;
        boolean bl2 = string3 != null && string3.length() > 2 && ((TxCoinBuy)((Object)fieldsValidationResult2)).mCoinToSell.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl2, "Coin length must be from 3 to 10 chars");
        string = "mValueToBuy";
        bl2 = ((TxCoinBuy)((Object)fieldsValidationResult2)).mValueToBuy != null;
        TxCoinBuy txCoinBuy = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl2, "Value must be set");
        object = "mMaxValueToSell";
        boolean bl3 = txCoinBuy.mMaxValueToSell != null;
        return fieldsValidationResult2.addResult((String)object, bl3, "Maximum value to sell must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinToBuy;
        objectArray2[1] = this.mValueToBuy;
        objectArray2[2] = this.mCoinToSell;
        objectArray[3] = this.mMaxValueToSell;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mCoinToBuy = StringHelper.charsToString((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mValueToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mCoinToSell = StringHelper.charsToString((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mMaxValueToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
    }
}

