/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.BuildConfig;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.ExternalTransaction;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.InvalidEncodedTransactionException;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.RLPSerializable;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.blockchain.models.operational.SignatureMultiData;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxCreateMultisigAddress;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxEditCandidate;
import network.minter.blockchain.models.operational.TxMultisend;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public class Transaction
implements Parcelable {
    public static final BigInteger VALUE_MUL = new BigInteger("1000000000000000000", 10);
    public static final BigDecimal VALUE_MUL_DEC = new BigDecimal("1000000000000000000");
    public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

        public Transaction createFromParcel(Parcel parcel) {
            return new Transaction(parcel);
        }

        public Transaction[] newArray(int n) {
            return new Transaction[n];
        }
    };
    BigInteger mNonce;
    BlockchainID mChainId;
    BigInteger mGasPrice;
    String mGasCoin;
    OperationType mType;
    Operation mOperationData;
    BytesData mPayload;
    BytesData mServiceData;
    SignatureType mSignatureType;
    SignatureData mSignatureData;

    protected Transaction(BigInteger bigInteger) {
        this.mGasPrice = new BigInteger("1");
        this.mGasCoin = "MNT";
        this.mType = OperationType.SendCoin;
        this.mPayload = new BytesData(new char[0]);
        this.mServiceData = new BytesData(new char[0]);
        this.mSignatureType = SignatureType.Single;
        this.mNonce = bigInteger;
    }

    protected Transaction() {
        this.mGasPrice = new BigInteger("1");
        this.mGasCoin = "MNT";
        this.mType = OperationType.SendCoin;
        this.mPayload = new BytesData(new char[0]);
        this.mServiceData = new BytesData(new char[0]);
        this.mSignatureType = SignatureType.Single;
    }

    protected Transaction(Parcel parcel) {
        Transaction transaction = object;
        Transaction transaction2 = object;
        object.mGasPrice = new BigInteger("1");
        object.mGasCoin = "MNT";
        object.mType = OperationType.SendCoin;
        object.mPayload = new BytesData(new char[0]);
        object.mServiceData = new BytesData(new char[0]);
        object.mSignatureType = SignatureType.Single;
        object.mNonce = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        object.mChainId = (BlockchainID)((Object)parcel.readValue(BlockchainID.class.getClassLoader()));
        object.mGasPrice = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        object.mGasCoin = parcel.readString();
        object.mType = (OperationType)((Object)parcel.readValue(OperationType.class.getClassLoader()));
        object.mOperationData = (Operation)parcel.readValue(Operation.class.getClassLoader());
        object.mPayload = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        object.mServiceData = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        Object object = (SignatureType)((Object)parcel.readValue(SignatureType.class.getClassLoader()));
        transaction2.mSignatureType = object;
        transaction.mSignatureData = (SignatureData)parcel.readValue(((SignatureType)((Object)object)).mTypeClass.getClassLoader());
    }

    public static BigDecimal humanizeValue(BigInteger bigInteger) {
        return new BigDecimal(bigInteger).divide(VALUE_MUL_DEC);
    }

    public static BigInteger normalizeValue(BigDecimal bigDecimal) {
        return bigDecimal.multiply(VALUE_MUL_DEC).toBigInteger();
    }

    public static BigInteger normalizeValue(CharSequence charSequence) {
        if (charSequence == null) {
            return BigInteger.ZERO;
        }
        return new BigDecimal(charSequence.toString()).multiply(VALUE_MUL_DEC).toBigInteger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Transaction fromEncoded(@Nonnull String objectArray) {
        RLPSerializable rLPSerializable;
        Class[] classArray;
        Class<? extends Operation> clazz;
        Transaction transaction;
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new BytesData((CharSequence)objectArray).getData(), (int)0).getDecoded();
        if (objectArray.length < 10) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = objectArray.length;
            throw new InvalidEncodedTransactionException("Encoded transaction has invalid data length: expected 10, given %d", objectArray3);
        }
        Transaction transaction2 = transaction;
        transaction2();
        transaction.decodeRLP(objectArray);
        try {
            clazz = transaction.mType.getOpClass();
            classArray = new Class[1];
        }
        catch (Throwable throwable) {
            throw new InvalidEncodedTransactionException("Unable to decode transaction data field", throwable);
        }
        {
            classArray[0] = Transaction.class;
            rLPSerializable = clazz.getDeclaredConstructor(classArray).newInstance(transaction2);
        }
        {
            transaction2.mOperationData = rLPSerializable;
            rLPSerializable.decodeRLP(transaction2.fromRawRlp(5, objectArray));
        }
        try {
            rLPSerializable = transaction.mSignatureType.getSignClass().newInstance();
        }
        catch (Throwable throwable) {
            throw new InvalidEncodedTransactionException("Unable to decode transaction signature data field", throwable);
        }
        {
            transaction2.mSignatureData = rLPSerializable;
            rLPSerializable.decodeRLP(transaction2.fromRawRlp(9, objectArray));
            return transaction;
        }
    }

    public void cleanup() {
        Transaction transaction = this;
        transaction.mNonce = null;
        transaction.mChainId = null;
        transaction.mGasPrice = null;
        transaction.mGasCoin = null;
        transaction.mType = null;
        transaction.mOperationData = null;
        transaction.mPayload = null;
        transaction.mServiceData = null;
        transaction.mSignatureType = null;
        transaction.mSignatureData = null;
    }

    public SignatureType getSignatureType() {
        return this.mSignatureType;
    }

    public <SignData extends SignatureData> SignData getSignatureData(Class<SignData> clazz) {
        return (SignData)((SignatureData)clazz.cast(this.mSignatureData));
    }

    public <SignData extends SignatureData> SignData getSignatureData() {
        return (SignData)this.mSignatureData;
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getGasPrice() {
        return this.mGasPrice;
    }

    public OperationType getType() {
        return this.mType;
    }

    public TransactionSign signMulti(MinterAddress minterAddress, PrivateKey ... privateKeyArray) {
        return this.signMulti(minterAddress, Arrays.asList(privateKeyArray));
    }

    public TransactionSign signMultiExternal(MinterAddress minterAddress, List<SignatureSingleData> list) {
        SignatureMultiData signatureMultiData;
        Transaction transaction = this;
        transaction.mSignatureType = SignatureType.Multi;
        SignatureMultiData signatureMultiData2 = signatureMultiData;
        transaction.mSignatureData = new SignatureMultiData();
        signatureMultiData2.setSigns(minterAddress, list);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    public TransactionSign signMulti(MinterAddress minterAddress, @Nonnull List<PrivateKey> object) {
        SignatureMultiData signatureMultiData;
        ArrayList<SignatureSingleData> arrayList;
        this.mSignatureType = SignatureType.Multi;
        Preconditions.checkArgument((object.size() > 0 ? 1 : 0) != 0, (Object)"Private keys can't be empty");
        BytesData bytesData = new BytesData(this.encode(true)).sha3Data();
        ArrayList<SignatureSingleData> arrayList2 = arrayList;
        arrayList = new ArrayList<SignatureSingleData>(object.size());
        long l = NativeSecp256k1.contextCreate();
        try {
            object = object.iterator();
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        while (true) {
            if (!object.hasNext()) break;
            ArrayList<SignatureSingleData> arrayList3 = arrayList2;
            long l2 = l;
            PrivateKey privateKey = (PrivateKey)object.next();
            Object object2 = BytesHelper.charsToBytes((char[])bytesData.getData());
            object2 = NativeSecp256k1.signRecoverableSerialized((long)l2, (byte[])object2, (byte[])privateKey.getBytes());
            SignatureSingleData signatureSingleData = new SignatureSingleData();
            signatureSingleData.setSign((NativeSecp256k1.RecoverableSignature)object2);
            arrayList3.add(signatureSingleData);
        }
        NativeSecp256k1.contextCleanup((long)l);
        object = signatureMultiData;
        this.mSignatureData = new SignatureMultiData();
        ((SignatureMultiData)object).setSigns(minterAddress, arrayList2);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    public BytesData getUnsignedTxHash() {
        ((Transaction)object).mSignatureType = SignatureType.Single;
        Object object = ((Transaction)object).encode(true);
        return new BytesData((char[])object).sha3Data();
    }

    public TransactionSign signExternal(SignatureSingleData signatureSingleData) {
        this.mSignatureData = signatureSingleData;
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    public TransactionSign signExternal(char[] cArray, char[] cArray2, char[] cArray3) {
        this.mSignatureData = new SignatureSingleData(cArray, cArray2, cArray3);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    @Nullable
    public TransactionSign signSingle(@Nonnull PrivateKey object) {
        SignatureSingleData signatureSingleData;
        PrivateKey privateKey;
        this.mSignatureType = SignatureType.Single;
        Object object2 = this.encode(true);
        object2 = new BytesData(object2).sha3Data();
        long l = NativeSecp256k1.contextCreate();
        try {
            privateKey = object;
            object = BytesHelper.charsToBytes((char[])object2.getData());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])privateKey.getBytes());
        NativeSecp256k1.contextCleanup((long)l);
        if (object == null) {
            return null;
        }
        object2 = signatureSingleData;
        signatureSingleData = new SignatureSingleData();
        this.mSignatureData = signatureSingleData;
        ((SignatureSingleData)object2).setSign((NativeSecp256k1.RecoverableSignature)object);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    @Nullable
    public SignatureSingleData signOnlyMulti(PrivateKey privateKey) {
        PrivateKey privateKey2;
        ((Transaction)object).mSignatureType = SignatureType.Multi;
        Object object = ((Transaction)object).encode(true);
        object = new BytesData((char[])object).sha3Data();
        long l = NativeSecp256k1.contextCreate();
        try {
            privateKey2 = privateKey;
            object = BytesHelper.charsToBytes((char[])object.getData());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])privateKey2.getBytes());
        NativeSecp256k1.contextCleanup((long)l);
        if (object == null) {
            return null;
        }
        return new SignatureSingleData((NativeSecp256k1.RecoverableSignature)object);
    }

    @Nullable
    public SignatureSingleData signOnlySingle(PrivateKey privateKey) {
        PrivateKey privateKey2;
        ((Transaction)object).mSignatureType = SignatureType.Single;
        Object object = ((Transaction)object).encode(true);
        object = new BytesData((char[])object).sha3Data();
        long l = NativeSecp256k1.contextCreate();
        try {
            privateKey2 = privateKey;
            object = BytesHelper.charsToBytes((char[])object.getData());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])privateKey2.getBytes());
        NativeSecp256k1.contextCleanup((long)l);
        if (object == null) {
            return null;
        }
        return new SignatureSingleData((NativeSecp256k1.RecoverableSignature)object);
    }

    public <OpType extends Operation> OpType getData(Class<OpType> clazz) {
        return (OpType)((Operation)clazz.cast(this.mOperationData));
    }

    public <OpType extends Operation> OpType getData() {
        return (OpType)this.mOperationData;
    }

    <Op extends Operation> Transaction setData(Op Op) {
        this.mOperationData = Op;
        this.mType = Op.getType();
        return this;
    }

    public BlockchainID getBlockchainId() {
        return this.mChainId;
    }

    public String getGasCoin() {
        return this.mGasCoin.replace("\u0000", "");
    }

    public BytesData getPayload() {
        return this.mPayload;
    }

    public String getPayloadString() {
        return new String(this.getPayload().getData());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mNonce);
        parcel.writeValue((Object)this.mChainId);
        parcel.writeValue((Object)this.mGasPrice);
        parcel.writeString(this.mGasCoin);
        parcel.writeValue((Object)this.mType);
        parcel.writeValue((Object)this.mOperationData);
        parcel.writeValue((Object)this.mPayload);
        parcel.writeValue((Object)this.mServiceData);
        parcel.writeValue((Object)this.mSignatureType);
        parcel.writeValue((Object)this.mSignatureType);
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    void decodeRLP(Object[] objectArray) {
        this.mNonce = BytesHelper.fixBigintSignedByte((Object)objectArray[0]);
        this.mChainId = BlockchainID.valueOf(BytesHelper.fixBigintSignedByte((char[])this.fromRawRlp(1, objectArray)));
        this.mGasPrice = BytesHelper.fixBigintSignedByte((Object)objectArray[2]);
        this.mGasCoin = StringHelper.charsToString((char[])this.fromRawRlp(3, objectArray), (int)10);
        this.mType = OperationType.findByValue(new BigInteger(BytesHelper.charsToBytes((char[])this.fromRawRlp(4, objectArray))));
        this.mPayload = new BytesData(this.fromRawRlp(6, objectArray));
        this.mServiceData = new BytesData(this.fromRawRlp(7, objectArray));
        this.mSignatureType = SignatureType.findByValue(new BigInteger(BytesHelper.charsToBytes((char[])this.fromRawRlp(8, objectArray))));
    }

    char[] encode(boolean bl) {
        char[] cArray = this.mOperationData.encodeRLP();
        if (bl) {
            Object[] objectArray = new Object[9];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray2[2] = this.mGasPrice;
            objectArray2[3] = this.mGasCoin;
            objectArray2[4] = this.mOperationData.getType().getValue();
            objectArray2[5] = cArray;
            objectArray2[6] = this.mPayload.getData();
            objectArray2[7] = this.mServiceData.getData();
            objectArray[8] = this.mSignatureType.getValue();
            return RLPBoxed.encode((Object)objectArray);
        }
        char[] cArray2 = this.mSignatureData.encodeRLP();
        Object[] objectArray = new Object[10];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = this.mNonce.toByteArray();
        objectArray3[1] = BigInteger.valueOf(this.mChainId.getId());
        objectArray3[2] = this.mGasPrice;
        objectArray3[3] = this.mGasCoin;
        objectArray3[4] = this.mOperationData.getType().getValue();
        objectArray3[5] = cArray;
        objectArray3[6] = this.mPayload.getData();
        objectArray3[7] = this.mServiceData.getData();
        objectArray[8] = this.mSignatureType.getValue();
        objectArray[9] = cArray2;
        return RLPBoxed.encode((Object)objectArray);
    }

    FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult("Invalid transaction data");
        String string = "nonce";
        boolean bl = ((Transaction)((Object)fieldsValidationResult2)).mNonce != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Nonce must be set");
        string = "gasPrice";
        bl = ((Transaction)((Object)fieldsValidationResult2)).mGasCoin != null;
        Transaction transaction = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Gas coin must be set");
        object = "operationData";
        boolean bl2 = transaction.mOperationData != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Operation data does not set! Check your operation model.");
    }

    public static class Builder {
        private final Transaction mTx;
        private ExternalTransaction mExtTx = null;

        public Builder(BigInteger bigInteger, ExternalTransaction externalTransaction) {
            this(bigInteger);
            BytesData bytesData;
            Preconditions.checkArgument((externalTransaction.getType() != null ? 1 : 0) != 0, (Object)"Transaction type must be set");
            Preconditions.checkArgument((externalTransaction.mOperationData != null ? 1 : 0) != 0, (Object)"Transaction data must be set");
            this.mTx.mType = externalTransaction.getType();
            Transaction transaction = this.mTx;
            transaction.mOperationData = externalTransaction.mOperationData;
            Object[] objectArray = new BytesData[1];
            bigInteger = bytesData;
            bytesData = new BytesData(new char[0]);
            objectArray[0] = bigInteger;
            transaction.mPayload = (BytesData)Preconditions.firstNonNull((Object)externalTransaction.getPayload(), (Object[])objectArray);
            this.mTx.mGasCoin = externalTransaction.getGasCoin() != null && !externalTransaction.getGasCoin().equals("") ? StringHelper.strrpad((int)10, (String)externalTransaction.getGasCoin()) : StringHelper.strrpad((int)10, (String)"MNT");
            this.mTx.mGasPrice = externalTransaction.getGasPrice() != null && !externalTransaction.getGasPrice().equals(BigInteger.ZERO) ? externalTransaction.getGasPrice() : BigInteger.ONE;
            this.mExtTx = externalTransaction;
        }

        public Builder(BigInteger bigInteger) {
            Preconditions.checkArgument((bigInteger != null ? 1 : 0) != 0, (Object)"Nonce must be set");
            this.mTx = new Transaction(bigInteger);
            new Transaction(bigInteger).mChainId = BuildConfig.BLOCKCHAIN_ID;
        }

        public Transaction buildFromExternal() {
            if (this.mExtTx != null) {
                return this.mTx;
            }
            throw new IllegalStateException("Unable to build network tx without external transaction. Or build by yourself normal transaction.");
        }

        public Builder setBlockchainId(BlockchainID blockchainID) {
            this.mTx.mChainId = blockchainID;
            return this;
        }

        public Builder setGasCoin(@Nonnull String string) {
            Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Gas coin can't be null");
            this.mTx.mGasCoin = StringHelper.strrpad((int)10, (String)string);
            return this;
        }

        public Builder setGasPrice(@Nonnull BigInteger bigInteger) {
            Preconditions.checkArgument((bigInteger != null ? 1 : 0) != 0, (Object)"Gas can't be null");
            this.mTx.mGasPrice = bigInteger;
            return this;
        }

        public Builder setPayload(byte[] byArray) {
            if (byArray == null) {
                this.mTx.mPayload = new BytesData(new char[0]);
                return this;
            }
            return this.setPayload(new BytesData(byArray, true));
        }

        public Builder setPayload(BytesData bytesData) {
            if (bytesData == null) {
                this.mTx.mPayload = new BytesData(new char[0]);
                return this;
            }
            Preconditions.checkArgument((bytesData.size() <= 1024 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes");
            this.mTx.mPayload = new BytesData(bytesData.getData(), true);
            return this;
        }

        public Builder setPayload(String string) {
            if (string == null) {
                this.mTx.mPayload = new BytesData(new char[0]);
                return this;
            }
            Preconditions.checkArgument((string.length() <= 2048 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes (2048 in hex string)");
            this.mTx.mPayload = new BytesData((CharSequence)string);
            return this;
        }

        public Builder setPayload(ByteBuffer byteBuffer) {
            return this.setPayload(byteBuffer.array());
        }

        public Builder setNonce(BigInteger bigInteger) {
            this.mTx.mNonce = bigInteger;
            return this;
        }

        public <Op extends Operation> Op create(Class<Op> clazz) {
            Class<Op> clazz2 = clazz;
            Class[] classArray = new Class[1];
            classArray[0] = Transaction.class;
            Constructor<Op> constructor = clazz2.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[1];
            int n = 0;
            try {
                objectArray[n] = this.mTx;
                return (Op)((Operation)constructor.newInstance(objectArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
        }

        public <Op extends Operation> Op setData(Op Op) {
            this.mTx.mOperationData = Op;
            return Op;
        }

        public TxCoinBuy buyCoin() {
            return new TxCoinBuy(this.mTx);
        }

        public TxCoinSell sellCoin() {
            return new TxCoinSell(this.mTx);
        }

        public TxCoinSellAll sellAllCoins() {
            return new TxCoinSellAll(this.mTx);
        }

        public TxCreateCoin createCoin() {
            return new TxCreateCoin(this.mTx);
        }

        public TxDeclareCandidacy declareCandidacy() {
            return new TxDeclareCandidacy(this.mTx);
        }

        public TxDelegate delegate() {
            return new TxDelegate(this.mTx);
        }

        public TxRedeemCheck redeemCheck() {
            return new TxRedeemCheck(this.mTx);
        }

        public TxSendCoin sendCoin() {
            return new TxSendCoin(this.mTx);
        }

        public TxCreateMultisigAddress createMultisigAddress() {
            return new TxCreateMultisigAddress(this.mTx);
        }

        public TxMultisend multiSend() {
            return new TxMultisend(this.mTx);
        }

        public TxEditCandidate editCandidate() {
            return new TxEditCandidate(this.mTx);
        }

        public TxSetCandidateOffline setCandidateOffline() {
            return new TxSetCandidateOffline(this.mTx);
        }

        public TxSetCandidateOnline setCandidateOnline() {
            return new TxSetCandidateOnline(this.mTx);
        }

        public TxUnbound unbound() {
            return new TxUnbound(this.mTx);
        }
    }

    public static final class SignatureType
    extends Enum<SignatureType> {
        public static final /* enum */ SignatureType Single;
        public static final /* enum */ SignatureType Multi;
        private static final /* synthetic */ SignatureType[] $VALUES;
        BigInteger mVal;
        Class<? extends SignatureData> mTypeClass;

        public static SignatureType[] values() {
            return (SignatureType[])$VALUES.clone();
        }

        public static SignatureType valueOf(String string) {
            return Enum.valueOf(SignatureType.class, string);
        }

        private SignatureType(byte by, Class<? extends SignatureData> clazz) {
            this.mVal = new BigInteger(String.valueOf(by));
            this.mTypeClass = clazz;
        }

        public static SignatureType findByValue(BigInteger bigInteger) {
            for (SignatureType signatureType : SignatureType.values()) {
                if (!signatureType.getValue().equals(bigInteger)) continue;
                return signatureType;
            }
            return null;
        }

        static {
            SignatureType signatureType;
            Single = new SignatureType(1, SignatureSingleData.class);
            SignatureType signatureType2 = signatureType;
            Multi = new SignatureType(2, SignatureMultiData.class);
            $VALUES = new SignatureType[]{Single, signatureType2};
        }

        public BigInteger getValue() {
            return this.mVal;
        }

        public Class<? extends SignatureData> getSignClass() {
            return this.mTypeClass;
        }
    }
}

