/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.BuildConfig;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.InvalidEncodedTransactionException;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.HashUtil;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public class CheckTransactionCompat {
    private String mPassphrase;
    private BytesData mNonce;
    private BlockchainID mChainId;
    private BigInteger mDueBlock;
    private String mCoin = StringHelper.strrpad((int)10, (String)"MNT");
    private BigInteger mValue;
    private BytesData mLock;
    private SignatureSingleData mSignature;

    CheckTransactionCompat(BytesData bytesData, String string) {
        this.mNonce = bytesData;
        this.mPassphrase = string;
    }

    CheckTransactionCompat() {
        this.mNonce = new BytesData("1".getBytes());
    }

    public static BytesData makeProof(String string, byte[] byArray) {
        return CheckTransactionCompat.makeProof(new MinterAddress((CharSequence)string), byArray);
    }

    public static BytesData makeProof(String string, String string2) {
        return CheckTransactionCompat.makeProof(new MinterAddress((CharSequence)string), string2.getBytes());
    }

    public static BytesData makeProof(MinterAddress minterAddress, String string) {
        return CheckTransactionCompat.makeProof(minterAddress, string.getBytes());
    }

    public static BytesData makeProof(MinterAddress object, byte[] object2) {
        BytesData bytesData;
        BytesData bytesData2;
        BytesData bytesData3 = bytesData2;
        bytesData2 = new BytesData(HashUtil.sha256((byte[])object2));
        object = new BytesData(RLPBoxed.encode((Object)new Object[]{object.getData()})).sha3Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            bytesData = bytesData3;
            object = object.getBytes();
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        object = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object, (byte[])bytesData.getBytes());
        NativeSecp256k1.contextCleanup((long)l);
        object2 = object.v;
        int n = 0;
        byte by = object.v[0] == 27 ? (byte)0 : 1;
        object2[n] = by;
        byte[][] byArrayArray = new byte[3][];
        object2 = byArrayArray;
        object2[0] = (byte)object.r;
        object2[1] = (byte)object.s;
        byArrayArray[2] = object.v;
        return new BytesData((byte[][])object2);
    }

    public static CheckTransactionCompat fromEncoded(@Nonnull MinterCheck minterCheck) {
        return CheckTransactionCompat.fromEncoded(minterCheck.toString());
    }

    public static CheckTransactionCompat fromEncoded(@Nonnull String objectArray) {
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new BytesData((BytesData)new MinterCheck((CharSequence)objectArray)).getData(), (int)0).getDecoded();
        if (objectArray.length == 9) {
            CheckTransactionCompat checkTransactionCompat = new CheckTransactionCompat();
            checkTransactionCompat.decodeRLP(objectArray);
            return checkTransactionCompat;
        }
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray.length;
        throw new InvalidEncodedTransactionException("Encoded transaction has invalid data length: expected 9, given %d", objectArray3);
    }

    private void decodeRLP(Object[] objectArray) {
        CheckTransactionCompat checkTransactionCompat = object;
        ((CheckTransactionCompat)object).mNonce = new BytesData((char[])objectArray[0]);
        ((CheckTransactionCompat)object).mChainId = BlockchainID.valueOf(BytesHelper.fixBigintSignedByte((char[])((CheckTransactionCompat)object).fromRawRlp(1, objectArray)));
        ((CheckTransactionCompat)object).mDueBlock = BytesHelper.fixBigintSignedByte((Object)objectArray[2]);
        ((CheckTransactionCompat)object).mCoin = StringHelper.charsToStringSafe((char[])((CheckTransactionCompat)object).fromRawRlp(3, objectArray), (int)10);
        checkTransactionCompat.mValue = BytesHelper.fixBigintSignedByte((Object)objectArray[4]);
        checkTransactionCompat.mLock = new BytesData((char[])objectArray[5]);
        ((CheckTransactionCompat)object).mSignature = new SignatureSingleData();
        char[][] cArrayArray = new char[3][];
        Object object = cArrayArray;
        object[0] = (char[])objectArray[6];
        object[1] = (char[])objectArray[7];
        cArrayArray[2] = (char[])objectArray[8];
        ((CheckTransactionCompat)object).mSignature.decodeRaw(cArrayArray);
    }

    private char[] encode(boolean bl) {
        if (bl) {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray2[2] = this.mDueBlock;
            objectArray2[3] = this.mCoin;
            objectArray[4] = this.mValue;
            return RLPBoxed.encode((Object)objectArray);
        }
        CheckTransactionCompat checkTransactionCompat = this;
        char[] cArray = checkTransactionCompat.mLock.getData();
        Object[] objectArray = checkTransactionCompat.mSignature;
        if (checkTransactionCompat.mSignature != null && objectArray.getV() != null && this.mSignature.getR() != null && this.mSignature.getS() != null) {
            Object[] objectArray3 = new Object[9];
            objectArray = objectArray3;
            objectArray[0] = this.mNonce;
            objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray[2] = this.mDueBlock;
            objectArray[3] = this.mCoin;
            objectArray[4] = this.mValue;
            objectArray[5] = cArray;
            objectArray[6] = this.mSignature.getV().getData();
            objectArray[7] = this.mSignature.getR().getData();
            objectArray3[8] = this.mSignature.getS().getData();
            return RLPBoxed.encode((Object)objectArray3);
        }
        Object[] objectArray4 = new Object[6];
        objectArray = objectArray4;
        objectArray[0] = this.mNonce;
        objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
        objectArray[2] = this.mDueBlock;
        objectArray[3] = this.mCoin;
        objectArray4[4] = this.mValue;
        objectArray4[5] = cArray;
        return RLPBoxed.encode((Object)objectArray4);
    }

    static /* synthetic */ BlockchainID access$002(CheckTransactionCompat checkTransactionCompat, BlockchainID blockchainID) {
        checkTransactionCompat.mChainId = blockchainID;
        return blockchainID;
    }

    static /* synthetic */ String access$102(CheckTransactionCompat checkTransactionCompat, String string) {
        checkTransactionCompat.mCoin = string;
        return string;
    }

    static /* synthetic */ BigInteger access$202(CheckTransactionCompat checkTransactionCompat, BigInteger bigInteger) {
        checkTransactionCompat.mValue = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$302(CheckTransactionCompat checkTransactionCompat, BigInteger bigInteger) {
        checkTransactionCompat.mDueBlock = bigInteger;
        return bigInteger;
    }

    public void cleanup() {
        CheckTransactionCompat checkTransactionCompat = this;
        checkTransactionCompat.mPassphrase = null;
        checkTransactionCompat.mNonce = null;
        checkTransactionCompat.mDueBlock = null;
        checkTransactionCompat.mCoin = null;
        checkTransactionCompat.mValue = null;
        checkTransactionCompat.mLock = null;
        checkTransactionCompat.mSignature = null;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public BytesData getNonce() {
        return this.mNonce;
    }

    public BigInteger getNonceNumeric() {
        return new BigInteger(new String(this.mNonce.getData()));
    }

    public BlockchainID getChainId() {
        return this.mChainId;
    }

    public BigInteger getDueBlock() {
        return this.mDueBlock;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public BigDecimal getValue() {
        return Transaction.humanizeValue(this.mValue);
    }

    public SignatureSingleData getSignature() {
        return this.mSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransactionSign sign(PrivateKey object) {
        SignatureSingleData signatureSingleData;
        String string;
        Object object2 = new BytesData(((CheckTransactionCompat)((Object)string)).encode(true)).sha3Data();
        Object object3 = new BytesData(((CheckTransactionCompat)((Object)string)).mPassphrase.getBytes()).sha256Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            object2 = object2.getBytes();
            object2 = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])object2, (byte[])object3.getBytes());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        object3 = object2.v;
        int n = 0;
        boolean bl = object2.v[0] != 27;
        object3[n] = (BytesData)bl;
        byte[][] byArrayArray = new byte[3][];
        object3 = byArrayArray;
        object3[0] = (BytesData)object2.r;
        object3[1] = (BytesData)object2.s;
        byArrayArray[2] = object2.v;
        ((CheckTransactionCompat)((Object)string)).mLock = new BytesData((byte[][])byArrayArray);
        object2 = new BytesData(((CheckTransactionCompat)((Object)string)).encode(false)).sha3Mutable();
        long l2 = NativeSecp256k1.contextCreate();
        try {
            PrivateKey privateKey = object;
            object = object2.getBytes();
            object = NativeSecp256k1.signRecoverableSerialized((long)l2, (byte[])object, (byte[])privateKey.getBytes());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l2);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l2);
        Object object4 = object2 = signatureSingleData;
        object4();
        ((CheckTransactionCompat)((Object)string)).mSignature = object4;
        signatureSingleData.setSign((NativeSecp256k1.RecoverableSignature)object);
        string = new BytesData(((CheckTransactionCompat)((Object)string)).encode(false)).toHexString("Mc");
        return new TransactionSign(string);
    }

    public BytesData getLock() {
        return this.mLock;
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    public static final class Builder {
        private CheckTransactionCompat mCheck;

        public Builder(BigInteger bigInteger, String string) {
            this(new BytesData(bigInteger.toString(10).getBytes()), string);
        }

        public Builder(CharSequence charSequence, String string) {
            this(new BytesData(charSequence.toString().getBytes()), string);
        }

        public Builder(BytesData bytesData, String string) {
            this.mCheck = new CheckTransactionCompat(bytesData, string);
            CheckTransactionCompat.access$002(this.mCheck, BuildConfig.BLOCKCHAIN_ID);
        }

        public Builder setChainId(BlockchainID blockchainID) {
            Builder builder = this;
            Preconditions.checkNotNull((Object)((Object)blockchainID), (String)"chain id is null");
            CheckTransactionCompat.access$002(builder.mCheck, blockchainID);
            return builder;
        }

        public Builder setCoin(@Nonnull String string) {
            boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid coin passed: %s", objectArray2));
            CheckTransactionCompat.access$102(objectArray2.mCheck, StringHelper.strrpad((int)10, (String)string));
            return objectArray2;
        }

        public Builder setValue(BigDecimal bigDecimal) {
            Builder builder = this;
            CheckTransactionCompat.access$202(builder.mCheck, Transaction.normalizeValue(bigDecimal));
            return builder;
        }

        public Builder setValue(CharSequence charSequence) {
            return this.setValue(new BigDecimal(charSequence.toString()));
        }

        public Builder setDueBlock(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransactionCompat.access$302(builder.mCheck, bigInteger);
            return builder;
        }

        public CheckTransactionCompat build() {
            Builder builder = this;
            Preconditions.checkNotNull((Object)builder.mCheck.mValue, (String)"Value must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mDueBlock, (String)"Due block must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mNonce, (String)"Nonce required");
            Preconditions.checkNotNull((Object)builder.mCheck.mPassphrase, (String)"Passphrase required");
            return builder.mCheck;
        }
    }
}

