/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainApi;
import network.minter.blockchain.api.BlockChainEventEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.EventList;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.data.DataRepository;
import network.minter.core.internal.log.Mint;
import retrofit2.Call;

public class BlockChainEventRepository
extends DataRepository<BlockChainEventEndpoint>
implements DataRepository.Configurator {
    public BlockChainEventRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public void configure(ApiService.Builder builder) {
        EventTypeDeserializer eventTypeDeserializer;
        Object object = eventTypeDeserializer;
        eventTypeDeserializer = new EventTypeDeserializer(MinterBlockChainApi.getInstance().getGsonBuilder());
        builder.registerTypeAdapter(EventList.class, object);
    }

    public Call<BCResult<EventList>> getEvents(long l) {
        return ((BlockChainEventEndpoint)this.getInstantService()).getByHeight(l);
    }

    @Nonnull
    protected Class<BlockChainEventEndpoint> getServiceClass() {
        return BlockChainEventEndpoint.class;
    }

    public static final class EventTypeDeserializer
    implements JsonDeserializer<EventList> {
        private final Gson mGson;

        EventTypeDeserializer(GsonBuilder gsonBuilder) {
            this.mGson = gsonBuilder.create();
        }

        public EventList deserialize(JsonElement jsonElement, Type object, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            EventList eventList;
            object = eventList;
            new EventList().events = new ArrayList<EventList.EventItem>(0);
            if (!jsonElement.isJsonNull() && !jsonElement.getAsJsonObject().isJsonNull() && jsonElement.getAsJsonObject().has("events")) {
                jsonElement = jsonElement.getAsJsonObject().get("events").getAsJsonArray();
                for (int i = 0; i < jsonElement.size(); ++i) {
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray;
                    objectArray2();
                    JsonObject jsonObject = jsonElement.get(i).getAsJsonObject();
                    objectArray.type = EventList.Type.findByName(jsonObject.get("type").getAsString());
                    if (objectArray.type == null) {
                        Object[] objectArray3 = new Object[1];
                        objectArray2 = objectArray3;
                        objectArray3[0] = jsonObject.get("type").getAsString();
                        Mint.e((String)"Unknown event type: %s", (Object[])objectArray2);
                        continue;
                    }
                    jsonObject = jsonObject.get("value").getAsJsonObject();
                    objectArray2.value = (EventList.BaseEvent)this.mGson.fromJson((JsonElement)jsonObject, objectArray2.type.getCls());
                    ((EventList)object).events.add((EventList.EventItem)objectArray2);
                }
                return object;
            }
            return object;
        }
    }
}

