/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCreateCoin
extends Operation {
    public static final Parcelable.Creator<TxCreateCoin> CREATOR = new Parcelable.Creator<TxCreateCoin>(){

        public Object[] newArray(int n) {
            return new TxCreateCoin[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new TxCreateCoin(parcel);
        }
    };
    private String mName;
    private String mSymbol;
    private BigInteger mInitialAmount;
    private BigInteger mInitialReserve;
    private Integer mConstantReserveRatio;
    private BigInteger mMaxSupply = BigInteger.ZERO;

    public TxCreateCoin() {
    }

    public TxCreateCoin(Transaction transaction) {
        super(transaction);
    }

    protected TxCreateCoin(Parcel parcel) {
        super(parcel);
        this.mName = parcel.readString();
        this.mSymbol = parcel.readString();
        this.mInitialAmount = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mInitialReserve = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        Integer n = parcel.readByte() == 0 ? null : Integer.valueOf(parcel.readInt());
        this.mConstantReserveRatio = n;
        this.mMaxSupply = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    public static BigDecimal calculateCreatingCost(String object) {
        Preconditions.checkArgument((((String)object).length() >= 3 && ((String)object).length() <= 10 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 characters");
        switch (((String)object).length()) {
            default: {
                BigDecimal bigDecimal;
                object = bigDecimal;
                bigDecimal = new BigDecimal("100");
                break;
            }
            case 6: {
                BigDecimal bigDecimal;
                object = bigDecimal;
                bigDecimal = new BigDecimal("1000");
                break;
            }
            case 5: {
                BigDecimal bigDecimal;
                object = bigDecimal;
                bigDecimal = new BigDecimal("10000");
                break;
            }
            case 4: {
                BigDecimal bigDecimal;
                object = bigDecimal;
                bigDecimal = new BigDecimal("100000");
                break;
            }
            case 3: {
                BigDecimal bigDecimal;
                object = bigDecimal;
                bigDecimal = new BigDecimal("1000000");
            }
        }
        return ((BigDecimal)object).multiply(OperationType.CreateCoin.getFee());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCreateCoin txCreateCoin = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txCreateCoin.mName);
        parcel.writeString(this.mSymbol);
        parcel.writeValue((Object)this.mInitialAmount);
        parcel.writeValue((Object)this.mInitialReserve);
        if (this.mConstantReserveRatio == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeInt(this.mConstantReserveRatio.intValue());
        }
        parcel.writeValue((Object)this.mMaxSupply);
    }

    public String getName() {
        return this.mName;
    }

    public TxCreateCoin setName(String string) {
        this.mName = string;
        return this;
    }

    public String getSymbol() {
        return this.mSymbol.replace("\u0000", "");
    }

    public TxCreateCoin setSymbol(String string) {
        this.mSymbol = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigDecimal getInitialAmount() {
        return Transaction.humanizeValue(this.mInitialAmount);
    }

    public TxCreateCoin setInitialAmount(String string) {
        return this.setInitialAmount(new BigDecimal(string));
    }

    public TxCreateCoin setInitialAmount(BigDecimal bigDecimal) {
        return this.setInitialAmount(Transaction.normalizeValue(bigDecimal));
    }

    public TxCreateCoin setInitialAmount(BigInteger bigInteger) {
        this.mInitialAmount = bigInteger;
        return this;
    }

    public BigDecimal getMaxSupply() {
        return Transaction.humanizeValue(this.mMaxSupply);
    }

    public TxCreateCoin setMaxSupply(BigInteger bigInteger) {
        this.mMaxSupply = bigInteger;
        return this;
    }

    public TxCreateCoin setMaxSupply(BigDecimal bigDecimal) {
        this.mMaxSupply = Transaction.normalizeValue(bigDecimal);
        return this;
    }

    public TxCreateCoin setMaxSupply(String string) {
        this.mMaxSupply = Transaction.normalizeValue(new BigDecimal(string));
        return this;
    }

    public BigDecimal getInitialReserve() {
        return Transaction.humanizeValue(this.mInitialReserve);
    }

    public TxCreateCoin setInitialReserve(BigDecimal bigDecimal) {
        return this.setInitialReserve(Transaction.normalizeValue(bigDecimal));
    }

    public TxCreateCoin setInitialReserve(BigInteger bigInteger) {
        this.mInitialReserve = bigInteger;
        return this;
    }

    public TxCreateCoin setInitialReserve(String string) {
        return this.setInitialReserve(new BigDecimal(string));
    }

    public int getConstantReserveRatio() {
        return this.mConstantReserveRatio;
    }

    public TxCreateCoin setConstantReserveRatio(Integer n) {
        Preconditions.checkArgument((n >= 0 && n <= 100 ? 1 : 0) != 0, (Object)"Ratio must be unsigned integer (from 1 to 100%)");
        this.mConstantReserveRatio = n;
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.CreateCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        FieldsValidationResult fieldsValidationResult2 = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mName";
        boolean bl = this.mName != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl, "Coin mName must be set");
        string = "mSymbol";
        String string2 = this.mSymbol;
        boolean bl2 = string2 != null && string2.length() > 2 && this.mSymbol.length() < 11;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Coin mSymbol length must be from 3 to 10 chars");
        string = "mInitialAmount";
        bl2 = this.mInitialAmount != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Initial Amount must be set");
        string = "mInitialReserve";
        bl2 = this.mInitialReserve != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Initial Reserve must be set");
        string = "mMaxSupply";
        bl2 = this.mMaxSupply != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Maximum supply value must be set");
        string = "mConstantReserveRatio";
        bl2 = this.mConstantReserveRatio != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Reserve ratio must be set");
        string = "mConstantReserveRatio";
        Integer n = this.mConstantReserveRatio;
        boolean bl3 = n != null && n > 1 && this.mConstantReserveRatio <= 100;
        return fieldsValidationResult2.addResult(string, bl3, "Reserve ratio must from 1% to 100%");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mName;
        objectArray2[1] = this.mSymbol;
        objectArray2[2] = this.mInitialAmount;
        objectArray2[3] = this.mInitialReserve;
        objectArray2[4] = this.mConstantReserveRatio;
        objectArray[5] = this.mMaxSupply;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mName = StringHelper.charsToString((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mSymbol = StringHelper.charsToString((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mInitialAmount = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mInitialReserve = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
        objectArray2.mConstantReserveRatio = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(4, objectArray3)).intValue();
        objectArray2.mMaxSupply = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(5, objectArray3));
    }
}

