/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxSendCoin
extends Operation {
    public static final Parcelable.Creator<TxSendCoin> CREATOR = new Parcelable.Creator<TxSendCoin>(){

        public Object[] newArray(int n) {
            return new TxSendCoin[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new TxSendCoin(parcel);
        }
    };
    private String mCoin = "MNT";
    private MinterAddress mTo;
    private BigInteger mValue;

    public TxSendCoin() {
    }

    public TxSendCoin(Transaction transaction) {
        super(transaction);
    }

    protected TxSendCoin(Parcel parcel) {
        super(parcel);
        this.mCoin = parcel.readString();
        this.mTo = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mValue = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    private TxSendCoin setValue(BigInteger bigInteger) {
        this.mValue = bigInteger;
        return this;
    }

    public BigDecimal getValue() {
        return Transaction.humanizeValue(this.mValue);
    }

    public TxSendCoin setValue(@Nonnull CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        return this.setValue(new BigDecimal(charSequence.toString()));
    }

    public TxSendCoin setValue(BigDecimal bigDecimal) {
        this.mValue = Transaction.normalizeValue(bigDecimal);
        return this;
    }

    public String getCoinRaw() {
        return this.mCoin;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxSendCoin txSendCoin = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txSendCoin.mCoin);
        parcel.writeValue((Object)this.mTo);
        parcel.writeValue((Object)this.mValue);
    }

    public BigInteger getValueBigInteger() {
        return this.mValue;
    }

    public MinterAddress getTo() {
        return new MinterAddress(this.mTo);
    }

    public TxSendCoin setTo(CharSequence charSequence) {
        return this.setTo(charSequence.toString());
    }

    public TxSendCoin setTo(MinterAddress minterAddress) {
        this.mTo = minterAddress;
        return this;
    }

    public TxSendCoin setTo(String string) {
        return this.setTo(new MinterAddress((CharSequence)string));
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxSendCoin setCoin(String string) {
        boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid coin passed: %s", objectArray2));
        objectArray2.mCoin = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return objectArray2;
    }

    public TxSendCoin setRawValue(String string, int n) {
        this.mValue = new BigInteger(string, n);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.SendCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoin";
        String string2 = ((TxSendCoin)((Object)fieldsValidationResult2)).mCoin;
        boolean bl = string2 != null && string2.length() > 2 && ((TxSendCoin)((Object)fieldsValidationResult2)).mCoin.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin symbol length must be from 3 mTo 10 chars");
        string = "mTo";
        bl = ((TxSendCoin)((Object)fieldsValidationResult2)).mTo != null;
        TxSendCoin txSendCoin = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Recipient address must be set");
        object = "mValue";
        boolean bl2 = txSendCoin.mValue != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Value must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoin;
        objectArray2[1] = this.mTo;
        objectArray[2] = this.mValue;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxSendCoin txSendCoin = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txSendCoin.mCoin = StringHelper.charsToString((char[])txSendCoin.fromRawRlp(0, objectArray));
        txSendCoin.mTo = new MinterAddress(this.fromRawRlp(1, objectArray));
        txSendCoin.mValue = BytesHelper.fixBigintSignedByte((char[])txSendCoin.fromRawRlp(2, objectArray));
    }

    protected void decodeRaw(char[][] cArray) {
        TxSendCoin txSendCoin = this;
        txSendCoin.mCoin = new String(cArray[0]);
        txSendCoin.mTo = new MinterAddress(cArray[1]);
        this.mValue = BytesHelper.fixBigintSignedByte((char[])cArray[2]);
    }
}

