/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxUnbound
extends Operation {
    public static final Parcelable.Creator<TxUnbound> CREATOR = new Parcelable.Creator<TxUnbound>(){

        public TxUnbound createFromParcel(Parcel in) {
            return new TxUnbound(in);
        }

        public TxUnbound[] newArray(int size) {
            return new TxUnbound[size];
        }
    };
    private PublicKey mPubKey;
    private String mCoin;
    private BigInteger mValue;

    public TxUnbound(Transaction rawTx) {
        super(rawTx);
    }

    protected TxUnbound(Parcel in) {
        super(in);
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
        this.mCoin = in.readString();
        this.mValue = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mPubKey);
        dest.writeString(this.mCoin);
        dest.writeValue((Object)this.mValue);
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxUnbound setPublicKey(byte[] publicKey) {
        this.mPubKey = new PublicKey(publicKey);
        return this;
    }

    public TxUnbound setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public TxUnbound setPublicKey(String hexPubKey) {
        this.mPubKey = new PublicKey((CharSequence)hexPubKey);
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxUnbound setCoin(String coinName) {
        this.mCoin = StringHelper.strrpad((int)10, (String)coinName.toUpperCase());
        return this;
    }

    public BigInteger getValueBigInteger() {
        return this.mValue;
    }

    public BigDecimal getValue() {
        return Transaction.VALUE_MUL_DEC.divide(new BigDecimal(this.mValue));
    }

    public TxUnbound setValue(BigDecimal stakeDecimal) {
        this.mValue = stakeDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    public TxUnbound setValue(BigInteger stakeBigInteger) {
        this.mValue = stakeBigInteger;
        return this;
    }

    public TxUnbound setValue(String stakeBigInteger) {
        this.mValue = new BigInteger(stakeBigInteger);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.Unbound;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoin", this.mCoin != null && this.mCoin.length() > 2 && this.mCoin.length() < 11, "Coin symbol length must be from 3 to 10 chars").addResult("mPubKey", this.mPubKey != null, "Node Public key must be set").addResult("mValue", this.mValue != null, "Value must be set");
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mPubKey.getData(), this.mCoin, this.mValue});
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mPubKey = new PublicKey(this.fromRawRlp(0, decoded));
        this.mCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(1, decoded));
        this.mValue = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded));
    }
}

