/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Optional;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class IRI
implements OWLAnnotationSubject,
OWLAnnotationValue,
SWRLPredicate,
CharSequence,
OWLPrimitive,
HasShortForm {
    private static final AtomicLong COUNTER = new AtomicLong(System.nanoTime());
    private static final long serialVersionUID = 40000L;
    private static final LoadingCache<String, String> PREFIX_CACHE = Caffeine.newBuilder().maximumSize(ConfigurationOptions.CACHE_SIZE.getValue(Integer.class, Collections.emptyMap()).longValue()).build(k -> k);
    @Nonnull
    private final String remainder;
    @Nonnull
    private final String namespace;

    @Override
    public boolean isIRI() {
        return true;
    }

    @Nonnull
    public URI toURI() {
        return URI.create(this.namespace + this.remainder);
    }

    public boolean isAbsolute() {
        int colonIndex = this.namespace.indexOf(58);
        if (colonIndex == -1) {
            return false;
        }
        for (int i = 0; i < colonIndex; ++i) {
            char ch = this.namespace.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String getScheme() {
        int colonIndex = this.namespace.indexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        return this.namespace.substring(0, colonIndex);
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public IRI resolve(@Nonnull String s) {
        URI uri = URI.create(s);
        if (uri.isAbsolute() || uri.isOpaque()) {
            return IRI.create(uri);
        }
        return IRI.create(this.toURI().resolve(uri));
    }

    public boolean isReservedVocabulary() {
        return Namespaces.OWL.inNamespace(this.namespace) || Namespaces.RDF.inNamespace(this.namespace) || Namespaces.RDFS.inNamespace(this.namespace) || Namespaces.XSD.inNamespace(this.namespace);
    }

    public boolean isThing() {
        return this.equals(OWLRDFVocabulary.OWL_THING.getIRI());
    }

    public boolean isNothing() {
        return this.equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isPlainLiteral() {
        return this.remainder.equals("PlainLiteral") && Namespaces.RDF.inNamespace(this.namespace);
    }

    @Nonnull
    public String getFragment() {
        return this.remainder;
    }

    @Nonnull
    public Optional<String> getRemainder() {
        if (this.remainder.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.remainder);
    }

    @Nonnull
    public String toQuotedString() {
        return '<' + this.namespace + this.remainder + '>';
    }

    @Nonnull
    public static IRI create(@Nonnull String str) {
        OWLAPIPreconditions.checkNotNull(str, "str cannot be null");
        int index = XMLUtils.getNCNameSuffixIndex(str);
        if (index < 0) {
            return new IRI(str, "");
        }
        return new IRI(str.substring(0, index), str.substring(index));
    }

    @Nonnull
    public static IRI create(@Nullable String prefix, @Nullable String suffix) {
        if (prefix == null && suffix == null) {
            throw new IllegalArgumentException("prefix and suffix cannot both be null");
        }
        if (prefix == null) {
            assert (suffix != null);
            return IRI.create(suffix);
        }
        if (suffix == null) {
            return IRI.create(prefix);
        }
        int index = XMLUtils.getNCNameSuffixIndex(prefix);
        int test = XMLUtils.getNCNameSuffixIndex(suffix);
        if (index == -1 && test == 0) {
            return new IRI(prefix, suffix);
        }
        return IRI.create(prefix + suffix);
    }

    @Nonnull
    public static IRI create(@Nonnull File file) {
        OWLAPIPreconditions.checkNotNull(file, "file cannot be null");
        return new IRI(file.toURI());
    }

    @Nonnull
    public static IRI create(@Nonnull URI uri) {
        OWLAPIPreconditions.checkNotNull(uri, "uri cannot be null");
        return new IRI(uri);
    }

    @Nonnull
    public static IRI create(@Nonnull URL url) {
        OWLAPIPreconditions.checkNotNull(url, "url cannot be null");
        try {
            return new IRI(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Nonnull
    public static IRI generateDocumentIRI() {
        return IRI.create("owlapi:ontology" + COUNTER.incrementAndGet());
    }

    protected IRI(@Nonnull String prefix, @Nullable String suffix) {
        this.namespace = (String)PREFIX_CACHE.get((Object)prefix);
        this.remainder = suffix == null ? "" : suffix;
    }

    @Nonnull
    protected Optional<String> asOptional(String suffix) {
        if (suffix == null) {
            return Optional.absent();
        }
        if (suffix.isEmpty()) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)suffix);
    }

    protected IRI(@Nonnull String s) {
        this(XMLUtils.getNCNamePrefix(s), XMLUtils.getNCNameSuffix(s));
    }

    protected IRI(@Nonnull URI uri) {
        this(OWLAPIPreconditions.checkNotNull(uri, "uri cannot be null").toString());
    }

    @Override
    public int length() {
        return this.namespace.length() + this.remainder.length();
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < this.namespace.length()) {
            return this.namespace.charAt(index);
        }
        return this.remainder.charAt(index - this.namespace.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.namespace);
        sb.append(this.remainder);
        return sb.subSequence(start, end);
    }

    @Nonnull
    public String prefixedBy(@Nonnull String prefix) {
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        if (this.remainder.isEmpty()) {
            return prefix;
        }
        return prefix + this.remainder;
    }

    @Override
    @Nonnull
    public String getShortForm() {
        if (!this.remainder.isEmpty()) {
            return this.remainder;
        }
        int lastSlashIndex = this.namespace.lastIndexOf(47);
        if (lastSlashIndex != -1 && lastSlashIndex != this.namespace.length() - 1) {
            return this.namespace.substring(lastSlashIndex + 1);
        }
        return this.toQuotedString();
    }

    @Override
    public void accept(@Nonnull OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@Nonnull OWLAnnotationSubjectVisitor visitor) {
        visitor.visit(this);
    }

    public <E> E accept(@Nonnull OWLAnnotationSubjectVisitorEx<E> visitor) {
        return visitor.visit(this);
    }

    @Override
    @Nonnull
    public Set<OWLClass> getClassesInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLEntity> getSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return false;
    }

    @Override
    @Nonnull
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    @Override
    @Nonnull
    public Set<OWLClassExpression> getNestedClassExpressions() {
        return CollectionFactory.emptySet();
    }

    @Override
    public int compareTo(OWLObject o) {
        if (o == this || this.equals(o)) {
            return 0;
        }
        if (!(o instanceof IRI)) {
            return -1;
        }
        IRI other = (IRI)o;
        int diff = this.namespace.compareTo(other.namespace);
        if (diff != 0) {
            return diff;
        }
        return this.remainder.compareTo(other.remainder);
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.remainder.isEmpty()) {
            return this.namespace;
        }
        return this.namespace + this.remainder;
    }

    public int hashCode() {
        return this.namespace.hashCode() + this.remainder.hashCode();
    }

    @Override
    public void accept(@Nonnull OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(@Nonnull OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.of((Object)this);
    }

    @Override
    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.absent();
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IRI)) {
            return false;
        }
        IRI other = (IRI)obj;
        return this.remainder.equals(other.remainder) && other.namespace.equals(this.namespace);
    }
}

