/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntitySerializer<E extends OWLEntity>
extends OWLObjectSerializer<E> {
    private EntityType<E> entityType;

    public OWLEntitySerializer(EntityType<E> entityType) {
        this.entityType = entityType;
    }

    @Override
    protected void writeObject(E object, BinaryOWLOutputStream outputStream) throws IOException {
        IRI iri = object.getIRI();
        outputStream.writeIRI(iri);
    }

    @Override
    protected E readObject(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        if (this.entityType == EntityType.CLASS) {
            return (E)inputStream.readClassIRI();
        }
        if (this.entityType == EntityType.OBJECT_PROPERTY) {
            return (E)inputStream.readObjectPropertyIRI();
        }
        if (this.entityType == EntityType.ANNOTATION_PROPERTY) {
            return (E)inputStream.readAnnotationPropertyIRI();
        }
        if (this.entityType == EntityType.DATA_PROPERTY) {
            return (E)inputStream.readDataPropertyIRI();
        }
        if (this.entityType == EntityType.DATATYPE) {
            return (E)inputStream.readDatatypeIRI();
        }
        if (this.entityType == EntityType.NAMED_INDIVIDUAL) {
            return (E)inputStream.readIndividualIRI();
        }
        IRI iri = inputStream.readIRI();
        return (E)inputStream.getDataFactory().getOWLEntity(this.entityType, iri);
    }
}

