/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.lookup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.binaryowl.doc.OWLOntologyDocument;
import org.semanticweb.binaryowl.lookup.IRILookupTable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;

public class LiteralLookupTable {
    private boolean useInterning = false;
    private static final byte INTERNING_NOT_USED_MARKER = 0;
    private static final byte INTERNING_USED_MARKER = 1;
    public static final String UTF_8 = "UTF-8";
    public static final byte NOT_INDEXED_MARKER = -2;
    private static final byte RDF_PLAIN_LITERAL_MARKER = 0;
    private static final byte XSD_STRING_MARKER = 1;
    private static final byte XSD_BOOLEAN_MARKER = 2;
    private static final byte OTHER_DATATYPE_MARKER = 3;
    private static final byte LANG_MARKER = 1;
    private static final byte NO_LANG_MARKER = 0;
    private Map<OWLLiteral, Integer> indexMap = new LinkedHashMap<OWLLiteral, Integer>();
    private List<OWLLiteral> tableList = new ArrayList<OWLLiteral>(0);
    private IRILookupTable iriLookupTable;
    private static final OWLDatatype RDF_PLAIN_LITERAL_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    private static final OWLDatatype XSD_STRING_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.XSD_STRING.getIRI());
    private static final OWLDatatype XSD_BOOLEAN_DATATYPE = new OWLDatatypeImpl(OWL2Datatype.XSD_BOOLEAN.getIRI());
    private static final OWLLiteral BOOLEAN_TRUE = new OWLLiteralImplNoCompression("true", null, XSD_BOOLEAN_DATATYPE);
    private static final OWLLiteral BOOLEAN_FALSE = new OWLLiteralImplNoCompression("false", null, XSD_BOOLEAN_DATATYPE);

    public LiteralLookupTable(OWLOntologyDocument ontology, IRILookupTable lookupTable) {
        this.iriLookupTable = lookupTable;
        if (this.useInterning) {
            this.internLiterals(ontology);
        }
    }

    private void internLiterals(OWLOntologyDocument ontology) {
        for (OWLAnnotationAssertionAxiom ax : ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            int newIndex;
            OWLLiteral litValue;
            Integer prev;
            OWLAnnotationValue value = ax.getValue();
            if (!(value instanceof OWLLiteral) || (prev = this.indexMap.put(litValue = (OWLLiteral)value, newIndex = this.indexMap.size())) == null) continue;
            this.indexMap.put(litValue, prev);
        }
        for (OWLAnnotationAssertionAxiom ax : ontology.getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
            int newIndex = this.indexMap.size();
            OWLLiteral object = (OWLLiteral)ax.getObject();
            Integer prev = this.indexMap.put(object, newIndex);
            if (prev == null) continue;
            this.indexMap.put(object, prev);
        }
    }

    public LiteralLookupTable(IRILookupTable iriLookupTable) {
        this.iriLookupTable = iriLookupTable;
    }

    public LiteralLookupTable(IRILookupTable iriLookupTable, DataInput dis, OWLDataFactory df) throws IOException {
        this(iriLookupTable);
        this.read(dis, df);
    }

    public LiteralLookupTable() {
        this(new IRILookupTable());
    }

    public OWLLiteral getLiteral(int index) {
        return this.tableList.get(index);
    }

    public int getIndex(OWLLiteral literal) {
        if (!this.useInterning) {
            return -1;
        }
        Integer i = this.indexMap.get(literal);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public void write(DataOutputStream os) throws IOException {
        if (this.useInterning) {
            os.writeByte(1);
            os.writeInt(this.indexMap.size());
            for (OWLLiteral literal : this.indexMap.keySet()) {
                this.writeRawLiteral(os, literal);
            }
        } else {
            os.writeByte(0);
        }
    }

    private void read(DataInput is, OWLDataFactory df) throws IOException {
        byte interningMarker = is.readByte();
        if (interningMarker == 1) {
            this.useInterning = true;
        } else if (interningMarker == 0) {
            this.useInterning = false;
        } else {
            throw new IOException("Unexpected literal interning marker: " + interningMarker);
        }
        if (this.useInterning) {
            int size = is.readInt();
            this.tableList = new ArrayList<OWLLiteral>(size + 2);
            for (int i = 0; i < size; ++i) {
                OWLLiteral literal = this.readRawLiteral(is, df);
                this.tableList.add(literal);
            }
        }
    }

    public OWLLiteral readLiteral(DataInput is, OWLDataFactory df) throws IOException {
        if (this.useInterning) {
            int index = is.readInt();
            if (index == -2) {
                return this.readRawLiteral(is, df);
            }
            return this.tableList.get(index);
        }
        return this.readRawLiteral(is, df);
    }

    private OWLLiteral readRawLiteral(DataInput is, OWLDataFactory df) throws IOException {
        byte typeMarker = is.readByte();
        if (typeMarker == 0) {
            byte langMarker = is.readByte();
            if (langMarker == 1) {
                String lang = is.readUTF();
                byte[] literalBytes = this.readBytes(is);
                return new OWLLiteralImplNoCompression(new String(literalBytes), lang, RDF_PLAIN_LITERAL_DATATYPE);
            }
            if (langMarker == 0) {
                byte[] literalBytes = this.readBytes(is);
                return new OWLLiteralImplNoCompression(new String(literalBytes), null, RDF_PLAIN_LITERAL_DATATYPE);
            }
            throw new IOException("Unknown lang marker: " + langMarker);
        }
        if (typeMarker == 1) {
            byte[] literalBytes = this.readBytes(is);
            return new OWLLiteralImplNoCompression(new String(literalBytes), null, XSD_STRING_DATATYPE);
        }
        if (typeMarker == 2) {
            if (is.readBoolean()) {
                return BOOLEAN_TRUE;
            }
            return BOOLEAN_FALSE;
        }
        if (typeMarker == 3) {
            OWLDatatype datatype = this.iriLookupTable.readDataypeIRI(is);
            byte[] literalBytes = this.readBytes(is);
            return new OWLLiteralImplNoCompression(new String(literalBytes), null, datatype);
        }
        throw new RuntimeException("Unknown type marker: " + typeMarker);
    }

    public void writeLiteral(DataOutput os, OWLLiteral literal) throws IOException {
        if (this.useInterning) {
            int index = this.getIndex(literal);
            if (index == -1) {
                os.writeInt(-2);
                this.writeRawLiteral(os, literal);
            } else {
                os.writeInt(index);
            }
        } else {
            this.writeRawLiteral(os, literal);
        }
    }

    private void writeRawLiteral(DataOutput os, OWLLiteral literal) throws IOException {
        if (literal.getDatatype().equals(XSD_BOOLEAN_DATATYPE)) {
            os.write(2);
            os.writeBoolean(literal.parseBoolean());
            return;
        }
        if (literal.isRDFPlainLiteral()) {
            os.write(0);
            if (literal.hasLang()) {
                os.write(1);
                this.writeString(literal.getLang(), os);
            } else {
                os.write(0);
            }
        } else if (literal.getDatatype().equals(XSD_STRING_DATATYPE)) {
            os.write(1);
        } else {
            os.write(3);
            this.iriLookupTable.writeIRI(literal.getDatatype().getIRI(), os);
        }
        byte[] literalBytes = literal instanceof OWLLiteralImplNoCompression ? ((OWLLiteralImplNoCompression)literal).getLiteral().getBytes(UTF_8) : literal.getLiteral().getBytes(UTF_8);
        this.writeBytes(literalBytes, os);
    }

    private void writeString(String s, DataOutput os) throws IOException {
        os.writeUTF(s);
    }

    private void writeBytes(byte[] bytes, DataOutput os) throws IOException {
        os.writeShort(bytes.length);
        os.write(bytes);
    }

    private byte[] readBytes(DataInput is) throws IOException {
        short length = is.readShort();
        byte[] bytes = new byte[length];
        is.readFully(bytes);
        return bytes;
    }
}

