/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.navigate.CopyPathsAction;
import net.minidev.json.actions.navigate.JSONNavigateAction;
import net.minidev.json.actions.navigate.JSONNavigator;

public class PathReplicator {
    protected List<String> pathsToCopy;

    public PathReplicator(JSONArray pathsToCopy) {
        if (pathsToCopy == null || pathsToCopy.isEmpty()) {
            this.pathsToCopy = Collections.emptyList();
        } else {
            this.pathsToCopy = new LinkedList<String>();
            for (Object s : pathsToCopy) {
                this.pathsToCopy.add((String)s);
            }
        }
    }

    public PathReplicator(List<String> pathsToCopy) {
        this.pathsToCopy = pathsToCopy == null || pathsToCopy.size() == 0 ? Collections.emptyList() : pathsToCopy;
    }

    public PathReplicator(String ... pathsToCopy) {
        this.pathsToCopy = pathsToCopy == null || pathsToCopy.length == 0 ? Collections.emptyList() : new LinkedList<String>(Arrays.asList(pathsToCopy));
    }

    public JSONObject replicate(JSONObject sourceObj) throws Exception {
        CopyPathsAction s = new CopyPathsAction();
        JSONNavigator n = new JSONNavigator((JSONNavigateAction)s, this.pathsToCopy);
        n.nav(sourceObj);
        return (JSONObject)s.result();
    }
}

