/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.actions.traverse.JSONTraverser;
import net.minidev.json.actions.traverse.RemovePathsJsonAction;

public class PathRemover {
    protected List<String> pathsToRemove;

    public PathRemover(JSONArray pathsToRemove) {
        if (pathsToRemove == null || pathsToRemove.isEmpty()) {
            this.pathsToRemove = Collections.emptyList();
        } else {
            this.pathsToRemove = new ArrayList<String>();
            for (Object s : pathsToRemove) {
                this.pathsToRemove.add((String)s);
            }
        }
    }

    public PathRemover(List<String> pathsToRemove) {
        this.pathsToRemove = pathsToRemove == null || pathsToRemove.size() == 0 ? Collections.emptyList() : pathsToRemove;
    }

    public PathRemover(String ... pathsToRemove) {
        this.pathsToRemove = pathsToRemove == null || pathsToRemove.length == 0 ? Collections.emptyList() : Arrays.asList(pathsToRemove);
    }

    public JSONObject remove(JSONObject objectToClean) {
        RemovePathsJsonAction strategy = new RemovePathsJsonAction(this.pathsToRemove);
        JSONTraverser traversal = new JSONTraverser(strategy);
        traversal.traverse(objectToClean);
        return (JSONObject)strategy.result();
    }
}

