/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.presentation.PresentationMode;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.sorting.SortingMethod;
import org.apache.commons.lang3.StringUtils;

public class Configuration {
    private static final String EMBEDDINGS_DIRECTORY = "embeddings";
    private File reportDirectory;
    private File trendsFile;
    private int trendsLimit;
    private String buildNumber;
    private String projectName;
    private String directorySuffix;
    private List<Map.Entry<String, String>> classifications = new ArrayList<Map.Entry<String, String>>();
    private Collection<Pattern> tagsToExcludeFromChart = new ArrayList<Pattern>();
    private SortingMethod sortingMethod = SortingMethod.NATURAL;
    private List<ReducingMethod> reducingMethods = new ArrayList<ReducingMethod>();
    private List<PresentationMode> presentationModes = new ArrayList<PresentationMode>();
    private List<String> classificationFiles;
    private Set<Status> notFailingStatuses = Collections.emptySet();
    private Map<String, String> qualifiers = new HashMap<String, String>();
    private List<String> customCssFiles = new ArrayList<String>();
    private List<String> customJsFiles = new ArrayList<String>();

    public Configuration(File reportDirectory, String projectName) {
        this.reportDirectory = reportDirectory;
        this.projectName = projectName;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public File getTrendsStatsFile() {
        return this.trendsFile;
    }

    public boolean isTrendsStatsFile() {
        return this.trendsFile != null;
    }

    public void setTrendsStatsFile(File trendsFile) {
        this.setTrends(trendsFile, 0);
    }

    public int getTrendsLimit() {
        return this.trendsLimit;
    }

    public boolean isTrendsAvailable() {
        return this.getTrendsLimit() > -1 && this.isTrendsStatsFile();
    }

    public void setTrends(File trendsFile, int limit) {
        this.trendsFile = trendsFile;
        this.trendsLimit = limit;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setDirectorySuffix(String directorySuffix) {
        this.directorySuffix = directorySuffix;
    }

    public String getDirectorySuffix() {
        return StringUtils.defaultString((String)this.directorySuffix);
    }

    public String getDirectorySuffixWithSeparator() {
        return StringUtils.isEmpty((CharSequence)this.directorySuffix) ? "" : "_" + this.directorySuffix;
    }

    public File getEmbeddingDirectory() {
        return new File(this.getReportDirectory().getAbsolutePath(), "cucumber-html-reports" + this.getDirectorySuffixWithSeparator() + File.separatorChar + EMBEDDINGS_DIRECTORY);
    }

    public Collection<Pattern> getTagsToExcludeFromChart() {
        return this.tagsToExcludeFromChart;
    }

    public void setTagsToExcludeFromChart(String ... patterns) {
        for (String pattern : patterns) {
            try {
                this.tagsToExcludeFromChart.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e);
            }
        }
    }

    public void addClassifications(String name, String value) {
        this.classifications.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    public List<Map.Entry<String, String>> getClassifications() {
        return this.classifications;
    }

    public void setSortingMethod(SortingMethod sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public SortingMethod getSortingMethod() {
        return this.sortingMethod;
    }

    public void addReducingMethod(ReducingMethod reducingMethod) {
        this.reducingMethods.add(reducingMethod);
    }

    public List<ReducingMethod> getReducingMethods() {
        return this.reducingMethods;
    }

    public boolean containsReducingMethod(ReducingMethod reducingMethod) {
        return this.reducingMethods.contains((Object)reducingMethod);
    }

    public void addPresentationModes(PresentationMode presentationMode) {
        this.presentationModes.add(presentationMode);
    }

    public boolean containsPresentationMode(PresentationMode presentationMode) {
        return this.presentationModes.contains((Object)presentationMode);
    }

    public void addClassificationFiles(List<String> classificationFiles) {
        this.classificationFiles = classificationFiles;
    }

    public List<String> getClassificationFiles() {
        return this.classificationFiles;
    }

    public Set<Status> getNotFailingStatuses() {
        return this.notFailingStatuses;
    }

    public void setNotFailingStatuses(Set<Status> notFailingStatuses) {
        if (notFailingStatuses != null) {
            this.notFailingStatuses = notFailingStatuses;
        }
    }

    public void setQualifier(String jsonFileName, String qualifier) {
        this.qualifiers.put(jsonFileName, qualifier);
    }

    public String getQualifier(String jsonFileName) {
        return this.qualifiers.get(jsonFileName);
    }

    public boolean containsQualifier(String jsonFileName) {
        return this.qualifiers.containsKey(jsonFileName);
    }

    public void removeQualifier(String jsonFileName) {
        this.qualifiers.remove(jsonFileName);
    }

    public void addCustomCssFiles(List<String> customCssFiles) {
        this.customCssFiles = customCssFiles;
    }

    public List<String> getCustomCssFiles() {
        return this.customCssFiles;
    }

    public void addCustomJsFiles(List<String> customJsFiles) {
        this.customJsFiles = customJsFiles;
    }

    public List<String> getCustomJsFiles() {
        return this.customJsFiles;
    }
}

