package mx.collections {
import flash.events.Event;
import mx.core.mx_internal;

/**
 * Dispatched when the ICollectionView has been updated in some way.
 *
 *  @eventType mx.events.CollectionEvent.COLLECTION_CHANGE
 */
[Event(name = "collectionChange", type = "mx.events.CollectionEvent")]
/**
 * The ListCollectionView class adds the properties and methods of the
 * <code>ICollectionView</code> interface to an object that conforms to the
 * <code>IList</code> interface. As a result, you can pass an object of this class
 * to anything that requires an <code>IList</code> or <code>ICollectionView</code>.
 *
 * <p>This class also lets you use [ ] array notation
 * to access the <code>getItemAt()</code> and <code>setItemAt()</code> methods.
 * If you use code such as <code>myListCollectionView[index]</code>
 * Flex calls the <code>myListCollectionView</code> object's
 * <code>getItemAt()</code> or <code>setItemAt()</code> method.</p>
 *
 * @mxml
 *
 *  <p>The <code>&lt;mx:ListCollectionView&gt;</code> has the following attributes,
 *  which all of its subclasses inherit:</p>
 *
 *  <pre>
 *  &lt;mx:ListCollectionView
 *  <b>Properties</b>
 *  filterFunction="null"
 *  list="null"
 *  sort="null"
 *  <b>Events</b>
 *  collectionChange="<i>No default</i>"
 *  /&gt;
 *  </pre>
 */
public class ListCollectionView implements mx.collections.IList {
  /**
   * @private
   *  Version string for this class.
   */
  mx_internal static const VERSION:String = "3.3.0.4852";

  public function ListCollectionView() {
    super();
  }

  public native function get length():uint;

  public native function set length(value:uint):void;

  public native function addItem(item:Object):void;

  public native function addItemAt(item:Object, index:int):void;

  public native function getItemAt(index:int, prefetch:int = 0):Object;

  public native function getItemIndex(item:Object):int;

  public native function itemUpdated(item:Object, property:Object = null, oldValue:Object = null, newValue:Object = null):void;

  public native function removeAll():void;

  public native function removeItemAt(index:int):Object;

  public native function setItemAt(item:Object, index:int):Object;

  public native function toArray():Array;

  public native function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false):void;

  public native function dispatchEvent(event:flash.events.Event):Boolean;

  public native function hasEventListener(type:String):Boolean;

  public native function removeEventListener(type:String, listener:Function, useCapture:Boolean = false):void;

  public native function willTrigger(type:String):Boolean;
}
}