package mx.resources {

[Rename("l10n.ResourceManagerImpl")]
public class ResourceManager implements mx.resources.IResourceManager {
  public static native function getInstance():mx.resources.IResourceManager;

  public native function get localeChain():Array;

  public native function set localeChain(value:Array):void;

  public native function unloadResourceModule(url:String, update:Boolean = true):void;

  public native function addResourceBundle(resourceBundle:mx.resources.IResourceBundle, useWeakReference:Boolean = false):void;

  public native function removeResourceBundle(locale:String, bundleName:String):void;

  public native function removeResourceBundlesForLocale(locale:String):void;

  public native function update():void;

  public native function getLocales():Array;

  public native function getPreferredLocaleChain():Array;

  public native function getBundleNamesForLocale(locale:String):Array;

  /**
   * @inheritDoc
   */
  public native function getResourceBundle(locale:String, bundleName:String):mx.resources.IResourceBundle;

  public native function findResourceBundleWithResource(bundleName:String, resourceName:String):mx.resources.IResourceBundle;

  [Bindable("change")]
  public native function getObject(bundleName:String, resourceName:String, locale:String = null):*;

  [Bindable("change")]
  /**
   * @inheritDoc
   */
  public native function getString(bundleName:String, resourceName:String, parameters:Array = null, locale:String = null):String;

  [Bindable("change")]
  public native function getStringArray(bundleName:String, resourceName:String, locale:String = null):Array;

  [Bindable("change")]
  public native function getNumber(bundleName:String, resourceName:String, locale:String = null):Number;

  [Bindable("change")]
  public native function getInt(bundleName:String, resourceName:String, locale:String = null):int;

  [Bindable("change")]
  public native function getUint(bundleName:String, resourceName:String, locale:String = null):uint;

  [Bindable("change")]
  public native function getBoolean(bundleName:String, resourceName:String, locale:String = null):Boolean;

  [Bindable("change")]
  public native function getClass(bundleName:String, resourceName:String, locale:String = null):Class;

  public native function initializeLocaleChain(compiledLocales:Array):void;
}
}