/*
 * Portions Copyright 2018 Thorsten Ehlers
 * Portions Copyright 2021 Doychin Bondzhev
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.idlestate.gradle.duplicates

class FileToVersion {
    final String file
    final long crc
    final String version

    FileToVersion(String file, long crc, String version) {
        this.file = file
        this.crc = crc
        this.version = version
    }

    @Override
    String toString() {
        return "file: ${file} crc: ${crc} version: ${version}"
    }
}
