/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.android;

import android.annotation.TargetApi;
import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import dalvik.system.DexClassLoader;
import dalvik.system.DexFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.utility.RandomString;

public abstract class AndroidClassLoadingStrategy
implements ClassLoadingStrategy<ClassLoader> {
    private static final String DEX_CLASS_FILE = "classes.dex";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String EMPTY_LIBRARY_PATH = null;
    private final DexProcessor dexProcessor;
    protected final File privateDirectory;
    protected final RandomString randomString;

    protected AndroidClassLoadingStrategy(File privateDirectory, DexProcessor dexProcessor) {
        if (!privateDirectory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + privateDirectory);
        }
        this.privateDirectory = privateDirectory;
        this.dexProcessor = dexProcessor;
        this.randomString = new RandomString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        DexProcessor.Conversion conversion = this.dexProcessor.create();
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            conversion.register(entry.getKey().getName(), entry.getValue());
        }
        File jar = new File(this.privateDirectory, this.randomString.nextString() + JAR_FILE_EXTENSION);
        try {
            if (!jar.createNewFile()) {
                throw new IllegalStateException("Cannot create " + jar);
            }
            JarOutputStream zipOutputStream = new JarOutputStream(new FileOutputStream(jar));
            try {
                zipOutputStream.putNextEntry(new JarEntry(DEX_CLASS_FILE));
                conversion.drainTo(zipOutputStream);
                zipOutputStream.closeEntry();
            }
            finally {
                zipOutputStream.close();
            }
            Map<TypeDescription, Class<?>> map = this.doLoad(classLoader, types.keySet(), jar);
            return map;
        }
        catch (IOException exception) {
            throw new IllegalStateException("Cannot write to zip file " + jar, exception);
        }
        finally {
            if (!jar.delete()) {
                Logger.getLogger("net.bytebuddy").warning("Could not delete " + jar);
            }
        }
    }

    protected abstract Map<TypeDescription, Class<?>> doLoad(ClassLoader var1, Set<TypeDescription> var2, File var3) throws IOException;

    @TargetApi(value=3)
    public static class Injecting
    extends AndroidClassLoadingStrategy {
        private static final int NO_FLAGS = 0;
        private static final String EXTENSION = ".data";

        public Injecting(File privateDirectory) {
            this(privateDirectory, DexProcessor.ForSdkCompiler.makeDefault());
        }

        public Injecting(File privateDirectory, DexProcessor dexProcessor) {
            super(privateDirectory, dexProcessor);
        }

        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader on Android");
            }
            return super.load(classLoader, types);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<TypeDescription, Class<?>> doLoad(ClassLoader classLoader, Set<TypeDescription> typeDescriptions, File jar) throws IOException {
            DexFile dexFile = DexFile.loadDex((String)jar.getAbsolutePath(), (String)new File(this.privateDirectory.getAbsolutePath(), this.randomString.nextString() + EXTENSION).getAbsolutePath(), (int)0);
            HashMap loadedTypes = new HashMap();
            for (TypeDescription typeDescription : typeDescriptions) {
                ClassLoader classLoader2 = classLoader;
                synchronized (classLoader2) {
                    Class type = dexFile.loadClass(typeDescription.getName(), classLoader);
                    if (type == null) {
                        throw new IllegalStateException("Could not load " + typeDescription);
                    }
                    loadedTypes.put(typeDescription, type);
                }
            }
            return loadedTypes;
        }
    }

    @TargetApi(value=3)
    public static class Wrapping
    extends AndroidClassLoadingStrategy {
        public Wrapping(File privateDirectory) {
            this(privateDirectory, DexProcessor.ForSdkCompiler.makeDefault());
        }

        public Wrapping(File privateDirectory, DexProcessor dexProcessor) {
            super(privateDirectory, dexProcessor);
        }

        @Override
        @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Android discourages the use of access controllers")
        protected Map<TypeDescription, Class<?>> doLoad(ClassLoader classLoader, Set<TypeDescription> typeDescriptions, File jar) {
            DexClassLoader dexClassLoader = new DexClassLoader(jar.getAbsolutePath(), this.privateDirectory.getAbsolutePath(), EMPTY_LIBRARY_PATH, classLoader);
            HashMap loadedTypes = new HashMap();
            for (TypeDescription typeDescription : typeDescriptions) {
                try {
                    loadedTypes.put(typeDescription, Class.forName(typeDescription.getName(), false, (ClassLoader)dexClassLoader));
                }
                catch (ClassNotFoundException exception) {
                    throw new IllegalStateException("Cannot load " + typeDescription, exception);
                }
            }
            return loadedTypes;
        }
    }

    public static interface DexProcessor {
        public Conversion create();

        public static class ForSdkCompiler
        implements DexProcessor {
            private static final int DEX_COMPATIBLE_API_VERSION = 13;
            private static final String CLASS_FILE_EXTENSION = ".class";
            private static final Writer NO_PRINT_OUTPUT = null;
            private static final boolean NOT_VERBOSE = false;
            private final DexOptions dexFileOptions;
            private final CfOptions dexCompilerOptions;

            protected static DexProcessor makeDefault() {
                DexOptions dexOptions = new DexOptions();
                dexOptions.targetApiLevel = 13;
                return new ForSdkCompiler(dexOptions, new CfOptions());
            }

            public ForSdkCompiler(DexOptions dexFileOptions, CfOptions dexCompilerOptions) {
                this.dexFileOptions = dexFileOptions;
                this.dexCompilerOptions = dexCompilerOptions;
            }

            @Override
            public net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion create() {
                return new Conversion(new com.android.dx.dex.file.DexFile(this.dexFileOptions));
            }

            protected class Conversion
            implements net.bytebuddy.android.AndroidClassLoadingStrategy$DexProcessor$Conversion {
                private static final boolean NON_STRICT = false;
                private final com.android.dx.dex.file.DexFile dexFile;

                protected Conversion(com.android.dx.dex.file.DexFile dexFile) {
                    this.dexFile = dexFile;
                }

                @Override
                public void register(String name, byte[] binaryRepresentation) {
                    DirectClassFile directClassFile = new DirectClassFile(binaryRepresentation, name.replace('.', '/') + ForSdkCompiler.CLASS_FILE_EXTENSION, false);
                    directClassFile.setAttributeFactory((AttributeFactory)new StdAttributeFactory());
                    this.dexFile.add(CfTranslator.translate((DirectClassFile)directClassFile, (byte[])binaryRepresentation, (CfOptions)ForSdkCompiler.this.dexCompilerOptions, (DexOptions)ForSdkCompiler.this.dexFileOptions, (com.android.dx.dex.file.DexFile)new com.android.dx.dex.file.DexFile(ForSdkCompiler.this.dexFileOptions)));
                }

                @Override
                public void drainTo(OutputStream outputStream) throws IOException {
                    this.dexFile.writeTo(outputStream, NO_PRINT_OUTPUT, false);
                }

                private ForSdkCompiler getOuter() {
                    return ForSdkCompiler.this;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && ForSdkCompiler.this.equals(((Conversion)other).getOuter()) && this.dexFile.equals(((Conversion)other).dexFile);
                }

                public int hashCode() {
                    return this.dexFile.hashCode() + 31 * ForSdkCompiler.this.hashCode();
                }
            }
        }

        public static interface Conversion {
            public void register(String var1, byte[] var2);

            public void drainTo(OutputStream var1) throws IOException;
        }
    }
}

