/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.api.classes_processing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public interface ProcessContext
extends Closeable {
    public File getClassesDir();

    public List<File> getClasspath();

    public ClassLoader getClasspathClassLoader();

    default public boolean doesResourceExist(String relativePath) {
        return this.readBinaryResource(relativePath) != null;
    }

    @Nullable
    public byte[] readBinaryResource(String var1);

    @Nullable
    public String readTextResource(String var1);

    public void writeBinaryResource(String var1, byte[] var2);

    public void writeTextResource(String var1, String var2);

    public void appendTextResource(String var1, String var2);

    default public void writeService(String serviceName, String implementationName) {
        this.appendTextResource("META-INF/services/" + serviceName, "\n" + implementationName);
    }

    default public void writeService(Class<?> serviceClass, String implementationName) {
        this.writeService(serviceClass.getName(), implementationName);
    }

    default public void writeService(String serviceName, Class<?> implementationClass) {
        this.writeService(serviceName, implementationClass.getName());
    }

    default public void writeService(Class<?> serviceClass, Class<?> implementationClass) {
        this.writeService(serviceClass.getName(), implementationClass.getName());
    }

    default public boolean doesClasspathResourceExist(String relativePath) {
        return this.readClasspathBinaryResource(relativePath) != null;
    }

    @Nullable
    public byte[] readClasspathBinaryResource(String var1);

    @Nullable
    public String readClasspathTextResource(String var1);

    @Override
    default public void close() throws IOException {
        ClassLoader classpathClassLoader = this.getClasspathClassLoader();
        if (classpathClassLoader instanceof Closeable) {
            ((Closeable)((Object)classpathClassLoader)).close();
        }
    }
}

