package name.remal.gradle_plugins.api.classes_processing;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.File;
import java.util.List;

public interface ProcessContext {

    @NotNull
    File getClassesDir();

    @NotNull
    List<File> getClasspath();

    default boolean isResourceExists(@NotNull String relativePath) {
        return null != readBinaryResource(relativePath);
    }

    @Nullable
    byte[] readBinaryResource(@NotNull String relativePath);

    @Nullable
    String readTextResource(@NotNull String relativePath);

    void writeBinaryResource(@NotNull String relativePath, @NotNull byte[] content);

    void writeTextResource(@NotNull String relativePath, @NotNull String text);

    void appendTextResource(@NotNull String relativePath, @NotNull String text);

    default void writeService(@NotNull String serviceName, @NotNull String implementationName) {
        appendTextResource("META-INF/services/" + serviceName, "\n" + implementationName);
    }

    default void writeService(@NotNull Class<?> serviceClass, @NotNull String implementationName) {
        writeService(serviceClass.getName(), implementationName);
    }

    default void writeService(@NotNull String serviceName, @NotNull Class<?> implementationClass) {
        writeService(serviceName, implementationClass.getName());
    }

    default void writeService(@NotNull Class<?> serviceClass, @NotNull Class<?> implementationClass) {
        writeService(serviceClass.getName(), implementationClass.getName());
    }

    default boolean isClasspathResourceExists(@NotNull String relativePath) {
        return null != readClasspathBinaryResource(relativePath);
    }

    @Nullable
    byte[] readClasspathBinaryResource(@NotNull String relativePath);

    @Nullable
    String readClasspathTextResource(@NotNull String relativePath);

}
