/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ReplicationConnectionGroup;
import com.mysql.jdbc.jmx.ReplicationGroupManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationConnectionGroupManager {
    private static HashMap<String, ReplicationConnectionGroup> GROUP_MAP = new HashMap();
    private static ReplicationGroupManager mbean = new ReplicationGroupManager();
    private static boolean hasRegisteredJmx = false;

    public static synchronized ReplicationConnectionGroup getConnectionGroupInstance(String groupName) {
        if (GROUP_MAP.containsKey(groupName)) {
            return GROUP_MAP.get(groupName);
        }
        ReplicationConnectionGroup group = new ReplicationConnectionGroup(groupName);
        GROUP_MAP.put(groupName, group);
        return group;
    }

    public static void registerJmx() throws SQLException {
        if (hasRegisteredJmx) {
            return;
        }
        mbean.registerJmx();
        hasRegisteredJmx = true;
    }

    public static ReplicationConnectionGroup getConnectionGroup(String groupName) {
        return GROUP_MAP.get(groupName);
    }

    private static Collection<ReplicationConnectionGroup> getGroupsMatching(String group) {
        if (group == null || group.equals("")) {
            HashSet<ReplicationConnectionGroup> s = new HashSet<ReplicationConnectionGroup>();
            s.addAll(GROUP_MAP.values());
            return s;
        }
        HashSet<ReplicationConnectionGroup> s = new HashSet<ReplicationConnectionGroup>();
        ReplicationConnectionGroup o = GROUP_MAP.get(group);
        if (o != null) {
            s.add(o);
        }
        return s;
    }

    public static void addSlaveHost(String group, String host) throws SQLException {
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s) {
            cg.addSlaveHost(host);
        }
    }

    public static void removeSlaveHost(String group, String host) throws SQLException {
        ReplicationConnectionGroupManager.removeSlaveHost(group, host, true);
    }

    public static void removeSlaveHost(String group, String host, boolean closeGently) throws SQLException {
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s) {
            cg.removeSlaveHost(host, closeGently);
        }
    }

    public static void promoteSlaveToMaster(String group, String newMasterHost) throws SQLException {
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s) {
            cg.promoteSlaveToMaster(newMasterHost);
        }
    }

    public static void removeMasterHost(String group, String host) throws SQLException {
        ReplicationConnectionGroupManager.removeMasterHost(group, host, true);
    }

    public static void removeMasterHost(String group, String host, boolean closeGently) throws SQLException {
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(group);
        for (ReplicationConnectionGroup cg : s) {
            cg.removeMasterHost(host, closeGently);
        }
    }

    public static String getRegisteredReplicationConnectionGroups() {
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(null);
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (ReplicationConnectionGroup cg : s) {
            String group = cg.getGroupName();
            sb.append(sep);
            sb.append(group);
            sep = ",";
        }
        return sb.toString();
    }

    public static int getNumberOfMasterPromotion(String groupFilter) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s) {
            total = (int)((long)total + cg.getNumberOfSlavePromotions());
        }
        return total;
    }

    public static int getConnectionCountWithHostAsSlave(String groupFilter, String host) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s) {
            total += cg.getConnectionCountWithHostAsSlave(host);
        }
        return total;
    }

    public static int getConnectionCountWithHostAsMaster(String groupFilter, String host) {
        int total = 0;
        Collection<ReplicationConnectionGroup> s = ReplicationConnectionGroupManager.getGroupsMatching(groupFilter);
        for (ReplicationConnectionGroup cg : s) {
            total += cg.getConnectionCountWithHostAsMaster(host);
        }
        return total;
    }
}

