/*
 * Decompiled with CFR 0.152.
 */
package sec.web.render;

import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.util.SparseArray;
import armyc2.c2sd.graphics2d.Font;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.renderer.MilStdIconRenderer;
import armyc2.c2sd.renderer.PatternFillRenderer;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.MilStdSymbol;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.ShapeInfo;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import java.util.ArrayList;
import java.util.logging.Level;
import sec.geo.kml.KmlOptions;
import sec.geo.utilities.StringBuilder;
import sec.web.json.utilities.JSONArray;
import sec.web.json.utilities.JSONException;
import sec.web.json.utilities.JSONObject;
import sec.web.render.MultiPointHandler;
import sec.web.render.Shape3DHandler;
import sec.web.render.SymbolModifiers;
import sec.web.render.utilities.JavaRendererUtilities;

public final class SECWebRenderer {
    private static final long serialVersionUID = -2691218568602318366L;
    public static final String CYLINDER = "CYLINDER-------";
    public static final String ORBIT = "ORBIT----------";
    public static final String ROUTE = "ROUTE----------";
    public static final String POLYGON = "POLYGON--------";
    public static final String RADARC = "RADARC---------";
    public static final String POLYARC = "POLYARC--------";
    public static final String CAKE = "CAKE-----------";
    public static final String TRACK = "TRACK----------";
    public static final String ATTRIBUTES = "attributes";
    public static final String MIN_ALT = "minalt";
    public static final String MAX_ALT = "maxalt";
    public static final String RADIUS1 = "radius1";
    public static final String RADIUS2 = "radius2";
    public static final String LEFT_AZIMUTH = "leftAzimuth";
    public static final String RIGHT_AZIMUTH = "rightAzimuth";
    public static final double MIN_ALT_DEFAULT = 0.0;
    public static final double MAX_ALT_DEFAULT = 100.0;
    public static final double RADIUS1_DEFAULT = 50.0;
    public static final double RADIUS2_DEFAULT = 100.0;
    public static final double LEFT_AZIMUTH_DEFAULT = 0.0;
    public static final double RIGHT_AZIMUTH_DEFAULT = 90.0;
    public static final String ERR_ATTRIBUTES_NOT_FORMATTED = "{\"type\":\"error\",\"error\":\"The attribute paramaters are not formatted correctly";
    public static final String DEFAULT_ATTRIBUTES = "[{radius1:50.0,radius2:100.0,minalt:0.0,maxalt:100.0,rightAzimuth:90.0,leftAzimuth:0.0}]";
    private static boolean _initSuccess = false;

    public static synchronized void init(String cacheDir) {
        try {
            if (!_initSuccess) {
                MilStdIconRenderer.getInstance().init(cacheDir);
                RendererSettings.getInstance().setSinglePointSymbolOutlineWidth(1);
                RendererSettings.getInstance().setTextRenderMethod(1);
                RendererSettings.getInstance().setTextBackgroundMethod(3);
                RendererSettings.getInstance().setTextOutlineWidth(2);
                RendererSettings.getInstance().setLabelForegroundColor(Color.BLACK.toARGB());
                RendererSettings.getInstance().setLabelBackgroundColor(new Color(255, 255, 255, 200).toARGB());
                RendererSettings.getInstance().setModifierFont("arial", Font.PLAIN, 12);
                ErrorLogger.setLevel(Level.FINE);
                _initSuccess = true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SECWebRenderer", "init", exc, Level.WARNING);
        }
    }

    public static void setLoggingLevel(Level level) {
        try {
            ErrorLogger.setLevel(level, true);
            ErrorLogger.LogMessage("SECWebRenderer", "setLoggingLevel(Level)", "Logging level set to: " + ErrorLogger.getLevel().getName(), Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SECWebRenderer", "setLoggingLevel(Level)", exc, Level.INFO);
        }
    }

    public static void setLoggingLevel(int level) {
        try {
            if (level > 1000) {
                ErrorLogger.setLevel(Level.OFF, true);
            } else if (level > 900) {
                ErrorLogger.setLevel(Level.SEVERE, true);
            } else if (level > 800) {
                ErrorLogger.setLevel(Level.WARNING, true);
            } else if (level > 700) {
                ErrorLogger.setLevel(Level.INFO, true);
            } else if (level > 500) {
                ErrorLogger.setLevel(Level.CONFIG, true);
            } else if (level > 400) {
                ErrorLogger.setLevel(Level.FINE, true);
            } else if (level > 300) {
                ErrorLogger.setLevel(Level.FINER, true);
            } else if (level > Integer.MIN_VALUE) {
                ErrorLogger.setLevel(Level.FINEST, true);
            } else {
                ErrorLogger.setLevel(Level.ALL, true);
            }
            ErrorLogger.LogMessage("SECWebRenderer", "setLoggingLevel(int)", "Logging level set to: " + ErrorLogger.getLevel().getName(), Level.CONFIG);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SECWebRenderer", "setLoggingLevel(int)", exc, Level.INFO);
        }
    }

    public static void setDefaultSymbologyStandard(int symStd) {
        RendererSettings.getInstance().setSymbologyStandard(symStd);
    }

    public static void setTacticalGraphicPointSize(int size) {
    }

    public static void setUnitPointSize(int size) {
    }

    public static void setModifierTextColor(String hexColor) {
        Color textColor = SymbolUtilities.getColorFromHexString(hexColor);
        if (textColor == null) {
            textColor = Color.black;
        }
        RendererSettings.getInstance().setLabelForegroundColor(textColor.toARGB());
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, SparseArray<String> modifiers, SparseArray<String> attributes, int format, int symStd) {
        String output = "";
        try {
            JavaRendererUtilities.addAltModeToModifiersString(attributes, altitudeMode);
            if (!altitudeMode.equals("clampToGround") && format == 0 && JavaRendererUtilities.is3dSymbol(symbolCode, modifiers)) {
                if (altitudeMode.isEmpty()) {
                    altitudeMode = "absolute";
                }
                output = SECWebRenderer.RenderMilStd3dSymbol(name, id, symbolCode, description, altitudeMode, controlPoints, modifiers, attributes);
                String modifierKML = MultiPointHandler.getModififerKML(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes, format, symStd);
                if ((output = output.replaceFirst("</Folder>", modifierKML = modifierKML + "</Folder>")).equals("") || output.startsWith("{")) {
                    output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes, format, symStd);
                }
            } else {
                output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes, format, symStd);
                if (ErrorLogger.getLevel().intValue() <= Level.FINER.intValue()) {
                    System.out.println("");
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nID: " + id + "\n");
                    sb.append("Name: " + name + "\n");
                    sb.append("Description: " + description + "\n");
                    sb.append("SymbolID: " + symbolCode + "\n");
                    sb.append("SymStd: " + String.valueOf(symStd) + "\n");
                    sb.append("Scale: " + String.valueOf(scale) + "\n");
                    sb.append("BBox: " + bbox + "\n");
                    sb.append("Coords: " + controlPoints + "\n");
                    sb.append("Modifiers: " + modifiers + "\n");
                    ErrorLogger.LogMessage("SECWebRenderer", "RenderSymbol", sb.toString(), Level.FINER);
                }
                if (ErrorLogger.getLevel().intValue() <= Level.FINEST.intValue()) {
                    String briefOutput = output.replaceAll("</Placemark>", "</Placemark>\n");
                    briefOutput = output.replaceAll("(?s)<description[^>]*>.*?</description>", "<description></description>");
                    ErrorLogger.LogMessage("SECWebRenderer", "RenderSymbol", "Output:\n" + briefOutput, Level.FINEST);
                }
            }
        }
        catch (Exception ea) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol - " + ea.toString() + "'}";
            ErrorLogger.LogException("SECWebRenderer", "RenderSymbol", ea, Level.WARNING);
        }
        return output;
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, SparseArray<String> modifiers, SparseArray<String> attributes, int format, int symStd) {
        String output = "";
        try {
            output = MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, attributes, format, symStd);
        }
        catch (Exception exc) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol: " + symbolCode + " - " + exc.toString() + "'}";
        }
        return output;
    }

    public static String Render3dSymbol(String name, String id, String shapeType, String description, String lineColor, String fillColor, String altitudeMode, String controlPoints, String attributes) {
        String returnValue = "";
        try {
            JSONArray attributesArray;
            int attributesArrayLength;
            StringBuilder output = new StringBuilder();
            SymbolModifiers modifiers = new SymbolModifiers();
            JSONObject attributesJSON = new JSONObject(attributes);
            if (attributesJSON == null || attributes.equals("")) {
                attributesJSON = new JSONObject(DEFAULT_ATTRIBUTES);
            }
            if ((attributesArrayLength = (attributesArray = attributesJSON.getJSONArray(ATTRIBUTES)).length()) > 0) {
                for (int i = 0; i < attributesArrayLength; ++i) {
                    JSONObject currentAttributeSet = attributesArray.getJSONObject(i);
                    if (currentAttributeSet.has(RADIUS1)) {
                        modifiers.AM_DISTANCE.add(currentAttributeSet.getDouble(RADIUS1));
                    }
                    if (currentAttributeSet.has(RADIUS2)) {
                        modifiers.AM_DISTANCE.add(currentAttributeSet.getDouble(RADIUS2));
                    }
                    if (currentAttributeSet.has(MIN_ALT)) {
                        modifiers.X_ALTITUDE_DEPTH.add(currentAttributeSet.getDouble(MIN_ALT));
                    }
                    if (currentAttributeSet.has(MAX_ALT)) {
                        modifiers.X_ALTITUDE_DEPTH.add(currentAttributeSet.getDouble(MAX_ALT));
                    }
                    if (currentAttributeSet.has(LEFT_AZIMUTH)) {
                        modifiers.AN_AZIMUTH.add(currentAttributeSet.getDouble(LEFT_AZIMUTH));
                    }
                    if (!currentAttributeSet.has(RIGHT_AZIMUTH)) continue;
                    modifiers.AN_AZIMUTH.add(currentAttributeSet.getDouble(RIGHT_AZIMUTH));
                }
            }
            returnValue = Shape3DHandler.render3dSymbol(name, id, shapeType, description, lineColor, fillColor, altitudeMode, controlPoints, modifiers);
        }
        catch (JSONException je) {
            return ERR_ATTRIBUTES_NOT_FORMATTED;
        }
        catch (Exception ea) {
            ErrorLogger.LogException("SECWebRenderer", "Render3dSymbol()", ea);
            return "";
        }
        return returnValue;
    }

    private static String RenderMilStd3dSymbol(String name, String id, String symbolCode, String description, String altitudeMode, String controlPoints, SparseArray<String> saModifiers, SparseArray<String> saAttributes) {
        String symbolId = symbolCode.substring(4, 10);
        SymbolModifiers attributes = new SymbolModifiers();
        String output = "";
        KmlOptions.AltitudeMode convertedAltitudeMode = KmlOptions.AltitudeMode.RELATIVE_TO_GROUND;
        if (!altitudeMode.equals("")) {
            convertedAltitudeMode = KmlOptions.AltitudeMode.fromString(altitudeMode);
        }
        try {
            int i;
            Color c;
            String[] altitudeDepth = null;
            String[] distance = null;
            String[] azimuth = null;
            int altitudeDepthLength = 0;
            int distanceLength = 0;
            int azimuthLength = 0;
            String lineColor = "";
            String fillColor = "";
            if (saModifiers.indexOfKey(14) >= 0) {
                altitudeDepth = ((String)saModifiers.get(14)).split(",");
                altitudeDepthLength = altitudeDepth.length;
            }
            if (saModifiers.indexOfKey(17) >= 0) {
                azimuth = ((String)saModifiers.get(17)).split(",");
                azimuthLength = azimuth.length;
            }
            if (saModifiers.indexOfKey(16) >= 0) {
                distance = ((String)saModifiers.get(16)).split(",");
                distanceLength = distance.length;
            }
            if (saAttributes.indexOfKey(0) >= 0) {
                lineColor = (String)saAttributes.get(0);
            } else {
                c = SymbolUtilities.getFillColorOfAffiliation(symbolCode);
                lineColor = c.toHexString();
                if (lineColor == null) {
                    lineColor = "FF000000";
                }
            }
            if (saAttributes.indexOfKey(1) >= 0) {
                fillColor = (String)saAttributes.get(1);
            } else {
                c = SymbolUtilities.getFillColorOfAffiliation(symbolCode);
                fillColor = c.toHexString();
                if (fillColor == null) {
                    fillColor = "AA000000";
                }
            }
            lineColor = JavaRendererUtilities.ARGBtoABGR(lineColor);
            fillColor = JavaRendererUtilities.ARGBtoABGR(fillColor);
            for (i = 0; i < altitudeDepthLength; ++i) {
                if (symbolId.startsWith("AJP")) {
                    attributes.X_ALTITUDE_DEPTH.add(0.0);
                    ++i;
                }
                attributes.X_ALTITUDE_DEPTH.add(Double.parseDouble(altitudeDepth[i]));
            }
            for (i = 0; i < distanceLength; ++i) {
                if (symbolId.equals("ACAR--") || symbolId.equals("AKPR--") || symbolId.equals("ALC---") || symbolId.equals("ALM---") || symbolId.equals("ALS---") || symbolId.equals("ALU---") || symbolId.equals("ALL---")) {
                    double width = Double.parseDouble(distance[i]) / 2.0;
                    attributes.AM_DISTANCE.add(width);
                    attributes.AM_DISTANCE.add(width);
                    continue;
                }
                attributes.AM_DISTANCE.add(Double.parseDouble(distance[i]));
            }
            if (symbolId.equals("ACAI--") || symbolId.equals("AKPI--") || symbolId.equals("AAR---") || symbolId.equals("AAF---") || symbolId.equals("AAH---") || symbolId.equals("AAM---") || symbolId.equals("AAML--") || symbolId.equals("AAMH--")) {
                output = Shape3DHandler.buildPolygon(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
            } else if (symbolId.equals("ACAR--") || symbolId.equals("AKPR--") || symbolId.equals("ALC---") || symbolId.equals("ALM---") || symbolId.equals("ALS---") || symbolId.equals("ALU---") || symbolId.equals("ALL---")) {
                output = Shape3DHandler.buildTrack(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
            } else if (symbolId.equals("ACAC--") || symbolId.equals("AKPC--")) {
                output = Shape3DHandler.buildCylinder(controlPoints, id, name, description, lineColor, fillColor, convertedAltitudeMode, attributes);
            }
        }
        catch (Exception exc) {
            output = "";
        }
        return output;
    }

    public static MilStdSymbol RenderMultiPointAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, SparseArray<String> modifiers, SparseArray<String> attributes, int symStd) {
        MilStdSymbol mSymbol = null;
        try {
            mSymbol = MultiPointHandler.RenderSymbolAsMilStdSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes, symStd);
            String basicID = SymbolUtilities.getBasicSymbolID(symbolCode);
            if (basicID.charAt(0) == 'G' && (basicID.charAt(2) == 'G' && basicID.substring(4, 7).equals("PC-") || basicID.charAt(2) == 'M' && basicID.substring(4, 7).equals("OFD"))) {
                String A = "G*MPOMU---****X";
                if (modifiers.indexOfKey(0) >= 0) {
                    A = (String)modifiers.get(0);
                }
                int size = RendererSettings.getInstance().getDefaultPixelSize();
                ArrayList<ShapeInfo> shapes = mSymbol.getSymbolShapes();
                ShapeInfo shape = shapes.get(0);
                shape.setPatternFillImage(PatternFillRenderer.MakeSymbolPatternFill(A, size));
                if (shape.getPatternFillImage() != null) {
                    shape.setShader(new BitmapShader(shape.getPatternFillImage(), Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
                }
            } else if (basicID.charAt(0) == 'W') {
                ArrayList<ShapeInfo> shapes = mSymbol.getSymbolShapes();
                ShapeInfo shape = shapes.get(0);
                shape.setPatternFillImage(PatternFillRenderer.MakeMetocPatternFill(symbolCode));
                if (shape.getPatternFillImage() != null) {
                    shape.setShader(new BitmapShader(shape.getPatternFillImage(), Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
                }
            }
        }
        catch (Exception ea) {
            mSymbol = null;
            ErrorLogger.LogException("SECRenderer", "RenderMultiPointAsMilStdSymbol - " + symbolCode, ea, Level.WARNING);
        }
        return mSymbol;
    }

    public String getSinglePointAnchor(String symbolID) {
        String anchorPoint = "";
        Point2D.Double anchor = new Point2D.Double();
        anchorPoint = ((Point2D)anchor).getX() + "," + ((Point2D)anchor).getY();
        return anchorPoint;
    }

    public static String getSinglePointInfo(String symbolID) {
        String info = "";
        Point2D.Double anchor = new Point2D.Double();
        Rectangle2D.Double symbolBounds = new Rectangle2D.Double();
        return info;
    }

    public static String ShouldClipMultipointSymbol(String symbolID) {
        if (MultiPointHandler.ShouldClipSymbol(symbolID).booleanValue()) {
            return "true";
        }
        return "false";
    }

    public static byte[] getSinglePointByteArray(String symbolID) {
        return null;
    }

    public static String GenerateSymbolLineFillUrl(SparseArray<String> modifiers, ArrayList<Point2D> pixels, Rectangle clip) {
        boolean shapeType = false;
        String url = "";
        String symbolFillIDs = null;
        Object symbolLineIDs = null;
        String strClip = null;
        int symbolSize = 25;
        boolean imageoffset = false;
        Object lines = null;
        Object points = null;
        Point2D point = null;
        Object shape = null;
        double height = 0.0;
        double width = 0.0;
        int offsetX = 0;
        int offsetY = 0;
        int x = 0;
        int y = 0;
        Rectangle bounds = null;
        try {
            GeneralPath path = new GeneralPath();
            Point2D temp = null;
            for (int i = 0; i < pixels.size(); ++i) {
                temp = pixels.get(i);
                if (i > 0) {
                    path.lineTo(temp.getX(), temp.getY());
                    continue;
                }
                if (i != 0) continue;
                path.moveTo(temp.getX(), temp.getY());
            }
            bounds = path.getBounds();
            height = bounds.getHeight();
            width = bounds.getWidth();
            if (bounds.getX() < 0.0) {
                offsetX = (int)(bounds.getX() * -1.0);
            } else if (bounds.getX() + (double)bounds.getWidth() > width) {
                offsetX = (int)(bounds.getX() + (double)bounds.getWidth() - width) * -1;
            }
            if (bounds.getY() < 0) {
                offsetY = bounds.getY() * -1;
            } else if ((double)(bounds.getY() + bounds.getHeight()) > height) {
                offsetY = (int)((double)(bounds.getY() + bounds.getHeight()) - height) * -1;
            }
            if (clip != null) {
                StringBuilder sbClip = new StringBuilder();
                sbClip.append("&clip=");
                sbClip.append(Integer.toString((int)clip.getX()));
                sbClip.append(",");
                sbClip.append(Integer.toString(clip.getY()));
                sbClip.append(",");
                sbClip.append(Integer.toString(clip.getWidth()));
                sbClip.append(",");
                sbClip.append(Integer.toString(clip.getHeight()));
                strClip = sbClip.toString();
            }
            StringBuilder sbCoords = new StringBuilder();
            StringBuilder sbUrl = new StringBuilder();
            sbCoords.append("coords=");
            if (modifiers.indexOfKey(90) >= 0) {
                symbolFillIDs = (String)modifiers.get(90);
            }
            for (int i = 0; i < pixels.size(); ++i) {
                if (i > 0) {
                    sbCoords.append(",");
                }
                point = pixels.get(i);
                x = (int)(point.getX() + (double)offsetX);
                y = (int)(point.getY() + (double)offsetY);
                sbCoords.append(Integer.toString(x));
                sbCoords.append(",");
                sbCoords.append(Integer.toString(y));
            }
            sbUrl.append("http://127.0.0.1:");
            sbUrl.append("6789");
            sbUrl.append("/AREASYMBOLFILL?");
            sbUrl.append("renderer=AreaSymbolFillRenderer&");
            sbUrl.append(sbCoords.toString());
            if (symbolFillIDs != null) {
                sbUrl.append("&symbolFillIds=");
                sbUrl.append(symbolFillIDs);
            }
            if (symbolLineIDs != null) {
                sbUrl.append("&symbolLineIds=");
                sbUrl.append(symbolLineIDs);
            }
            if (symbolSize > 0) {
                sbUrl.append("&symbolFillIconSize=");
                sbUrl.append(Integer.toString(symbolSize));
            }
            if (strClip != null) {
                sbUrl.append(strClip);
            }
            sbUrl.append("&height=");
            sbUrl.append(Integer.toString((int)height));
            sbUrl.append("&width=");
            sbUrl.append(Integer.toString((int)width));
            url = sbUrl.toString();
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return url;
    }
}

