/*
 * Decompiled with CFR 0.152.
 */
package sec.web.render;

import android.util.Log;
import android.util.SparseArray;
import armyc2.c2sd.JavaLineArray.CELineArray;
import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaRendererServer.RenderMultipoints.clsClipPolygon2;
import armyc2.c2sd.JavaRendererServer.RenderMultipoints.clsRenderer;
import armyc2.c2sd.JavaTacticalRenderer.TGLight;
import armyc2.c2sd.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c2sd.graphics2d.BasicStroke;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle;
import armyc2.c2sd.graphics2d.Rectangle2D;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.IPointConversion;
import armyc2.c2sd.renderer.utilities.MilStdSymbol;
import armyc2.c2sd.renderer.utilities.PointConversion;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.ShapeInfo;
import armyc2.c2sd.renderer.utilities.SymbolDef;
import armyc2.c2sd.renderer.utilities.SymbolDefTable;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import sec.geo.GeoPoint;
import sec.geo.kml.KmlOptions;
import sec.geo.kml.XsltCoordinateWrapper;
import sec.geo.utilities.StringBuilder;
import sec.web.render.PointConverter;
import sec.web.render.SECWebRenderer;
import sec.web.render.utilities.JavaRendererUtilities;
import sec.web.render.utilities.LineInfo;
import sec.web.render.utilities.SymbolInfo;
import sec.web.render.utilities.TextInfo;

public class MultiPointHandler {
    private static final int SYMBOL_FILL_IDS = 90;
    private static final int SYMBOL_LINE_IDS = 91;
    private static final int SYMBOL_FILL_ICON_SIZE = 92;
    private static final int _maxPixelWidth = 1000;
    private static final int _minPixelWidth = 100;
    public static final int Symbology_2525Bch2_USAS_13_14 = 0;
    public static final int Symbology_2525C = 1;

    public static String getModififerKML(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, SparseArray symbolModifiers, SparseArray symbolAttributes, int format, int symStd) {
        String output = "";
        LinkedList<String> placemarks = new LinkedList<String>();
        try {
            double maxAlt = 0.0;
            double minAlt = 0.0;
            output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, (SparseArray<String>)symbolModifiers, (SparseArray<String>)symbolAttributes, format, symStd);
            int pmiStart = output.indexOf("<Placemark");
            int pmiEnd = 0;
            boolean curr = false;
            int count = 0;
            String tempPlacemark = "";
            while (pmiStart > 0) {
                if (count > 0) {
                    pmiEnd = output.indexOf("</Placemark>", pmiStart) + 12;
                    tempPlacemark = output.substring(pmiStart, pmiEnd);
                    if (tempPlacemark.contains("<Point>")) {
                        placemarks.add(output.substring(pmiStart, pmiEnd));
                    }
                    pmiStart = output.indexOf("<Placemark", pmiEnd - 2);
                }
                ++count;
            }
            java.lang.StringBuilder sb = new java.lang.StringBuilder();
            for (String pm : placemarks) {
                sb.append(pm);
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return output;
        }
    }

    public static void NormalizeGECoordsToGEExtents(double leftLongitude, double rightLongitude, ArrayList<Point2D> pts2d) {
        try {
            int j = 0;
            double x = 0.0;
            double y = 0.0;
            Point2D pt2d = null;
            int n = pts2d.size();
            for (j = 0; j < n; ++j) {
                pt2d = pts2d.get(j);
                y = pt2d.getY();
                for (x = pt2d.getX(); x < leftLongitude; x += 360.0) {
                }
                while (x > rightLongitude) {
                    x -= 360.0;
                }
                pt2d = new Point2D.Double(x, y);
                pts2d.set(j, pt2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Point2D NormalizeCoordToGECoord(Point2D pt2d) {
        Point2D.Double ptGeo = null;
        try {
            double x;
            double y = pt2d.getY();
            for (x = pt2d.getX(); x < -180.0; x += 360.0) {
            }
            while (x > 180.0) {
                x -= 360.0;
            }
            ptGeo = new Point2D.Double(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ptGeo;
    }

    private static String getBoundingRectangle(String controlPoints, String bbox) {
        String bbox2 = "";
        try {
            Double left = 0.0;
            Double right = 0.0;
            Double top = 0.0;
            Double bottom = 0.0;
            String[] coordinates = controlPoints.split(" ");
            int len = coordinates.length;
            int i = 0;
            left = Double.MAX_VALUE;
            right = -1.7976931348623157E308;
            top = -1.7976931348623157E308;
            bottom = Double.MAX_VALUE;
            for (i = 0; i < len; ++i) {
                String[] coordPair = coordinates[i].split(",");
                Double latitude = Double.valueOf(coordPair[1].trim());
                Double longitude = Double.valueOf(coordPair[0].trim());
                if (longitude < left) {
                    left = longitude;
                }
                if (longitude > right) {
                    right = longitude;
                }
                if (latitude > top) {
                    top = latitude;
                }
                if (!(latitude < bottom)) continue;
                bottom = latitude;
            }
            bbox2 = left.toString() + "," + bottom.toString() + "," + right.toString() + "," + top.toString();
        }
        catch (Exception ex) {
            System.out.println("Failed to create bounding rectangle in MultiPointHandler.getBoundingRect");
        }
        return bbox2;
    }

    private static Point2D getControlPoint(ArrayList<Point2D> geoCoords) {
        Point2D.Double pt2d = null;
        try {
            double left = Double.MAX_VALUE;
            double right = -1.7976931348623157E308;
            double top = -1.7976931348623157E308;
            double bottom = Double.MAX_VALUE;
            Point2D ptTemp = null;
            int n = geoCoords.size();
            for (int j = 0; j < n; ++j) {
                ptTemp = geoCoords.get(j);
                if (ptTemp.getX() < left) {
                    left = ptTemp.getX();
                }
                if (ptTemp.getX() > right) {
                    right = ptTemp.getX();
                }
                if (ptTemp.getY() > top) {
                    top = ptTemp.getY();
                }
                if (!(ptTemp.getY() < bottom)) continue;
                bottom = ptTemp.getY();
            }
            pt2d = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return pt2d;
    }

    private static Point2D getGeoUL(ArrayList<Point2D> geoCoords) {
        Point2D.Double ptGeo = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get(0).getX();
            double top = geoCoords.get(0).getY();
            double right = geoCoords.get(0).getX();
            double bottom = geoCoords.get(0).getY();
            int n = geoCoords.size();
            for (j = 1; j < n; ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                n = geoCoords.size();
                for (j = 0; j < n; ++j) {
                    pt = geoCoords.get(j);
                    if (!(pt.getX() > 0.0) || !(pt.getX() < left)) continue;
                    left = pt.getX();
                }
            }
            ptGeo = new Point2D.Double(left, top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getControlPoint");
        }
        return ptGeo;
    }

    private static String getBboxFromCoords(ArrayList<Point2D> geoCoords) {
        String bbox = null;
        try {
            int j = 0;
            Point2D pt = null;
            double left = geoCoords.get(0).getX();
            double top = geoCoords.get(0).getY();
            double right = geoCoords.get(0).getX();
            double bottom = geoCoords.get(0).getY();
            for (j = 1; j < geoCoords.size(); ++j) {
                pt = geoCoords.get(j);
                if (pt.getX() < left) {
                    left = pt.getX();
                }
                if (pt.getX() > right) {
                    right = pt.getX();
                }
                if (pt.getY() > top) {
                    top = pt.getY();
                }
                if (!(pt.getY() < bottom)) continue;
                bottom = pt.getY();
            }
            if (right - left > 180.0) {
                left = 180.0;
                right = -180.0;
                for (j = 0; j < geoCoords.size(); ++j) {
                    pt = geoCoords.get(j);
                    if (pt.getX() > 0.0 && pt.getX() < left) {
                        left = pt.getX();
                    }
                    if (!(pt.getX() < 0.0) || !(pt.getX() > right)) continue;
                    right = pt.getX();
                }
            }
            bbox = Double.toString(left) + "," + Double.toString(bottom) + "," + Double.toString(right) + "," + Double.toString(top);
        }
        catch (Exception ex) {
            System.out.println("Failed to create control point in MultiPointHandler.getBboxFromCoords");
        }
        return bbox;
    }

    private static boolean crossesIDL(ArrayList<Point2D> geoCoords) {
        boolean result = false;
        Point2D pt2d = MultiPointHandler.getControlPoint(geoCoords);
        double left = pt2d.getX();
        Point2D ptTemp = null;
        int n = geoCoords.size();
        for (int j = 0; j < n; ++j) {
            ptTemp = geoCoords.get(j);
            if (!(Math.abs(ptTemp.getX() - left) > 180.0)) continue;
            return true;
        }
        return result;
    }

    public static Boolean ShouldClipSymbol(String symbolID) {
        String affiliation = SymbolUtilities.getStatus(symbolID);
        if (symbolID.substring(0, 1).equals("G") && affiliation.equals("A")) {
            return true;
        }
        if (SymbolUtilities.isWeather(symbolID)) {
            return true;
        }
        String id = SymbolUtilities.getBasicSymbolID(symbolID);
        if (id.equals("G*T*F-----****X") || id.equals("G*F*LCC---****X") || id.equals("G*G*GLB---****X") || id.equals("G*G*GLF---****X") || id.equals("G*G*GLC---****X") || id.equals("G*G*GAF---****X") || id.equals("G*G*AAW---****X") || id.equals("G*G*DABP--****X") || id.equals("G*G*OLP---****X") || id.equals("G*G*PY----****X") || id.equals("G*G*PM----****X") || id.equals("G*G*ALL---****X") || id.equals("G*G*ALU---****X") || id.equals("G*G*ALM---****X") || id.equals("G*G*ALC---****X") || id.equals("G*G*ALS---****X") || id.equals("G*G*SLB---****X") || id.equals("G*G*SLH---****X") || id.equals("G*G*GAY---****X") || id.equals("G*M*OFA---****X") || id.equals("G*M*OGB---****X") || id.equals("G*M*OGL---****X") || id.equals("G*M*OGZ---****X") || id.equals("G*M*OGF---****X") || id.equals("G*M*OGR---****X") || id.equals("G*M*OADU--****X") || id.equals("G*M*OADC--****X") || id.equals("G*M*OAR---****X") || id.equals("G*M*OAW---****X") || id.equals("G*M*OEF---****X") || id.equals("G*M*OMC---****X") || id.equals("G*M*OWU---****X") || id.equals("G*M*OWS---****X") || id.equals("G*M*OWD---****X") || id.equals("G*M*OWA---****X") || id.equals("G*M*OWL---****X") || id.equals("G*M*OWH---****X") || id.equals("G*M*OWCS--****X") || id.equals("G*M*OWCD--****X") || id.equals("G*M*OWCT--****X") || id.equals("G*M*OHO---****X") || id.equals("G*M*BDD---****X") || id.equals("G*M*BCD---****X") || id.equals("G*M*BCE---****X") || id.equals("G*M*SL----****X") || id.equals("G*M*SP----****X") || id.equals("G*M*NR----****X") || id.equals("G*M*NB----****X") || id.equals("G*M*NC----****X") || id.equals("G*F*ACNI--****X") || id.equals("G*F*ACNR--****X") || id.equals("G*F*ACNC--****X") || id.equals("G*F*AKBC--****X") || id.equals("G*F*AKBI--****X") || id.equals("G*F*AKBR--****X") || id.equals("G*F*AKPC--****X") || id.equals("G*F*AKPI--****X") || id.equals("G*F*AKPR--****X") || id.equals("G*F*LT----****X") || id.equals("G*F*LTS---****X") || id.equals("G*G*SAE---****X") || id.equals("G*S*LRA---****X") || id.equals("G*S*LRM---****X") || id.equals("G*S*LRO---****X") || id.equals("G*S*LRT---****X") || id.equals("G*S*LRW---****X") || id.equals("G*T*Q-----****X") || id.equals("G*T*E-----****X") || id.equals("G*T*F-----****X") || id.equals("G*T*K-----****X") || id.equals("G*T*KF----****X") || id.equals("G*G*PA----****X") || id.equals("G*M*ORP---****X") || id.equals("G*M*ORS---****X") || id.equals("G*T*A-----****X")) {
            return true;
        }
        return false;
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, int format) {
        return MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, symbolModifiers, symbolAttributes, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    private static double getReasonableScale(String bbox, double origScale) {
        double scale = origScale;
        try {
            String[] bounds = bbox.split(",");
            double left = Double.valueOf(bounds[0]);
            double right = Double.valueOf(bounds[2]);
            double top = Double.valueOf(bounds[3]);
            double bottom = Double.valueOf(bounds[1]);
            if (left == -180.0 && right == 180.0) {
                return 7.573E7;
            }
            if (left == 180.0 && right == -180.0) {
                return 7.573E7;
            }
            POINT2 ul = new POINT2(left, top);
            POINT2 ur = new POINT2(right, top);
            POINT2 lr = new POINT2(right, bottom);
            double widthInMeters = mdlGeodesic.geodesic_distance(ul, lr, null, null);
            double maxWidthInPixels = 1000.0;
            double minScale = maxWidthInPixels / widthInMeters * 0.010416666666666666 * 0.025400050800101603;
            if (origScale < (minScale = 1.0 / minScale)) {
                return minScale;
            }
            double minWidthInPixels = 100.0;
            double maxScale = minWidthInPixels / widthInMeters * 0.010416666666666666 * 0.025400050800101603;
            if (origScale > (maxScale = 1.0 / maxScale)) {
                return maxScale;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return scale;
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, int format, int symStd) {
        boolean normalize = true;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Rectangle rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = new ArrayList();
        ArrayList<ShapeInfo> modifiers = new ArrayList();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        Object coordsUL = null;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        ArrayList<POINT2> tgPoints = null;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                String bbox2 = MultiPointHandler.getBboxFromCoords(bboxCoords);
                scale = MultiPointHandler.getReasonableScale(bbox2, scale);
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels(pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels(pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(false);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            String symbolIsValid = MultiPointHandler.canRenderMultiPoint(mSymbol);
            if (!symbolIsValid.equals("true")) {
                String ErrorOutput = "";
                ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ";
                ErrorOutput = ErrorOutput + symbolIsValid + " - ";
                ErrorOutput = ErrorOutput + "\"}";
                return ErrorOutput;
            }
            if (symbolModifiers.indexOfKey(90) >= 0 || symbolModifiers.indexOfKey(91) >= 0) {
                tgl = clsRenderer.createTGLightFromMilStdSymbol(mSymbol, ipc);
                if (rect != null) {
                    Rectangle2D.Double rect2d = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
                    clsClipPolygon2.ClipPolygon(tgl, rect2d);
                }
                tgPoints = tgl.get_Pixels();
            }
            boolean isBasicShape = false;
            isBasicShape = bboxCoords == null ? MultiPointHandler.getBasicShapes(mSymbol, rect, ipc, symStd) : MultiPointHandler.getBasicShapes(mSymbol, bboxCoords, ipc, symStd);
            if (!isBasicShape) {
                if (bboxCoords == null) {
                    clsRenderer.renderWithPolylines(mSymbol, ipc, rect);
                } else {
                    clsRenderer.renderWithPolylines(mSymbol, ipc, bboxCoords);
                }
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, true, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String fillKML;
                Color textColor = null;
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, textColor);
                jsonOutput.append(jsonContent);
                if (!(symbolModifiers.indexOfKey(90) < 0 && symbolModifiers.indexOfKey(91) < 0 || (fillKML = MultiPointHandler.AddImageFillToKML(tgPoints, jsonContent, symbolModifiers, ipc, normalize)) == null || fillKML.isEmpty())) {
                    jsonOutput.append(fillKML);
                }
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}");
            }
        }
        catch (Exception exc) {
            String st = JavaRendererUtilities.getStackTrace(exc);
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(st);
            jsonOutput.append("\"}");
            ErrorLogger.LogException("MultiPointHandler", "RenderSymbol", exc);
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbol()", "exit RenderSymbol", Level.FINER);
        return jsonOutput.toString();
    }

    private static boolean getBasicShapes(MilStdSymbol milStd, Object clipArea, IPointConversion ipc, int symStd) {
        int linetype = CELineArray.CGetLinetypeFromString(milStd.getSymbolID(), symStd);
        ArrayList<Double> AM = null;
        ArrayList<Double> AN = null;
        double buffer = 0.0;
        double r = 0.0;
        boolean result = false;
        switch (linetype) {
            case 13000002: {
                AM = milStd.getModifiers_AM_AN_X(16);
                AN = milStd.getModifiers_AM_AN_X(17);
                if (AM.size() == 1) {
                    r = AM.get(0);
                    AM.add(r);
                    buffer = 0.0;
                    AM.add(buffer);
                } else if (AM.size() == 2) {
                    r = AM.get(0);
                    buffer = AM.get(1);
                    AM.set(1, r);
                    AM.add(buffer);
                } else if (AM.size() == 3) {
                    r = AM.get(0);
                    AM.set(1, r);
                }
                result = true;
                break;
            }
            case 13000000: 
            case 13000001: {
                AM = milStd.getModifiers_AM_AN_X(16);
                AN = milStd.getModifiers_AM_AN_X(17);
                if (AM.size() == 1) {
                    r = AM.get(0);
                    AM.add(r);
                    buffer = 0.0;
                    AM.add(buffer);
                }
                if (AM.size() == 2) {
                    AM.add(0.0);
                }
                result = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (AN == null) {
            AN = new ArrayList();
        }
        if (AN.isEmpty()) {
            AN.add(new Double(0.0));
        }
        ArrayList<Point2D> coords = milStd.getCoordinates();
        double pivotX = ((Point2D.Double)coords.get((int)0)).x;
        double pivotY = ((Point2D.Double)coords.get((int)0)).y;
        double semiMajor = AM.get(0);
        double semiMinor = AM.get(1);
        double rotation = AN.get(0);
        buffer = AM.get(2);
        String strAltitudeMode = milStd.getAltitudeMode();
        if (strAltitudeMode.isEmpty()) {
            strAltitudeMode = "clampToGround";
        }
        KmlOptions.AltitudeMode altitudeMode = KmlOptions.AltitudeMode.fromString(strAltitudeMode);
        ArrayList<GeoPoint> geoPts = XsltCoordinateWrapper.getEllipsePoints(pivotX, pivotY, altitudeMode, semiMajor + buffer, semiMinor + buffer, 0.0, 0.0, rotation);
        ArrayList<Point2D> coordinates = new ArrayList<Point2D>();
        double x = 0.0;
        double y = 0.0;
        for (int j = 0; j < geoPts.size(); ++j) {
            x = geoPts.get((int)j).x;
            y = geoPts.get((int)j).y;
            coordinates.add(new Point2D.Double(x, y));
        }
        milStd.setCoordinates(coordinates);
        clsRenderer.render_Shape(milStd, ipc, clipArea, 1, null, milStd.getFillColor(), 0);
        ArrayList<GeoPoint> geoPts2 = XsltCoordinateWrapper.getEllipsePoints(pivotX, pivotY, altitudeMode, semiMajor, semiMinor, 0.0, 0.0, rotation);
        ArrayList<Point2D> coordinates2 = new ArrayList<Point2D>();
        for (int j = 0; j < geoPts2.size(); ++j) {
            x = geoPts2.get((int)j).x;
            y = geoPts2.get((int)j).y;
            coordinates2.add(new Point2D.Double(x, y));
        }
        milStd.setCoordinates(coordinates2);
        clsRenderer.render_Shape(milStd, ipc, clipArea, 0, milStd.getLineColor(), null, milStd.getPatternFillType());
        milStd.setModifierShapes(new ArrayList<ShapeInfo>());
        return result;
    }

    public static MilStdSymbol RenderSymbolAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, Double scale, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, int symStd) {
        MilStdSymbol mSymbol = null;
        boolean normalize = true;
        Double controlLat = 0.0;
        Double controlLong = 0.0;
        Object rect = null;
        Object tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = null;
        ArrayList<ShapeInfo> modifiers = null;
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        Point2D ptGeoUL = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        int j = 0;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                Point2D ptGeo = null;
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipc.GeoToPixels(ptGeo);
                    x = ptPixels.getX();
                    y = ptPixels.getY();
                    if (x < 20.0) {
                        x = 20.0;
                    }
                    if (y < 20.0) {
                        y = 20.0;
                    }
                    ptPixels.setLocation(x, y);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = Double.valueOf(bounds[0]);
                right = Double.valueOf(bounds[2]);
                top = Double.valueOf(bounds[3]);
                bottom = Double.valueOf(bounds[1]);
                scale = MultiPointHandler.getReasonableScale(bbox, scale);
                ipc = new PointConverter(left, top, scale);
            }
            Point2D.Double pt2d = null;
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels(pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels(pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = width == 0 || height == 0 ? null : new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = Double.valueOf(coordPair[1].trim());
            Double longitude = Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        ArrayList<Point2D.Double> geoCoords2 = new ArrayList<Point2D.Double>();
        geoCoords2.add(new Point2D.Double(left, top));
        geoCoords2.add(new Point2D.Double(right, bottom));
        if (!MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() && !MultiPointHandler.crossesIDL(geoCoords)) {
            rect = null;
            bboxCoords = null;
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            String fillColor = null;
            mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(true);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null || symbolAttributes != null) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            if (mSymbol.getFillColor() != null) {
                Color fc = mSymbol.getFillColor();
                fillColor = Integer.toHexString(fc.toARGB());
            }
            boolean isBasicShape = false;
            isBasicShape = bboxCoords == null ? MultiPointHandler.getBasicShapes(mSymbol, rect, ipc, symStd) : MultiPointHandler.getBasicShapes(mSymbol, bboxCoords, ipc, symStd);
            if (!isBasicShape) {
                if (bboxCoords == null) {
                    clsRenderer.renderWithPolylines(mSymbol, ipc, rect);
                } else {
                    clsRenderer.renderWithPolylines(mSymbol, ipc, bboxCoords);
                }
            }
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            ArrayList<ArrayList<Point2D>> polylines = null;
            ArrayList<ArrayList<Point2D>> newPolylines = null;
            Object newLine = null;
            for (ShapeInfo shape : shapes) {
                polylines = shape.getPolylines();
                newPolylines = MultiPointHandler.ConvertPolylinePixelsToCoords(polylines, ipc, normalize);
                shape.setPolylines(newPolylines);
            }
            for (ShapeInfo label : modifiers) {
                Point2D pixelCoord = label.getModifierStringPosition();
                if (pixelCoord == null) {
                    pixelCoord = label.getGlyphPosition();
                }
                Point2D geoCoord = ipc.PixelsToGeo(pixelCoord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                label.setModifierStringPosition(new Point2D.Double(longitude, latitude));
            }
            mSymbol.setModifierShapes(modifiers);
            mSymbol.setSymbolShapes(shapes);
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            System.out.println("Symbol Code: " + symbolCode);
            exc.printStackTrace();
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
        }
        return mSymbol;
    }

    private static ArrayList<ArrayList<Point2D>> ConvertPolylinePixelsToCoords(ArrayList<ArrayList<Point2D>> polylines, IPointConversion ipc, Boolean normalize) {
        ArrayList<ArrayList<Point2D>> newPolylines = new ArrayList<ArrayList<Point2D>>();
        double latitude = 0.0;
        double longitude = 0.0;
        ArrayList<Point2D.Double> newLine = null;
        try {
            for (ArrayList<Point2D> line : polylines) {
                newLine = new ArrayList<Point2D.Double>();
                for (Point2D pt : line) {
                    Point2D geoCoord = ipc.PixelsToGeo(pt);
                    if (normalize.booleanValue()) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    latitude = geoCoord.getY();
                    longitude = geoCoord.getX();
                    newLine.add(new Point2D.Double(longitude, latitude));
                }
                newPolylines.add(newLine);
            }
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        return newPolylines;
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, int format) {
        return MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, symbolModifiers, symbolAttributes, format, RendererSettings.getInstance().getSymbologyStandard());
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, int format, int symStd) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Object rect = null;
        ArrayList<POINT2> tgPoints = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<ShapeInfo> shapes = new ArrayList();
        ArrayList<ShapeInfo> modifiers = new ArrayList();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        PointConversion ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top, left, bottom, right);
        int len = coordinates.length;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            String symbolIsValid;
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            mSymbol.setUseDashArray(false);
            mSymbol.setSymbologyStandard(symStd);
            if (symbolModifiers != null && !symbolModifiers.equals((Object)"")) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            Point2D temp = null;
            boolean normalize = false;
            if (MultiPointHandler.ShouldClipSymbol(symbolCode).booleanValue() || MultiPointHandler.crossesIDL(geoCoords)) {
                Point2D.Double lt = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels(lt);
                int leftX = (int)temp.getX();
                int topY = (int)temp.getY();
                Point2D.Double rb = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels(rb);
                int bottomY = (int)temp.getY();
                int rightX = (int)temp.getX();
                int width = Math.abs(rightX - leftX);
                int height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
            if (!(symbolIsValid = MultiPointHandler.canRenderMultiPoint(mSymbol)).equals("true")) {
                String ErrorOutput = "";
                ErrorOutput = ErrorOutput + "{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ";
                ErrorOutput = ErrorOutput + symbolIsValid + " - ";
                ErrorOutput = ErrorOutput + "\"}";
                ErrorLogger.LogMessage("MultiPointHandler", "RenderSymbol", symbolIsValid, Level.WARNING);
                return ErrorOutput;
            }
            if (symbolModifiers.indexOfKey(90) >= 0 || symbolModifiers.indexOfKey(91) >= 0) {
                tgl = clsRenderer.createTGLightFromMilStdSymbol(mSymbol, ipc);
                if (rect != null) {
                    Rectangle2D.Double rect2d = new Rectangle2D.Double(((Rectangle)rect).x, ((Rectangle)rect).y, ((Rectangle)rect).width, ((Rectangle)rect).height);
                    clsClipPolygon2.ClipPolygon(tgl, rect2d);
                }
                tgPoints = tgl.get_Pixels();
            }
            clsRenderer.renderWithPolylines(mSymbol, ipc, rect);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String fillKML;
                String fillColor = null;
                if (mSymbol.getFillColor() != null) {
                    fillColor = Integer.toHexString(mSymbol.getFillColor().toARGB());
                }
                Color textColor = null;
                textColor = mSymbol.getTextColor();
                if (textColor == null) {
                    textColor = mSymbol.getLineColor();
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, textColor);
                jsonOutput.append(jsonContent);
                if (!(symbolModifiers.indexOfKey(90) < 0 && symbolModifiers.indexOfKey(91) < 0 || (fillKML = MultiPointHandler.AddImageFillToKML(tgPoints, jsonContent, symbolModifiers, ipc, normalize)) == null || fillKML.isEmpty())) {
                    jsonOutput.append(fillKML);
                }
            } else if (format == 2) {
                jsonOutput.append("{\"type\":\"FeatureCollection\",\"features\":");
                jsonContent = MultiPointHandler.GeoJSONize(shapes, modifiers, ipc, normalize, mSymbol.getTextColor(), mSymbol.getTextBackgroundColor());
                jsonOutput.append(jsonContent);
                jsonOutput.append(",\"properties\":{\"id\":\"");
                jsonOutput.append(id);
                jsonOutput.append("\",\"name\":\"");
                jsonOutput.append(name);
                jsonOutput.append("\",\"description\":\"");
                jsonOutput.append(description);
                jsonOutput.append("\",\"symbolID\":\"");
                jsonOutput.append(symbolCode);
                jsonOutput.append("\",\"wasClipped\":\"");
                jsonOutput.append(String.valueOf(mSymbol.get_WasClipped()));
                jsonOutput.append("\"}}");
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append(ErrorLogger.getStackTrace(exc));
            jsonOutput.append("\"}");
        }
        boolean debug = false;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    public static String RenderSymbol2DX(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, SparseArray<String> symbolModifiers, SparseArray<String> symbolAttributes, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, int format) {
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Object rect = null;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        PointConversion ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        if (bbox == null || bbox.equals("")) {
            System.out.println("Bad bbox value: " + bbox);
            System.out.println("bbox is viewable area of the map.  Passed in the format of a string \"lowerLeftX,lowerLeftY,upperRightX,upperRightY.\" example: \"-50.4,23.6,-42.2,24.2\"");
            return "ERROR - Bad bbox value: " + bbox;
        }
        String[] bounds = bbox.split(",");
        left = (double)Double.valueOf(bounds[0]);
        right = (double)Double.valueOf(bounds[2]);
        top = (double)Double.valueOf(bounds[3]);
        bottom = (double)Double.valueOf(bounds[1]);
        ipc = new PointConversion(pixelWidth, pixelHeight, top, left, bottom, right);
        int len = coordinates.length;
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        try {
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, null);
            if (symbolModifiers != null && !symbolModifiers.equals((Object)"")) {
                MultiPointHandler.populateModifiers(symbolModifiers, symbolAttributes, mSymbol);
            } else {
                mSymbol.setFillColor(null);
            }
            clsRenderer.renderWithPolylines(mSymbol, ipc, rect);
            shapes = mSymbol.getSymbolShapes();
            modifiers = mSymbol.getModifierShapes();
            boolean normalize = false;
            if (format == 1) {
                jsonOutput.append("{\"type\":\"symbol\",");
                jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, false, normalize);
                jsonOutput.append(jsonContent);
                jsonOutput.append("}");
            } else if (format == 0) {
                String fillColor = null;
                if (mSymbol.getFillColor() != null) {
                    fillColor = Integer.toHexString(mSymbol.getFillColor().toARGB());
                }
                jsonContent = MultiPointHandler.KMLize(id, name, description, symbolCode, shapes, modifiers, ipc, normalize, mSymbol.getLineColor());
                jsonOutput.append(jsonContent);
            }
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol " + symbolCode + ": - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = true;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (tgl != null && tgl.get_Pixels() != null) {
                System.out.println("Pixel: " + tgl.get_Pixels().toString());
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return jsonOutput.toString();
    }

    private static SymbolInfo MilStdSymbolToSymbolInfo(MilStdSymbol symbol) {
        SymbolInfo si = null;
        ArrayList<TextInfo> tiList = new ArrayList<TextInfo>();
        ArrayList<LineInfo> liList = new ArrayList<LineInfo>();
        TextInfo tiTemp = null;
        LineInfo liTemp = null;
        ShapeInfo siTemp = null;
        ArrayList<ShapeInfo> lines = symbol.getSymbolShapes();
        ArrayList<ShapeInfo> modifiers = symbol.getModifierShapes();
        int lineCount = lines.size();
        int modifierCount = modifiers.size();
        for (int i = 0; i < lineCount; ++i) {
            siTemp = lines.get(i);
            if (siTemp.getPolylines() == null) continue;
            liTemp = new LineInfo();
            liTemp.setFillColor(siTemp.getFillColor());
            liTemp.setLineColor(siTemp.getLineColor());
            liTemp.setPolylines(siTemp.getPolylines());
            liTemp.setStroke(siTemp.getStroke());
            liList.add(liTemp);
        }
        for (int j = 0; j < modifierCount; ++j) {
            tiTemp = new TextInfo();
            siTemp = modifiers.get(j);
            if (siTemp.getModifierString() == null) continue;
            tiTemp.setModifierString(siTemp.getModifierString());
            tiTemp.setModifierStringPosition(siTemp.getModifierStringPosition());
            tiTemp.setModifierStringAngle(siTemp.getModifierStringAngle());
            tiList.add(tiTemp);
        }
        si = new SymbolInfo(tiList, liList);
        return si;
    }

    private static boolean populateModifiers(SparseArray<String> saModifiers, SparseArray<String> saAttributes, MilStdSymbol symbol) {
        SparseArray modifiers = new SparseArray();
        SparseArray attributes = saAttributes.clone();
        ArrayList<Double> altitudes = null;
        ArrayList<Double> azimuths = null;
        ArrayList<Double> distances = null;
        String fillColor = null;
        String lineColor = null;
        String textColor = null;
        String textBackgroundColor = null;
        int lineWidth = 0;
        int symstd = 0;
        String altMode = null;
        boolean useDashArray = symbol.getUseDashArray();
        boolean usePatternFill = symbol.getUseFillPattern();
        int patternFillType = 0;
        boolean hideOptionalLabels = false;
        Object symbolFillIDs = null;
        Object symbolFillIconSize = null;
        try {
            if (saModifiers != null) {
                if (saModifiers.indexOfKey(2) >= 0) {
                    modifiers.put(2, (Object)String.valueOf(saModifiers.get(2)));
                }
                if (saModifiers.indexOfKey(3) >= 0) {
                    modifiers.put(3, (Object)String.valueOf(saModifiers.get(3)));
                }
                if (saModifiers.indexOfKey(4) >= 0) {
                    modifiers.put(4, (Object)String.valueOf(saModifiers.get(4)));
                }
                if (saModifiers.indexOfKey(5) >= 0) {
                    modifiers.put(5, (Object)String.valueOf(saModifiers.get(5)));
                }
                if (saModifiers.indexOfKey(6) >= 0) {
                    modifiers.put(6, (Object)String.valueOf(saModifiers.get(6)));
                }
                if (saModifiers.indexOfKey(7) >= 0) {
                    modifiers.put(7, (Object)String.valueOf(saModifiers.get(7)));
                }
                if (saModifiers.indexOfKey(9) >= 0) {
                    modifiers.put(9, (Object)String.valueOf(saModifiers.get(9)));
                }
                if (saModifiers.indexOfKey(10) >= 0) {
                    modifiers.put(10, (Object)String.valueOf(saModifiers.get(10)));
                }
                if (saModifiers.indexOfKey(11) >= 0) {
                    modifiers.put(11, (Object)String.valueOf(saModifiers.get(11)));
                }
                if (saModifiers.indexOfKey(12) >= 0) {
                    modifiers.put(12, (Object)String.valueOf(saModifiers.get(12)));
                }
                if (saModifiers.indexOfKey(13) >= 0) {
                    modifiers.put(13, (Object)String.valueOf(saModifiers.get(13)));
                }
                if (saModifiers.indexOfKey(14) >= 0) {
                    String[] arrAltitudes;
                    altitudes = new ArrayList<Double>();
                    for (String x : arrAltitudes = String.valueOf(saModifiers.get(14)).split(",")) {
                        if (x.equals("")) continue;
                        altitudes.add(Double.parseDouble(x));
                    }
                }
                if (saModifiers.indexOfKey(16) >= 0) {
                    String[] arrDistances;
                    distances = new ArrayList<Double>();
                    for (String am : arrDistances = String.valueOf(saModifiers.get(16)).split(",")) {
                        if (am.equals("")) continue;
                        distances.add(Double.parseDouble(am));
                    }
                }
                if (saModifiers.indexOfKey(17) >= 0) {
                    String[] arrAzimuths;
                    azimuths = new ArrayList<Double>();
                    for (String an : arrAzimuths = String.valueOf(saModifiers.get(17)).split(",")) {
                        if (an.equals("")) continue;
                        azimuths.add(Double.parseDouble(an));
                    }
                }
            }
            if (saAttributes != null) {
                if (saAttributes.indexOfKey(1) >= 0) {
                    fillColor = (String)saAttributes.get(1);
                }
                if (saAttributes.indexOfKey(0) >= 0) {
                    lineColor = (String)saAttributes.get(0);
                }
                if (saAttributes.indexOfKey(12) >= 0) {
                    lineWidth = Integer.parseInt((String)saAttributes.get(12));
                }
                if (saAttributes.indexOfKey(13) >= 0) {
                    textColor = (String)saAttributes.get(13);
                }
                if (saAttributes.indexOfKey(14) >= 0) {
                    textBackgroundColor = (String)saAttributes.get(14);
                }
                if (saAttributes.indexOfKey(11) >= 0) {
                    symstd = Integer.parseInt((String)saAttributes.get(11));
                    symbol.setSymbologyStandard(symstd);
                }
                if (saAttributes.indexOfKey(16) >= 0) {
                    altMode = (String)saAttributes.get(16);
                }
                if (saAttributes.indexOfKey(15) >= 0) {
                    useDashArray = Boolean.parseBoolean((String)saAttributes.get(15));
                }
                if (saAttributes.indexOfKey(18) >= 0) {
                    usePatternFill = Boolean.parseBoolean((String)saAttributes.get(18));
                }
                if (saAttributes.indexOfKey(19) >= 0) {
                    patternFillType = Integer.parseInt((String)saAttributes.get(19));
                }
                if (saAttributes.indexOfKey(17) >= 0) {
                    hideOptionalLabels = Boolean.parseBoolean((String)saAttributes.get(17));
                }
            }
            symbol.setModifierMap((SparseArray<String>)modifiers);
            if (fillColor != null && !fillColor.equals("")) {
                symbol.setFillColor(SymbolUtilities.getColorFromHexString(fillColor));
            }
            if (lineColor != null && !lineColor.equals("")) {
                symbol.setLineColor(SymbolUtilities.getColorFromHexString(lineColor));
            } else if (symbol.getLineColor() == null) {
                symbol.setLineColor(Color.black);
            }
            if (lineWidth > 0) {
                symbol.setLineWidth(lineWidth);
            }
            if (textColor != null && !textColor.equals("")) {
                symbol.setTextColor(SymbolUtilities.getColorFromHexString(textColor));
            } else {
                symbol.setTextColor(symbol.getLineColor());
            }
            if (textBackgroundColor != null && !textBackgroundColor.equals("")) {
                symbol.setTextBackgroundColor(SymbolUtilities.getColorFromHexString(textBackgroundColor));
            }
            if (altMode != null) {
                symbol.setAltitudeMode(altMode);
            }
            symbol.setUseDashArray(useDashArray);
            symbol.setUseFillPattern(usePatternFill);
            if (SymbolUtilities.isBasicShape(symbol.getSymbolID())) {
                symbol.setPatternFillType(patternFillType);
            }
            symbol.setHideOptionalLabels(hideOptionalLabels);
            if (altitudes != null) {
                symbol.setModifiers_AM_AN_X(14, altitudes);
            }
            if (distances != null) {
                symbol.setModifiers_AM_AN_X(16, distances);
            }
            if (azimuths != null) {
                symbol.setModifiers_AM_AN_X(17, azimuths);
            }
            if (SymbolUtilities.getBasicSymbolID(symbol.getSymbolID()).equals("G*F*AXS---****X") && symbol.getModifiers_AM_AN_X(17) != null && symbol.getModifiers_AM_AN_X(16) != null) {
                int anCount = symbol.getModifiers_AM_AN_X(17).size();
                int amCount = symbol.getModifiers_AM_AN_X(16).size();
                ArrayList<Double> am = null;
                if (amCount < anCount / 2 + 1 && (am = symbol.getModifiers_AM_AN_X(16)).get(0) != 0.0) {
                    am.add(0, 0.0);
                }
            }
        }
        catch (Exception exc2) {
            Log.e((String)"MultiPointHandler.populateModifiers", (String)exc2.getMessage(), (Throwable)exc2);
        }
        return true;
    }

    public static IPointConversion RenderSymbol2(String symbolCode, String controlPoints, Double scale, String bbox, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers) {
        boolean normalize = false;
        StringBuilder jsonOutput = new StringBuilder();
        String jsonContent = "";
        Object rect = null;
        int j = 0;
        String[] coordinates = controlPoints.split(" ");
        TGLight tgl = new TGLight();
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int len = coordinates.length;
        PointConverter ipc = null;
        Double left = 0.0;
        Double right = 0.0;
        Double top = 0.0;
        Double bottom = 0.0;
        Point2D temp = null;
        int width = 0;
        int height = 0;
        int leftX = 0;
        int topY = 0;
        int bottomY = 0;
        int rightX = 0;
        Point2D.Double pt2d = null;
        ArrayList<Point2D> bboxCoords = null;
        if (bbox != null && !bbox.equals("")) {
            String[] bounds = null;
            if (bbox.contains(" ")) {
                String[] coords;
                bboxCoords = new ArrayList<Point2D>();
                double x = 0.0;
                double y = 0.0;
                for (String coord : coords = bbox.split(" ")) {
                    String[] arrCoord = coord.split(",");
                    x = Double.valueOf(arrCoord[0]);
                    y = Double.valueOf(arrCoord[1]);
                    bboxCoords.add(new Point2D.Double(x, y));
                }
                Point2D ptGeoUL = MultiPointHandler.getGeoUL(bboxCoords);
                left = ptGeoUL.getX();
                top = ptGeoUL.getY();
                ipc = new PointConverter(left, top, scale);
                Point2D ptPixels = null;
                ptPixels = new Point2D.Double(20.0, 20.0);
                Point2D ptGeo = ipc.PixelsToGeo(ptPixels);
                PointConverter ipcTemp = new PointConverter(ptGeo.getX(), ptGeo.getY(), scale);
                int n = bboxCoords.size();
                for (j = 0; j < n; ++j) {
                    ptGeo = bboxCoords.get(j);
                    ptPixels = ipcTemp.GeoToPixels(ptGeo);
                    bboxCoords.set(j, ptPixels);
                }
            } else {
                bounds = bbox.split(",");
                left = (double)Double.valueOf(bounds[0]);
                right = (double)Double.valueOf(bounds[2]);
                top = (double)Double.valueOf(bounds[3]);
                bottom = (double)Double.valueOf(bounds[1]);
                ipc = new PointConverter(left, top, scale);
            }
            if (bboxCoords == null) {
                pt2d = new Point2D.Double(left, top);
                temp = ipc.GeoToPixels(pt2d);
                leftX = (int)temp.getX();
                topY = (int)temp.getY();
                pt2d = new Point2D.Double(right, bottom);
                temp = ipc.GeoToPixels(pt2d);
                bottomY = (int)temp.getY();
                rightX = (int)temp.getX();
                width = Math.abs(rightX - leftX);
                height = Math.abs(bottomY - topY);
                rect = new Rectangle(leftX, topY, width, height);
            }
        } else {
            rect = null;
        }
        for (int i = 0; i < len; ++i) {
            String[] coordPair = coordinates[i].split(",");
            Double latitude = (double)Double.valueOf(coordPair[1].trim());
            Double longitude = (double)Double.valueOf(coordPair[0].trim());
            geoCoords.add(new Point2D.Double(longitude, latitude));
        }
        if (ipc == null) {
            Point2D ptCoordsUL = MultiPointHandler.getGeoUL(geoCoords);
            ipc = new PointConverter(ptCoordsUL.getX(), ptCoordsUL.getY(), scale);
        }
        tgl.set_SymbolId(symbolCode);
        tgl.set_Pixels(null);
        try {
            SparseArray modifierMap = new SparseArray();
            MilStdSymbol mSymbol = new MilStdSymbol(symbolCode, null, geoCoords, (SparseArray<String>)modifierMap);
            tgl = clsRenderer.createTGLightFromMilStdSymbol(mSymbol, ipc);
            tgl.set_FillColor(new Color(150, 150, 150, 20));
            tgl.set_T1("5000");
            tgl.set_H("10000");
            tgl.set_H2("5400");
            if (bboxCoords == null) {
                clsRenderer.render_GE(tgl, shapes, modifiers, ipc, rect);
            } else {
                clsRenderer.render_GE(tgl, shapes, modifiers, ipc, bboxCoords);
            }
            jsonOutput.append("{\"type\":\"symbol\",");
            jsonContent = MultiPointHandler.JSONize(shapes, modifiers, ipc, true, normalize);
            jsonOutput.append(jsonContent);
            jsonOutput.append("}");
        }
        catch (Exception exc) {
            jsonOutput = new StringBuilder();
            jsonOutput.append("{\"type\":\"error\",\"error\":\"There was an error creating the MilStdSymbol - ");
            jsonOutput.append(exc.getMessage() + " - ");
            jsonOutput.append("\"}");
        }
        boolean debug = true;
        if (debug) {
            System.out.println("Symbol Code: " + symbolCode);
            System.out.println("Scale: " + scale);
            System.out.println("BBOX: " + bbox);
            if (controlPoints != null) {
                System.out.println("Geo Points: " + controlPoints);
            }
            if (bbox != null) {
                System.out.println("geo bounds: " + bbox);
            }
            if (rect != null) {
                System.out.println("pixel bounds: " + rect.toString());
            }
            if (jsonOutput != null) {
                System.out.println(jsonOutput.toString());
            }
        }
        return ipc;
    }

    private static String KMLize(String id, String name, String description, String symbolCode, ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor) {
        java.lang.StringBuilder kml = new java.lang.StringBuilder();
        ShapeInfo tempModifier = null;
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        int len = shapes.size();
        kml.append("<Folder id=\"" + id + "\">");
        kml.append("<name>" + cdataStart + name + cdataEnd + "</name>");
        kml.append("<visibility>1</visibility>");
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToKMLString(name, description, symbolCode, shapes.get(i), ipc, normalize);
            kml.append(shapesToAdd);
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToKMLString(tempModifier, ipc, normalize, textColor);
            kml.append(labelsToAdd);
        }
        kml.append("</Folder>");
        return kml.toString();
    }

    private static String JSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, Boolean geMap, boolean normalize) {
        String polygons = "";
        String lines = "";
        String labels = "";
        String jstr = "";
        ShapeInfo tempModifier = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd;
            if (jstr.length() > 0) {
                jstr = jstr + ",";
            }
            if ((shapesToAdd = MultiPointHandler.ShapeToJSONString(shapes.get(i), ipc, geMap, normalize)).length() <= 0) continue;
            if (shapesToAdd.startsWith("line", 2)) {
                if (lines.length() > 0) {
                    lines = lines + ",";
                }
                lines = lines + shapesToAdd;
                continue;
            }
            if (!shapesToAdd.startsWith("polygon", 2)) continue;
            if (polygons.length() > 0) {
                polygons = polygons + ",";
            }
            polygons = polygons + shapesToAdd;
        }
        jstr = jstr + "\"polygons\": [" + polygons + "],\"lines\": [" + lines + "],";
        int len2 = modifiers.size();
        labels = "";
        for (int j = 0; j < len2; ++j) {
            String labelsToAdd;
            tempModifier = modifiers.get(j);
            if (geMap.booleanValue()) {
                MultiPointHandler.AdjustModifierPointToCenter(tempModifier);
            }
            if ((labelsToAdd = MultiPointHandler.LabelToJSONString(tempModifier, ipc, normalize)).length() <= 0) continue;
            if (labels.length() > 0) {
                labels = labels + ",";
            }
            labels = labels + labelsToAdd;
        }
        jstr = jstr + "\"labels\": [" + labels + "]";
        return jstr;
    }

    private static Color getIdealTextBackgroundColor(Color fgColor) {
        try {
            float[] hsbvals = new float[3];
            if (fgColor != null) {
                int nThreshold = RendererSettings.getInstance().getTextBackgroundAutoColorThreshold();
                int bgDelta = (int)((double)fgColor.getRed() * 0.299 + (double)fgColor.getGreen() * 0.587 + (double)fgColor.getBlue() * 0.114);
                return 255 - bgDelta < nThreshold ? new Color(0, 0, 0, fgColor.getAlpha()) : new Color(255, 255, 255, fgColor.getAlpha());
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("SymbolDraw", "getIdealtextBGColor", exc);
        }
        return Color.WHITE;
    }

    private static String LabelToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        Color outlineColor = MultiPointHandler.getIdealTextBackgroundColor(textColor);
        if (textBackgroundColor != null) {
            outlineColor = textBackgroundColor;
        }
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierStringPosition().getX(), shapeInfo.getModifierStringPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        double angle = shapeInfo.getModifierStringAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        String text = shapeInfo.getModifierString();
        int justify = shapeInfo.getTextJustify();
        String strJustify = "left";
        if (justify == 0) {
            strJustify = "left";
        } else if (justify == 1) {
            strJustify = "center";
        } else if (justify == 2) {
            strJustify = "right";
        }
        RendererSettings RS = RendererSettings.getInstance();
        if (text != null && !text.equals("")) {
            JSONed.append("{\"type\":\"Feature\",\"properties\":{\"label\":\"");
            JSONed.append(text);
            JSONed.append("\",\"pointRadius\":0,\"fontColor\":\"");
            JSONed.append(SymbolUtilities.colorToHexString(textColor, false));
            JSONed.append("\",\"fontSize\":\"");
            JSONed.append(String.valueOf(RS.getMPModifierFontSize()) + "pt\"");
            JSONed.append(",\"fontFamily\":\"");
            JSONed.append(RS.getMPModifierFontName());
            JSONed.append(", sans-serif");
            if (RS.getMPModifierFontType() == 1) {
                JSONed.append("\",\"fontWeight\":\"bold\"");
            } else {
                JSONed.append("\",\"fontWeight\":\"normal\"");
            }
        } else {
            return "";
        }
        JSONed.append(",\"labelAlign\":\"");
        JSONed.append(strJustify);
        JSONed.append("\",\"labelBaseline\":\"alphabetic\"");
        JSONed.append(",\"labelXOffset\":0");
        JSONed.append(",\"labelYOffset\":0");
        JSONed.append(",\"labelOutlineColor\":\"");
        JSONed.append(SymbolUtilities.colorToHexString(outlineColor, false));
        JSONed.append("\",\"labelOutlineWidth\":");
        JSONed.append("4");
        JSONed.append(",\"rotation\":");
        JSONed.append(angle);
        JSONed.append(",\"angle\":");
        JSONed.append(angle);
        JSONed.append("},");
        JSONed.append("\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append("}}");
        return JSONed.toString();
    }

    private static String ShapeToGeoJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        StringBuilder geometry = new StringBuilder();
        String geometryType = null;
        Color lineColor = shapeInfo.getLineColor();
        Color fillColor = shapeInfo.getFillColor();
        geometryType = shapeInfo.getShapeType() == 1 || fillColor != null ? "\"Polygon\"" : "\"MultiLineString\"";
        BasicStroke stroke = null;
        stroke = (BasicStroke)shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        properties.append("\"properties\":{");
        properties.append("\"label\":\"\",");
        if (lineColor != null) {
            properties.append("\"strokeColor\":\"" + SymbolUtilities.colorToHexString(lineColor, false) + "\",");
            properties.append("\"lineOpacity\":" + String.valueOf((float)lineColor.getAlpha() / 255.0f) + ",");
        }
        if (fillColor != null) {
            properties.append("\"fillColor\":\"" + SymbolUtilities.colorToHexString(fillColor, false) + "\",");
            properties.append("\"fillOpacity\":" + String.valueOf((float)fillColor.getAlpha() / 255.0f) + ",");
        }
        String strokeWidth = String.valueOf(lineWidth);
        properties.append("\"strokeWidth\":" + strokeWidth + ",");
        properties.append("\"strokeWeight\":" + strokeWidth + "");
        properties.append("}");
        geometry.append("\"geometry\":{\"type\":");
        geometry.append(geometryType);
        geometry.append(",\"coordinates\":[");
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        for (int i = 0; i < shapesArray.size(); ++i) {
            ArrayList<Point2D> pointList = shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(pointList, ipc);
            geometry.append("[");
            for (int j = 0; j < pointList.size(); ++j) {
                Point2D coord = pointList.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && fillColor != null && longitude > 0.0) {
                    longitude -= 360.0;
                }
                coord = new Point2D.Double(longitude, latitude);
                pointList.set(j, coord);
                geometry.append("[");
                geometry.append(longitude);
                geometry.append(",");
                geometry.append(latitude);
                geometry.append("]");
                if (j >= pointList.size() - 1) continue;
                geometry.append(",");
            }
            geometry.append("]");
            if (i >= shapesArray.size() - 1) continue;
            geometry.append(",");
        }
        geometry.append("]}");
        JSONed.append("{\"type\":\"Feature\",");
        JSONed.append(properties.toString());
        JSONed.append(",");
        JSONed.append(geometry.toString());
        JSONed.append("}");
        return JSONed.toString();
    }

    private static String GeoJSONize(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize, Color textColor, Color textBackgroundColor) {
        String jstr = "";
        ShapeInfo tempModifier = null;
        StringBuilder fc = new StringBuilder();
        fc.append("[");
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            String shapesToAdd = MultiPointHandler.ShapeToGeoJSONString(shapes.get(i), ipc, normalize);
            if (shapesToAdd.length() > 0) {
                fc.append(shapesToAdd);
            }
            if (i >= len - 1) continue;
            fc.append(",");
        }
        int len2 = modifiers.size();
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            String labelsToAdd = MultiPointHandler.LabelToGeoJSONString(tempModifier, ipc, normalize, textColor, textBackgroundColor);
            if (labelsToAdd.length() <= 0) continue;
            fc.append(",");
            fc.append(labelsToAdd);
        }
        fc.append("]");
        String GeoJSON = fc.toString();
        return GeoJSON;
    }

    private static String GenerateGroundOverlayKML(String urlImage, IPointConversion ipc, Rectangle symbolBounds, boolean normalize) {
        double x = 0.0;
        double y = 0.0;
        double height = 0.0;
        double width = 0.0;
        StringBuilder sb = new StringBuilder();
        Boolean lineFill = false;
        Map params = null;
        int symbolSize = 0;
        int imageOffset = 0;
        try {
            int index = -1;
            index = urlImage.indexOf(91);
            if (index > 0) {
                lineFill = true;
                if (params.containsKey(92)) {
                    String size = (String)params.get(92);
                    symbolSize = Integer.decode(size);
                }
                imageOffset = symbolSize / 2 + 3;
            }
            Rectangle bounds = null;
            bounds = symbolBounds;
            height = bounds.getHeight() + imageOffset * 2;
            width = bounds.getWidth() + imageOffset * 2;
            x = bounds.getX() - (double)imageOffset;
            y = bounds.getY() - imageOffset;
            Point2D.Double coord = new Point2D.Double(x, y);
            Point2D topLeft = ipc.PixelsToGeo(coord);
            coord = new Point2D.Double(x + width, y + height);
            Point2D bottomRight = ipc.PixelsToGeo(coord);
            if (normalize) {
                topLeft = MultiPointHandler.NormalizeCoordToGECoord(topLeft);
                bottomRight = MultiPointHandler.NormalizeCoordToGECoord(bottomRight);
            }
            String cdataStart = "<![CDATA[";
            String cdataEnd = "]]>";
            sb.append("<GroundOverlay>");
            sb.append("<name>symbol fill</name>");
            sb.append("<description>symbol fill</description>");
            sb.append("<Icon>");
            sb.append("<href>");
            sb.append(cdataStart);
            sb.append(urlImage);
            sb.append(cdataEnd);
            sb.append("</href>");
            sb.append("</Icon>");
            sb.append("<LatLonBox>");
            sb.append("<north>");
            sb.append(String.valueOf(topLeft.getY()));
            sb.append("</north>");
            sb.append("<south>");
            sb.append(String.valueOf(bottomRight.getY()));
            sb.append("</south>");
            sb.append("<east>");
            sb.append(String.valueOf(bottomRight.getX()));
            sb.append("</east>");
            sb.append("<west>");
            sb.append(String.valueOf(topLeft.getX()));
            sb.append("</west>");
            sb.append("<rotation>");
            sb.append(0);
            sb.append("</rotation>");
            sb.append("</LatLonBox>");
            sb.append("</GroundOverlay>");
        }
        catch (Exception exc) {
            System.out.println(exc.getMessage());
            exc.printStackTrace();
        }
        String kml = sb.toString();
        return kml;
    }

    private static void MakeWWReady(ArrayList<ShapeInfo> shapes, ArrayList<ShapeInfo> modifiers, IPointConversion ipc, boolean normalize) {
        ShapeInfo temp = null;
        int len = shapes.size();
        for (int i = 0; i < len; ++i) {
            temp = MultiPointHandler.ShapeToWWReady(shapes.get(i), ipc, normalize);
            shapes.set(i, temp);
        }
        int len2 = modifiers.size();
        ShapeInfo tempModifier = null;
        for (int j = 0; j < len2; ++j) {
            tempModifier = modifiers.get(j);
            tempModifier = MultiPointHandler.LabelToWWReady(tempModifier, ipc, normalize);
            modifiers.set(j, tempModifier);
        }
    }

    private static Boolean normalizePoints(ArrayList<Point2D.Double> shape, IPointConversion ipc) {
        ArrayList<Point2D> geoCoords = new ArrayList<Point2D>();
        int n = shape.size();
        for (int j = 0; j < n; ++j) {
            Point2D coord = shape.get(j);
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            Point2D.Double pt2d = new Point2D.Double(longitude, latitude);
            geoCoords.add(pt2d);
        }
        Boolean normalize = MultiPointHandler.crossesIDL(geoCoords);
        return normalize;
    }

    private static Boolean IsOnePointSymbolCode(String symbolCode) {
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        String basicCode = SymbolUtilities.getBasicSymbolID(symbolCode);
        if (symbolCode.equals("CAKE-----------")) {
            return true;
        }
        if (symbolCode.equals("CYLINDER-------")) {
            return true;
        }
        if (symbolCode.equals("RADARC---------")) {
            return true;
        }
        return false;
    }

    private static String ShapeToKMLString(String name, String description, String symbolCode, ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        java.lang.StringBuilder kml = new java.lang.StringBuilder();
        Color lineColor = null;
        Color fillColor = null;
        String googleLineColor = null;
        String googleFillColor = null;
        BasicStroke stroke = null;
        int lineWidth = 4;
        symbolCode = JavaRendererUtilities.normalizeSymbolCode(symbolCode);
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        kml.append("<Placemark>");
        kml.append("<description>" + cdataStart + "<b>" + name + "</b><br/>\n" + description + cdataEnd + "</description>");
        kml.append("<Style>");
        lineColor = shapeInfo.getLineColor();
        if (lineColor != null) {
            googleLineColor = Integer.toHexString(shapeInfo.getLineColor().toARGB());
            stroke = (BasicStroke)shapeInfo.getStroke();
            if (stroke != null) {
                lineWidth = (int)stroke.getLineWidth();
            }
            googleLineColor = JavaRendererUtilities.ARGBtoABGR(googleLineColor);
            kml.append("<LineStyle>");
            kml.append("<color>" + googleLineColor + "</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<width>" + String.valueOf(lineWidth) + "</width>");
            kml.append("</LineStyle>");
        }
        if ((fillColor = shapeInfo.getFillColor()) != null) {
            googleFillColor = Integer.toHexString(shapeInfo.getFillColor().toARGB());
            googleFillColor = JavaRendererUtilities.ARGBtoABGR(googleFillColor);
            kml.append("<PolyStyle>");
            kml.append("<color>" + googleFillColor + "</color>");
            kml.append("<colorMode>normal</colorMode>");
            kml.append("<fill>1</fill>");
            if (lineColor != null) {
                kml.append("<outline>1</outline>");
            } else {
                kml.append("<outline>0</outline>");
            }
            kml.append("</PolyStyle>");
        }
        kml.append("</Style>");
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        kml.append("<MultiGeometry>");
        for (int i = 0; i < len; ++i) {
            Point2D geoCoord;
            double longitude;
            ArrayList<Point2D> shape = shapesArray.get(i);
            normalize = MultiPointHandler.normalizePoints(shape, ipc);
            if (lineColor != null && fillColor == null) {
                kml.append("<LineString>");
                kml.append("<tessellate>1</tessellate>");
                kml.append("<altitudeMode>clampToGround</altitudeMode>");
                kml.append("<coordinates>");
                int n = shape.size();
                for (int j = 0; j < n; ++j) {
                    Point2D coord = shape.get(j);
                    Point2D geoCoord2 = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord2 = MultiPointHandler.NormalizeCoordToGECoord(geoCoord2);
                    }
                    double latitude = (double)Math.round(geoCoord2.getY() * 1.0E8) / 1.0E8;
                    longitude = (double)Math.round(geoCoord2.getX() * 1.0E8) / 1.0E8;
                    kml.append(longitude);
                    kml.append(",");
                    kml.append(latitude);
                    if (j >= shape.size() - 1) continue;
                    kml.append(" ");
                }
                kml.append("</coordinates>");
                kml.append("</LineString>");
            }
            if (fillColor == null) continue;
            if (i == 0) {
                kml.append("<Polygon>");
            }
            if (i == 1 && len > 1) {
                kml.append("<innerBoundaryIs>");
            } else {
                kml.append("<outerBoundaryIs>");
            }
            kml.append("<LinearRing>");
            kml.append("<altitudeMode>clampToGround</altitudeMode>");
            kml.append("<tessellate>1</tessellate>");
            kml.append("<coordinates>");
            double lastLongitude = Double.MIN_VALUE;
            if (!normalize && MultiPointHandler.IsOnePointSymbolCode(symbolCode).booleanValue()) {
                int n = shape.size();
                for (int j = 0; j < n; ++j) {
                    Point2D coord = shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    longitude = geoCoord.getX();
                    if (lastLongitude != Double.MIN_VALUE && Math.abs(longitude - lastLongitude) > 180.0) {
                        normalize = true;
                        break;
                    }
                    lastLongitude = longitude;
                }
            }
            int n = shape.size();
            for (int j = 0; j < n; ++j) {
                Point2D coord = shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
                double longitude2 = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
                if (normalize && longitude2 > 0.0) {
                    longitude2 -= 360.0;
                }
                kml.append(longitude2);
                kml.append(",");
                kml.append(latitude);
                if (j >= shape.size() - 1) continue;
                kml.append(" ");
            }
            kml.append("</coordinates>");
            kml.append("</LinearRing>");
            if (i == 1 && len > 1) {
                kml.append("</innerBoundaryIs>");
            } else {
                kml.append("</outerBoundaryIs>");
            }
            if (i != len - 1) continue;
            kml.append("</Polygon>");
        }
        kml.append("</MultiGeometry>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static ShapeInfo ShapeToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int len = shapesArray.size();
        for (int i = 0; i < len; ++i) {
            Point2D geoCoord;
            Point2D coord;
            int j;
            int n;
            ArrayList<Point2D> shape = shapesArray.get(i);
            if (shapeInfo.getLineColor() != null) {
                n = shape.size();
                for (j = 0; j < n; ++j) {
                    coord = shape.get(j);
                    geoCoord = ipc.PixelsToGeo(coord);
                    if (normalize) {
                        geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                    }
                    shape.set(j, geoCoord);
                }
            }
            if (shapeInfo.getFillColor() == null) continue;
            n = shape.size();
            for (j = 0; j < n; ++j) {
                coord = shape.get(j);
                geoCoord = ipc.PixelsToGeo(coord);
                shape.set(j, geoCoord);
            }
        }
        return shapeInfo;
    }

    private static ShapeInfo LabelToWWReady(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        try {
            Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
            Point2D geoCoord = ipc.PixelsToGeo(coord);
            if (normalize) {
                geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
            }
            double latitude = geoCoord.getY();
            double longitude = geoCoord.getX();
            long angle = Math.round(shapeInfo.getModifierStringAngle());
            String text = shapeInfo.getModifierString();
            if (text == null || text.equals("")) {
                return null;
            }
            shapeInfo.setModifierStringPosition(geoCoord);
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
        return shapeInfo;
    }

    private static void AdjustModifierPointToCenter(ShapeInfo modifier) {
        Object at = null;
        try {
            Rectangle bounds2 = modifier.getTextLayout().getBounds();
            Rectangle2D.Double double_ = new Rectangle2D.Double(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
            exc.printStackTrace();
        }
    }

    private static String ShapeToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, Boolean geMap, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        String fillColor = null;
        String lineColor = null;
        if (shapeInfo.getLineColor() != null) {
            lineColor = Integer.toHexString(shapeInfo.getLineColor().toARGB());
            if (geMap.booleanValue()) {
                lineColor = JavaRendererUtilities.ARGBtoABGR(lineColor);
            }
        }
        if (shapeInfo.getFillColor() != null) {
            fillColor = Integer.toHexString(shapeInfo.getFillColor().toARGB());
            if (geMap.booleanValue()) {
                fillColor = JavaRendererUtilities.ARGBtoABGR(fillColor);
            }
        }
        BasicStroke stroke = null;
        stroke = (BasicStroke)shapeInfo.getStroke();
        int lineWidth = 4;
        if (stroke != null) {
            lineWidth = (int)stroke.getLineWidth();
        }
        ArrayList<ArrayList<Point2D>> shapesArray = shapeInfo.getPolylines();
        int n = shapesArray.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Point2D> shape = shapesArray.get(i);
            if (fillColor != null) {
                JSONed.append("{\"polygon\":[");
            } else {
                JSONed.append("{\"line\":[");
            }
            int t = shape.size();
            for (int j = 0; j < t; ++j) {
                Point2D coord = shape.get(j);
                Point2D geoCoord = ipc.PixelsToGeo(coord);
                if (normalize) {
                    geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
                }
                double latitude = geoCoord.getY();
                double longitude = geoCoord.getX();
                coord = new Point2D.Double(longitude, latitude);
                shape.set(j, coord);
                JSONed.append("[");
                JSONed.append(longitude);
                JSONed.append(",");
                JSONed.append(latitude);
                JSONed.append("]");
                if (j >= shape.size() - 1) continue;
                JSONed.append(",");
            }
            JSONed.append("]");
            if (lineColor != null) {
                JSONed.append(",\"lineColor\":\"");
                JSONed.append(lineColor);
                JSONed.append("\"");
            }
            if (fillColor != null) {
                JSONed.append(",\"fillColor\":\"");
                JSONed.append(fillColor);
                JSONed.append("\"");
            }
            JSONed.append(",\"lineWidth\":\"");
            JSONed.append(String.valueOf(lineWidth));
            JSONed.append("\"");
            JSONed.append("}");
            if (i >= shapesArray.size() - 1) continue;
            JSONed.append(",");
        }
        return JSONed.toString();
    }

    private static String LabelToKMLString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize, Color textColor) {
        java.lang.StringBuilder kml = new java.lang.StringBuilder();
        Point2D.Double coord = new Point2D.Double(shapeInfo.getModifierStringPosition().getX(), shapeInfo.getModifierStringPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = (double)Math.round(geoCoord.getY() * 1.0E8) / 1.0E8;
        double longitude = (double)Math.round(geoCoord.getX() * 1.0E8) / 1.0E8;
        long angle = Math.round(shapeInfo.getModifierStringAngle());
        String text = shapeInfo.getModifierString();
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        String color = Integer.toHexString(textColor.toARGB());
        color = JavaRendererUtilities.ARGBtoABGR(color);
        float kmlScale = RendererSettings.getInstance().getKMLLabelScale();
        if (!(kmlScale > 0.0f) || text == null || text.equals("")) {
            return "";
        }
        kml.append("<Placemark>");
        kml.append("<name>" + cdataStart + text + cdataEnd + "</name>");
        kml.append("<Style>");
        kml.append("<IconStyle>");
        kml.append("<scale>.7</scale>");
        kml.append("<heading>" + angle + "</heading>");
        kml.append("<Icon>");
        kml.append("<href></href>");
        kml.append("</Icon>");
        kml.append("</IconStyle>");
        kml.append("<LabelStyle>");
        kml.append("<color>" + color + "</color>");
        kml.append("<scale>" + String.valueOf(kmlScale) + "</scale>");
        kml.append("</LabelStyle>");
        kml.append("</Style>");
        kml.append("<Point>");
        kml.append("<extrude>1</extrude>");
        kml.append("<altitudeMode>relativeToGround</altitudeMode>");
        kml.append("<coordinates>");
        kml.append(longitude);
        kml.append(",");
        kml.append(latitude);
        kml.append("</coordinates>");
        kml.append("</Point>");
        kml.append("</Placemark>");
        return kml.toString();
    }

    private static String LabelToJSONString(ShapeInfo shapeInfo, IPointConversion ipc, boolean normalize) {
        StringBuilder JSONed = new StringBuilder();
        JSONed.append("{\"label\":");
        Point2D.Double coord = new Point2D.Double(shapeInfo.getGlyphPosition().getX(), shapeInfo.getGlyphPosition().getY());
        Point2D geoCoord = ipc.PixelsToGeo(coord);
        if (normalize) {
            geoCoord = MultiPointHandler.NormalizeCoordToGECoord(geoCoord);
        }
        double latitude = geoCoord.getY();
        double longitude = geoCoord.getX();
        double angle = shapeInfo.getModifierStringAngle();
        ((Point2D)coord).setLocation(longitude, latitude);
        shapeInfo.setGlyphPosition(coord);
        String text = shapeInfo.getModifierString();
        if (text == null || text.equals("")) {
            return "";
        }
        JSONed.append("[");
        JSONed.append(longitude);
        JSONed.append(",");
        JSONed.append(latitude);
        JSONed.append("]");
        JSONed.append(",\"text\":\"");
        JSONed.append(text);
        JSONed.append("\"");
        JSONed.append(",\"angle\":\"");
        JSONed.append(angle);
        JSONed.append("\"}");
        return JSONed.toString();
    }

    static String canRenderMultiPoint(MilStdSymbol symbol) {
        int symStd = symbol.getSymbologyStandard();
        String symbolID = symbol.getSymbolID();
        String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
        SymbolDef sd = null;
        int dc = 99;
        int coordCount = symbol.getCoordinates().size();
        try {
            ArrayList<Double> AN;
            String message = "";
            if (SymbolDefTable.getInstance().HasSymbolDef(basicID, symStd).booleanValue()) {
                sd = SymbolDefTable.getInstance().getSymbolDef(basicID, symStd);
            }
            if (sd != null) {
                dc = sd.getDrawCategory();
                if (coordCount < sd.getMinPoints()) {
                    message = "symbolID: \"" + symbolID + "\" requires a minimum of " + String.valueOf(sd.getMinPoints()) + " points. " + String.valueOf(coordCount) + " are present.";
                    return message;
                }
            } else {
                if (symbolID.startsWith("BS_")) {
                    return "true";
                }
                if (symbolID.startsWith("BBS_")) {
                    ArrayList<Double> AM = symbol.getModifiers_AM_AN_X(16);
                    if (AM != null && AM.size() > 0 && AM.get(0) >= 0.0) {
                        return "true";
                    }
                    return "false: Buffered Basic Shapes require a width (AM)";
                }
                if (symbolID.startsWith("PBS_")) {
                    ArrayList<Double> AM = symbol.getModifiers_AM_AN_X(16);
                    if (symbolID.equals("PBS_CIRCLE-----") || symbolID.equals("PBS_SQUARE-----")) {
                        if (AM != null && AM.size() > 0 && coordCount > 0) {
                            return "true";
                        }
                        return "false: " + symbolID + ", requires a width (AM) and 1 control point";
                    }
                    if (symbolID.equals("PBS_ELLIPSE----") || symbolID.equals("PBS_RECTANGLE--")) {
                        if (AM != null && AM.size() > 1 && coordCount > 0) {
                            return "true";
                        }
                        return "false: " + symbolID + ", requires 2 AM values, length and width (AM) and 1 control point";
                    }
                    return "false: " + symbolID + ", not a recognized code for a parametered basic shape.";
                }
                return "symbolID: \"" + symbolID + "\" not recognized.";
            }
            ArrayList<Double> AM = symbol.getModifiers_AM_AN_X(16);
            String result = MultiPointHandler.hasRequiredModifiers(symbolID, dc, AM, AN = symbol.getModifiers_AM_AN_X(17));
            if (!result.equals("true")) {
                return result;
            }
            return "true";
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MultiPointHandler", "canRenderMultiPoint", exc);
            return "true";
        }
    }

    private static String AddImageFillToKML(ArrayList<POINT2> tgPoints, String jsonContent, SparseArray symbolModifiers, IPointConversion ipc, Boolean normalize) {
        if (tgPoints == null || tgPoints.size() == 0) {
            return null;
        }
        ArrayList<Point2D> pixelPoints = new ArrayList<Point2D>();
        GeneralPath path = new GeneralPath();
        int kcount = tgPoints.size();
        POINT2 tpTemp = null;
        for (int k = 0; k < kcount; ++k) {
            tpTemp = tgPoints.get(k);
            pixelPoints.add(new Point2D.Double(tpTemp.x, tpTemp.y));
            if (k > 0) {
                path.lineTo(tpTemp.x, tpTemp.y);
                continue;
            }
            path.moveTo(tpTemp.x, tpTemp.y);
        }
        Rectangle rect = path.getBounds();
        String goImageUrl = SECWebRenderer.GenerateSymbolLineFillUrl((SparseArray<String>)symbolModifiers, pixelPoints, rect);
        String goKML = MultiPointHandler.GenerateGroundOverlayKML(goImageUrl, ipc, rect, normalize);
        goKML = goKML + "</Folder>";
        jsonContent = jsonContent.replace("</Folder>", goKML);
        return jsonContent;
    }

    private static String hasRequiredModifiers(String symbolID, int dc, ArrayList<Double> AM, ArrayList<Double> AN) {
        String message = symbolID;
        try {
            if (dc >= 16 && dc <= 20) {
                if (dc == 16) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                if (dc == 17) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 1 azimuth/AN value.";
                    return message;
                }
                if (dc == 18) {
                    if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 2) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 2 distance/AM values and 2 azimuth/AN values per sector.  The first sector can have just one AM value although it is recommended to always use 2 values for each sector.";
                    return message;
                }
                if (dc == 19) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has at least 1 distance/AM value";
                    return message;
                }
                if (dc == 20) {
                    if (AM != null && AM.size() > 0) {
                        return "true";
                    }
                    message = message + " requires a modifiers object that has 1 distance/AM value.";
                    return message;
                }
                return "true";
            }
            return "true";
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MultiPointHandler", "hasRequiredModifiers", exc);
            return "true";
        }
    }
}

