/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import sec.sun.awt.geom.Arrays;
import sec.sun.awt.geom.ChainEnd;
import sec.sun.awt.geom.CurveLink;
import sec.sun.awt.geom.CurveObject;
import sec.sun.awt.geom.Edge;
import sec.sun.awt.geom.Enumeration;
import sec.sun.awt.geom.Order0;
import sec.sun.awt.geom.Order1;
import sec.sun.awt.geom.Order2;
import sec.sun.awt.geom.Order3;
import sec.sun.awt.geom.Vector;

public class SomeOp {
    public static final int SUBOP = 0;
    public static final int ADDOP = 1;
    public static final int INTOP = 2;
    public static final int XOROP = 3;
    private int _type = -1;
    boolean inLeft;
    boolean inRight;
    boolean inResult;
    private static CurveLink[] EmptyLinkList = new CurveLink[2];
    private static ChainEnd[] EmptyChainList = new ChainEnd[2];

    public SomeOp(int type) {
        this._type = type;
    }

    public void newRow() {
        this.inLeft = false;
        this.inRight = false;
        this.inResult = false;
    }

    public int classify(Edge e) {
        if (e.getCurveTag() == 0) {
            this.inLeft = !this.inLeft;
        } else {
            this.inRight = !this.inRight;
        }
        boolean newClass = this.newClassification(this.inLeft, this.inRight);
        if (this.inResult == newClass) {
            return 0;
        }
        this.inResult = newClass;
        return newClass ? 1 : -1;
    }

    public int getState() {
        return this.inResult ? 1 : -1;
    }

    public boolean newClassification(boolean inLeft, boolean inRight) {
        switch (this._type) {
            case 1: {
                return inLeft || inRight;
            }
            case 0: {
                return inLeft && !inRight;
            }
            case 2: {
                return inLeft && inRight;
            }
            case 3: {
                return inLeft != inRight;
            }
        }
        return false;
    }

    public Vector calculate(Vector left, Vector right) {
        Vector edges = new Vector();
        SomeOp.addEdges(edges, left, 0);
        SomeOp.addEdges(edges, right, 1);
        edges = this.pruneEdges(edges);
        return edges;
    }

    private static void addEdges(Vector edges, Vector curves, int curvetag) {
        Enumeration enum_ = curves.elements();
        CurveObject c = null;
        Object obj = null;
        while (enum_.hasMoreElements()) {
            obj = enum_.nextElement();
            c = obj instanceof CurveObject ? (CurveObject)obj : new CurveObject(obj);
            if (c.getOrder() <= 0) continue;
            edges.add(new Edge(c, curvetag));
        }
    }

    private Vector pruneEdges(Vector edges) {
        int numedges = edges.size();
        if (numedges < 2) {
            return edges;
        }
        Object[] edgelist = new Edge[numedges];
        Enumeration _enum = edges.elements();
        int k = 0;
        while (_enum.hasMoreElements()) {
            edgelist[k++] = (Edge)_enum.nextElement();
        }
        Arrays.sort(edgelist);
        int left = 0;
        int right = 0;
        int cur = 0;
        int next = 0;
        double[] yrange = new double[2];
        Vector subcurves = new Vector();
        Vector chains = new Vector();
        Vector links = new Vector();
        while (left < numedges) {
            Object e;
            double y = yrange[0];
            for (cur = next = right - 1; cur >= left; --cur) {
                e = edgelist[cur];
                if (!(((Edge)e).getCurve().getYBot() > y)) continue;
                if (next > cur) {
                    edgelist[next] = e;
                }
                --next;
            }
            left = next + 1;
            if (left >= right) {
                if (right >= numedges) break;
                y = ((Edge)edgelist[right]).getCurve().getYTop();
                if (y > yrange[0]) {
                    SomeOp.finalizeSubCurves(subcurves, chains);
                }
                yrange[0] = y;
            }
            while (right < numedges && !(((Edge)(e = edgelist[right])).getCurve().getYTop() > y)) {
                ++right;
            }
            yrange[1] = ((Edge)edgelist[left]).getCurve().getYBot();
            if (right < numedges && yrange[1] > (y = ((Edge)edgelist[right]).getCurve().getYTop())) {
                yrange[1] = y;
            }
            int nexteq = 1;
            for (cur = left; cur < right; ++cur) {
                e = edgelist[cur];
                ((Edge)e).setEquivalence(0);
                for (next = cur; next > left; --next) {
                    Object prevedge = edgelist[next - 1];
                    int ordering = ((Edge)e).compareTo((Edge)prevedge, yrange);
                    if (yrange[1] <= yrange[0]) {
                        throw new InternalError("backstepping to " + yrange[1] + " from " + yrange[0]);
                    }
                    if (ordering >= 0) {
                        if (ordering != 0) break;
                        int eq = ((Edge)prevedge).getEquivalence();
                        if (eq == 0) {
                            eq = nexteq++;
                            ((Edge)prevedge).setEquivalence(eq);
                        }
                        ((Edge)e).setEquivalence(eq);
                        break;
                    }
                    edgelist[next] = prevedge;
                }
                edgelist[next] = e;
            }
            this.newRow();
            double ystart = yrange[0];
            double yend = yrange[1];
            for (cur = left; cur < right; ++cur) {
                int etag;
                e = edgelist[cur];
                int eq = ((Edge)e).getEquivalence();
                if (eq != 0) {
                    int origstate = this.getState();
                    etag = origstate == 1 ? -1 : 1;
                    Object activematch = null;
                    Object longestmatch = e;
                    double furthesty = yend;
                    do {
                        this.classify((Edge)e);
                        if (activematch == null && ((Edge)e).isActiveFor(ystart, etag)) {
                            activematch = e;
                        }
                        if (!((y = ((Edge)e).getCurve().getYBot()) > furthesty)) continue;
                        longestmatch = e;
                        furthesty = y;
                    } while (++cur < right && ((Edge)(e = edgelist[cur])).getEquivalence() == eq);
                    --cur;
                    if (this.getState() == origstate) {
                        etag = 0;
                    } else {
                        e = activematch != null ? activematch : longestmatch;
                    }
                } else {
                    etag = this.classify((Edge)e);
                }
                if (etag == 0) continue;
                ((Edge)e).record(yend, etag);
                links.add(new CurveLink(((Edge)e).getCurve(), ystart, yend, etag));
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (right - left));
                System.out.println("num links = " + links.size());
                System.out.println("y top = " + yrange[0]);
                if (right < numedges) {
                    System.out.println("y top of next curve = " + ((Edge)edgelist[right]).getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                for (cur = left; cur < right; ++cur) {
                    e = edgelist[cur];
                    System.out.println(e);
                    int eq = ((Edge)e).getEquivalence();
                    if (eq == 0) continue;
                    System.out.println("  was equal to " + eq + "...");
                }
            }
            SomeOp.resolveLinks(subcurves, chains, links);
            links.clear();
            yrange[0] = yend;
        }
        SomeOp.finalizeSubCurves(subcurves, chains);
        Vector ret = new Vector();
        Enumeration enum_ = subcurves.elements();
        CurveObject c = null;
        Object obj = null;
        while (enum_.hasMoreElements()) {
            CurveLink link = (CurveLink)enum_.nextElement();
            ret.add(link.getMoveto());
            CurveLink nextlink = link;
            while ((nextlink = nextlink.getNext()) != null) {
                if (link.absorb(nextlink)) continue;
                obj = link.getSubCurve();
                if (obj instanceof Order0) {
                    c = ((Order0)obj).getParent();
                } else if (obj instanceof Order1) {
                    c = ((Order1)obj).getParent();
                } else if (obj instanceof Order2) {
                    c = ((Order2)obj).getParent();
                } else if (obj instanceof Order3) {
                    c = ((Order3)obj).getParent();
                } else if (obj instanceof CurveObject) {
                    c = (CurveObject)obj;
                }
                if (c == null) {
                    c = new CurveObject(obj);
                }
                ret.add(c);
                link = nextlink;
            }
            obj = link.getSubCurve();
            if (obj instanceof Order0) {
                c = ((Order0)obj).getParent();
            } else if (obj instanceof Order1) {
                c = ((Order1)obj).getParent();
            } else if (obj instanceof Order2) {
                c = ((Order2)obj).getParent();
            } else if (obj instanceof Order3) {
                c = ((Order3)obj).getParent();
            } else if (obj instanceof CurveObject) {
                c = (CurveObject)obj;
            }
            if (c == null) {
                c = new CurveObject(obj);
            }
            ret.add(c);
        }
        return ret;
    }

    public static void finalizeSubCurves(Vector subcurves, Vector chains) {
        int numchains = chains.size();
        if (numchains == 0) {
            return;
        }
        if ((numchains & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        Object[] endlist = new ChainEnd[numchains];
        chains.toArray(endlist);
        for (int i = 1; i < numchains; i += 2) {
            Object open = endlist[i - 1];
            Object close = endlist[i];
            CurveLink subcurve = ((ChainEnd)open).linkTo((ChainEnd)close);
            if (subcurve == null) continue;
            subcurves.add(subcurve);
        }
        chains.clear();
    }

    public static void resolveLinks(Vector subcurves, Vector chains, Vector links) {
        Object[] endlist;
        Object[] linklist;
        int numlinks = links.size();
        if (numlinks == 0) {
            linklist = EmptyLinkList;
        } else {
            if ((numlinks & 1) != 0) {
                throw new InternalError("Odd number of new curves!");
            }
            linklist = new CurveLink[numlinks + 2];
            links.toArray(linklist);
        }
        int numchains = chains.size();
        if (numchains == 0) {
            endlist = EmptyChainList;
        } else {
            if ((numchains & 1) != 0) {
                throw new InternalError("Odd number of chains!");
            }
            endlist = new ChainEnd[numchains + 2];
            chains.toArray(endlist);
        }
        int curchain = 0;
        int curlink = 0;
        chains.clear();
        Object chain = endlist[0];
        Object nextchain = endlist[1];
        Object link = linklist[0];
        Object nextlink = linklist[1];
        while (chain != null || link != null) {
            boolean connectlinks;
            boolean connectchains = link == null;
            boolean bl = connectlinks = chain == null;
            if (!connectchains && !connectlinks) {
                connectchains = !(curchain & true) && ((ChainEnd)chain).getX() == ((ChainEnd)nextchain).getX();
                boolean bl2 = connectlinks = !(curlink & true) && ((CurveLink)link).getX() == ((CurveLink)nextlink).getX();
                if (!connectchains && !connectlinks) {
                    double cx = ((ChainEnd)chain).getX();
                    double lx = ((CurveLink)link).getX();
                    connectchains = nextchain != null && cx < lx && SomeOp.obstructs(((ChainEnd)nextchain).getX(), lx, curchain);
                    boolean bl3 = connectlinks = nextlink != null && lx < cx && SomeOp.obstructs(((CurveLink)nextlink).getX(), cx, curlink);
                }
            }
            if (connectchains) {
                CurveLink subcurve = ((ChainEnd)chain).linkTo((ChainEnd)nextchain);
                if (subcurve != null) {
                    subcurves.add(subcurve);
                }
                chain = endlist[curchain += 2];
                nextchain = endlist[curchain + 1];
            }
            if (connectlinks) {
                ChainEnd openend = new ChainEnd((CurveLink)link, null);
                ChainEnd closeend = new ChainEnd((CurveLink)nextlink, openend);
                openend.setOtherEnd(closeend);
                chains.add(openend);
                chains.add(closeend);
                link = linklist[curlink += 2];
                nextlink = linklist[curlink + 1];
            }
            if (connectchains || connectlinks) continue;
            ((ChainEnd)chain).addLink((CurveLink)link);
            chains.add(chain);
            chain = nextchain;
            nextchain = endlist[++curchain + 1];
            link = nextlink;
            nextlink = linklist[++curlink + 1];
        }
        if ((chains.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
    }

    public static boolean obstructs(double v1, double v2, int phase) {
        return (phase & 1) == 0 ? v1 <= v2 : v1 < v2;
    }
}

