/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import armyc2.c2sd.graphics2d.PathIterator;
import sec.sun.awt.geom.Crossings;
import sec.sun.awt.geom.Curve;
import sec.sun.awt.geom.CurveObject;
import sec.sun.awt.geom.Enumeration;
import sec.sun.awt.geom.EvenOdd;
import sec.sun.awt.geom.NonZero;
import sec.sun.awt.geom.Vector;

public class CrossingsObject {
    public static final int CROSSINGS = 0;
    public static final int NONZERO = 1;
    public static final int EVENODD = 2;
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;
    private int[] crosscounts = null;
    private EvenOdd evenOdd = null;
    private Crossings crossings = null;
    private NonZero nonZero = null;
    int type = -1;
    private Vector tmp = new Vector();

    public CrossingsObject(double xlo, double ylo, double xhi, double yhi, int type) {
        this.xlo = xlo;
        this.ylo = ylo;
        this.xhi = xhi;
        this.yhi = yhi;
        this.type = type;
        switch (type) {
            case 0: {
                this.crossings = new Crossings(xlo, ylo, xhi, yhi);
                break;
            }
            case 1: {
                this.nonZero = new NonZero(xlo, ylo, xhi, yhi);
                this.crosscounts = new int[this.yranges.length / 2];
                break;
            }
            case 2: {
                this.evenOdd = new EvenOdd(xlo, ylo, xhi, yhi);
            }
        }
    }

    public double getXLo() {
        switch (this.type) {
            case 0: {
                return this.crossings.getXLo();
            }
            case 2: {
                return this.evenOdd.getXLo();
            }
            case 1: {
                return this.nonZero.getXLo();
            }
        }
        return -1.0;
    }

    public double getYLo() {
        switch (this.type) {
            case 0: {
                return this.crossings.getYLo();
            }
            case 2: {
                return this.evenOdd.getYLo();
            }
            case 1: {
                return this.nonZero.getYLo();
            }
        }
        return -1.0;
    }

    public double getXHi() {
        switch (this.type) {
            case 0: {
                return this.crossings.getXHi();
            }
            case 2: {
                return this.evenOdd.getXHi();
            }
            case 1: {
                return this.nonZero.getXHi();
            }
        }
        return -1.0;
    }

    public double getYHi() {
        switch (this.type) {
            case 0: {
                return this.crossings.getYHi();
            }
            case 2: {
                return this.evenOdd.getYHi();
            }
            case 1: {
                return this.nonZero.getYHi();
            }
        }
        return -1.0;
    }

    public boolean isEmpty() {
        switch (this.type) {
            case 0: {
                return this.crossings.isEmpty();
            }
            case 2: {
                return this.evenOdd.isEmpty();
            }
            case 1: {
                return this.nonZero.isEmpty();
            }
        }
        return true;
    }

    public void record(double ystart, double yend, int direction) {
        switch (this.type) {
            case 0: {
                this.crossings.record(ystart, yend, direction);
            }
            case 2: {
                this.evenOdd.record(ystart, yend, direction);
            }
            case 1: {
                this.nonZero.record(ystart, yend, direction);
            }
        }
    }

    public static CrossingsObject findCrossings(Vector curves, double xlo, double ylo, double xhi, double yhi) {
        CrossingsObject cross = new CrossingsObject(xlo, ylo, xhi, yhi, 2);
        Enumeration enum_ = curves.elements();
        while (enum_.hasMoreElements()) {
            CurveObject c = (CurveObject)enum_.nextElement();
            if (!c.accumulateCrossings(cross)) continue;
            return null;
        }
        return cross;
    }

    public CrossingsObject findCrossings2(PathIterator pi, double xlo, double ylo, double xhi, double yhi) {
        CrossingsObject cross = pi.getWindingRule() == 0 ? new CrossingsObject(xlo, ylo, xhi, yhi, 2) : new CrossingsObject(xlo, ylo, xhi, yhi, 1);
        double[] coords = new double[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
                        return null;
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    if (cross.accumulateLine(curx, cury, newx, newy)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    double newx = coords[2];
                    double newy = coords[3];
                    if (cross.accumulateQuad(curx, cury, coords)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    double newx = coords[4];
                    double newy = coords[5];
                    if (cross.accumulateCubic(curx, cury, coords)) {
                        return null;
                    }
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
                        return null;
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        if (movy != cury && cross.accumulateLine(curx, cury, movx, movy)) {
            return null;
        }
        return cross;
    }

    public boolean accumulateLine(double x0, double y0, double x1, double y1) {
        switch (this.type) {
            case 0: {
                return this.crossings.accumulateLine(x0, y0, x1, y1);
            }
            case 2: {
                return this.evenOdd.accumulateLine(x0, y0, x1, y1);
            }
            case 1: {
                return this.nonZero.accumulateLine(x0, y0, x1, y1);
            }
        }
        return false;
    }

    public boolean accumulateLine2(double x0, double y0, double x1, double y1, int direction) {
        switch (this.type) {
            case 0: {
                return this.crossings.accumulateLine2(x0, y0, x1, y1, direction);
            }
            case 2: {
                return this.evenOdd.accumulateLine2(x0, y0, x1, y1, direction);
            }
            case 1: {
                return this.nonZero.accumulateLine2(x0, y0, x1, y1, direction);
            }
        }
        return false;
    }

    public boolean accumulateQuad(double x0, double y0, double[] coords) {
        if (y0 < this.ylo && coords[1] < this.ylo && coords[3] < this.ylo) {
            return false;
        }
        if (y0 > this.yhi && coords[1] > this.yhi && coords[3] > this.yhi) {
            return false;
        }
        if (x0 > this.xhi && coords[0] > this.xhi && coords[2] > this.xhi) {
            return false;
        }
        if (x0 < this.xlo && coords[0] < this.xlo && coords[2] < this.xlo) {
            if (y0 < coords[3]) {
                this.record(Math.max(y0, this.ylo), Math.min(coords[3], this.yhi), 1);
            } else if (y0 > coords[3]) {
                this.record(Math.max(coords[3], this.ylo), Math.min(y0, this.yhi), -1);
            }
            return false;
        }
        Curve.insertQuad(this.tmp, x0, y0, coords);
        Enumeration enum_ = this.tmp.elements();
        while (enum_.hasMoreElements()) {
            CurveObject c = (CurveObject)enum_.nextElement();
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public boolean accumulateCubic(double x0, double y0, double[] coords) {
        if (y0 < this.ylo && coords[1] < this.ylo && coords[3] < this.ylo && coords[5] < this.ylo) {
            return false;
        }
        if (y0 > this.yhi && coords[1] > this.yhi && coords[3] > this.yhi && coords[5] > this.yhi) {
            return false;
        }
        if (x0 > this.xhi && coords[0] > this.xhi && coords[2] > this.xhi && coords[4] > this.xhi) {
            return false;
        }
        if (x0 < this.xlo && coords[0] < this.xlo && coords[2] < this.xlo && coords[4] < this.xlo) {
            if (y0 <= coords[5]) {
                this.record(Math.max(y0, this.ylo), Math.min(coords[5], this.yhi), 1);
            } else {
                this.record(Math.max(coords[5], this.ylo), Math.min(y0, this.yhi), -1);
            }
            return false;
        }
        Curve.insertCubic(this.tmp, x0, y0, coords);
        Enumeration enum_ = this.tmp.elements();
        while (enum_.hasMoreElements()) {
            CurveObject c = (CurveObject)enum_.nextElement();
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }
}

