/*
 * Decompiled with CFR 0.152.
 */
package sec.sun.awt.geom;

import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Rectangle2D;
import sec.geo.ShapeObject;
import sec.sun.awt.geom.AreaIterator;
import sec.sun.awt.geom.AreaOp2;
import sec.sun.awt.geom.Curve;
import sec.sun.awt.geom.CurveObject;
import sec.sun.awt.geom.Enumeration;
import sec.sun.awt.geom.SomeOp;
import sec.sun.awt.geom.Vector;

public class Area {
    private static Vector EmptyCurves = new Vector();
    private static final boolean normalizeGeoPoints = true;
    private Vector curves;
    private Rectangle2D cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(ShapeObject s) {
        this.curves = Area.pathToCurves(s.getPathIterator(null));
    }

    private static Vector pathToCurves(PathIterator pi) {
        Vector curves = new Vector();
        int windingRule = pi.getWindingRule();
        double[] coords = new double[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (movx > 0.0) {
                        movx -= 360.0;
                    }
                    if (curx > 0.0) {
                        curx -= 360.0;
                    }
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx = coords[0];
                    cury = movy = coords[1];
                    if (movx > 0.0) {
                        movx -= 360.0;
                    }
                    Curve.insertMove(curves, movx, movy);
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    if (newx > 0.0) {
                        newx -= 360.0;
                    }
                    if (curx > 0.0) {
                        curx -= 360.0;
                    }
                    Curve.insertLine(curves, curx, cury, newx, newy);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    double newx = coords[2];
                    double newy = coords[3];
                    if (curx > 0.0) {
                        curx -= 360.0;
                    }
                    Curve.insertQuad(curves, curx, cury, coords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    double newx = coords[4];
                    double newy = coords[5];
                    if (curx > 0.0) {
                        curx -= 360.0;
                    }
                    Curve.insertCubic(curves, curx, cury, coords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    if (movx > 0.0) {
                        movx -= 360.0;
                    }
                    if (curx > 0.0) {
                        curx -= 360.0;
                    }
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        if (movx > 0.0) {
            movx -= 360.0;
        }
        if (curx > 0.0) {
            curx -= 360.0;
        }
        Curve.insertLine(curves, curx, cury, movx, movy);
        AreaOp2 operator2 = null;
        operator2 = windingRule == 0 ? new AreaOp2(0) : new AreaOp2(1);
        return operator2.calculate(curves, EmptyCurves);
    }

    public void add(Area rhs) {
        this.curves = new SomeOp(1).calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void subtract(Area rhs) {
        this.curves = new SomeOp(0).calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void intersect(Area rhs) {
        this.curves = new SomeOp(2).calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area rhs) {
        this.curves = new SomeOp(3).calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.isEmpty();
    }

    public boolean isPolygonal() {
        Enumeration enum_ = this.curves.elements();
        while (enum_.hasMoreElements()) {
            if (((CurveObject)enum_.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int size = this.curves.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        CurveObject c1 = (CurveObject)this.curves.get(1);
        CurveObject c2 = (CurveObject)this.curves.get(2);
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        if (c1.getXTop() != c1.getXBot() || c2.getXTop() != c2.getXBot()) {
            return false;
        }
        return c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enum_ = this.curves.elements();
        enum_.nextElement();
        while (enum_.hasMoreElements()) {
            if (((CurveObject)enum_.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    public boolean equals(Area other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Vector c = new SomeOp(3).calculate(this.curves, other.curves);
        return c.isEmpty();
    }

    public AreaIterator getPathIterator(AffineTransform at) {
        return new AreaIterator(this.curves, at);
    }
}

