/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.JavaLineArray.ref;
import armyc2.c2sd.JavaTacticalRenderer.mdlGeodesic;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.PathIterator;
import java.util.ArrayList;
import sec.geo.GeoEllipse;
import sec.geo.GeoPoint;
import sec.geo.ShapeObject;
import sec.geo.kml.KmlOptions;

public class Ellipse {
    protected GeoPoint pivot;
    protected double radiusMeters;
    private ShapeObject shape;
    protected double maxDistanceMeters;
    protected double flatnessDistanceMeters;
    protected KmlOptions.AltitudeMode altitudeMode;
    private double minAltitudeMeters;
    private double maxAltitudeMeters;
    protected int limit;
    private double _semiMajor = 0.0;
    private double _semiMinor = 0.0;
    private double _rotation = 0.0;

    public Ellipse(double semiMajor, double semiMinor, double rotation) {
        this._semiMajor = semiMajor;
        this._semiMinor = semiMinor;
        this._rotation = rotation;
        this.limit = 4;
        this.flatnessDistanceMeters = 2.0;
        this.maxDistanceMeters = 200000.0;
    }

    public ShapeObject createShape() {
        GeoEllipse e = new GeoEllipse(this.pivot, this._semiMajor * 2.0, this._semiMinor * 2.0, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        float[] coords = new float[2];
        int type = 0;
        POINT2 pt0 = new POINT2(this.pivot.x, this.pivot.y);
        POINT2 pt = null;
        POINT2 pt1 = null;
        double R2 = 0.0;
        ref<double[]> a12 = new ref<double[]>();
        ref<double[]> a21 = new ref<double[]>();
        double x = 0.0;
        double y = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double rotation = this._rotation;
        if ((rotation = 90.0 - rotation) == 0.0 || this._semiMajor == this._semiMinor) {
            return new ShapeObject(e);
        }
        ArrayList<POINT2> pts = new ArrayList<POINT2>();
        PathIterator i = e.getPathIterator(null);
        while (!i.isDone()) {
            type = i.currentSegment(coords);
            pt1 = new POINT2(coords[0], coords[1]);
            R2 = mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
            pt = mdlGeodesic.geodesic_coordinate(pt0, R2, ((double[])a12.value)[0] - rotation);
            pts.add(pt);
            i.next();
        }
        GeneralPath path = e.getPath();
        path.getPath().reset();
        for (int j = 0; j < pts.size(); ++j) {
            x = ((POINT2)pts.get((int)j)).x;
            y = ((POINT2)pts.get((int)j)).y;
            if (j == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        return new ShapeObject(e);
    }

    public ArrayList<GeoPoint> getEllipsePoints() {
        GeoEllipse e = new GeoEllipse(this.pivot, this._semiMajor * 2.0, this._semiMinor * 2.0, this.maxDistanceMeters, this.flatnessDistanceMeters, this.limit);
        float[] coords = new float[2];
        int type = 0;
        POINT2 pt0 = new POINT2(this.pivot.x, this.pivot.y);
        POINT2 pt = null;
        POINT2 pt1 = null;
        double R2 = 0.0;
        ref<double[]> a12 = new ref<double[]>();
        ref<double[]> a21 = new ref<double[]>();
        double x = 0.0;
        double y = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double rotation = this._rotation;
        rotation = 90.0 - rotation;
        ArrayList<GeoPoint> pts = new ArrayList<GeoPoint>();
        PathIterator i = e.getPathIterator(null);
        while (!i.isDone()) {
            type = i.currentSegment(coords);
            pt1 = new POINT2(coords[0], coords[1]);
            R2 = mdlGeodesic.geodesic_distance(pt0, pt1, a12, a21);
            pt = this._semiMajor != this._semiMinor ? mdlGeodesic.geodesic_coordinate(pt0, R2, ((double[])a12.value)[0] - rotation) : pt1;
            pts.add(new GeoPoint(pt.x, pt.y));
            i.next();
        }
        GeneralPath path = e.getPath();
        path.getPath().reset();
        for (int j = 0; j < pts.size(); ++j) {
            x = pts.get((int)j).x;
            y = pts.get((int)j).y;
            if (j == 0) {
                path.moveTo(x, y);
                continue;
            }
            path.lineTo(x, y);
        }
        return pts;
    }

    protected void shapeChanged() {
        this.shape = null;
    }

    public double getMinAltitude() {
        return this.minAltitudeMeters;
    }

    public void setMinAltitude(double minAltitudeMeters) {
        this.minAltitudeMeters = minAltitudeMeters;
        this.shapeChanged();
    }

    public double getMaxAltitude() {
        return this.maxAltitudeMeters;
    }

    public void setMaxAltitude(double maxAltitudeMeters) {
        this.maxAltitudeMeters = maxAltitudeMeters;
        this.shapeChanged();
    }

    public void setMaxDistance(double maxDistanceMeters) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.shapeChanged();
    }

    public void setFlatness(double flatnessDistanceMeters) {
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.shapeChanged();
    }

    public void setPivot(GeoPoint pvt) {
        this.pivot = pvt;
        this.shapeChanged();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }
}

