/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.shape;

import armyc2.c2sd.graphics2d.AffineTransform;
import java.util.ArrayList;
import sec.geo.GeoPoint;
import sec.geo.kml.KmlOptions;
import sec.geo.shape.Cake;
import sec.geo.shape.Circle;
import sec.geo.shape.Line;
import sec.geo.shape.Orbit;
import sec.geo.shape.Point;
import sec.geo.shape.Polyarc;
import sec.geo.shape.Polygon;
import sec.geo.shape.Radarc;
import sec.geo.shape.Route;
import sec.geo.shape.Track;

public class AExtObject {
    public static final int CAKE = 0;
    public static final int LINE = 1;
    public static final int ORBIT = 2;
    public static final int POINT = 3;
    public static final int CIRCLE = 4;
    public static final int RADARC = 5;
    public static final int POLYARC = 6;
    public static final int POLYGON = 7;
    public static final int ROUTE = 8;
    public static final int TRACK = 9;
    private int type = -1;
    private Orbit orbit = null;
    private Cake cake = null;
    private Circle circle = null;
    private Point point = null;
    private Radarc radarc = null;
    private Polyarc polyarc = null;
    private Polygon polygon = null;
    private Line line = null;
    private Route route = null;
    private Track track = null;

    public AExtObject(Object obj) {
        if (obj instanceof Integer) {
            this.type = (Integer)obj;
            switch (this.type) {
                case 1: {
                    this.line = new Line();
                    break;
                }
                case 2: {
                    this.orbit = new Orbit();
                    break;
                }
                case 8: {
                    this.route = new Route();
                    break;
                }
                case 9: {
                    this.track = new Track();
                    break;
                }
                case 5: {
                    this.radarc = new Radarc();
                    break;
                }
                case 0: {
                    this.cake = new Cake();
                    break;
                }
            }
        } else if (obj instanceof Line) {
            this.line = (Line)obj;
            this.type = 1;
        } else if (obj instanceof Route) {
            this.route = (Route)obj;
            this.type = 8;
        } else if (obj instanceof Polygon) {
            this.polygon = (Polygon)obj;
            this.type = 7;
        } else if (obj instanceof Radarc) {
            this.radarc = (Radarc)obj;
            this.type = 5;
        } else if (obj instanceof Polyarc) {
            this.polyarc = (Polyarc)obj;
            this.type = 6;
        } else if (obj instanceof Orbit) {
            this.orbit = (Orbit)obj;
            this.type = 2;
        } else if (obj instanceof Cake) {
            this.cake = (Cake)obj;
            this.type = 0;
        } else if (obj instanceof Circle) {
            this.circle = (Circle)obj;
            this.type = 4;
        } else if (obj instanceof Point) {
            this.point = (Point)obj;
            this.type = 3;
        } else if (obj instanceof Track) {
            this.track = (Track)obj;
            this.type = 9;
        }
    }

    public void setMaxDistance(double maxDistanceMeters) {
        switch (this.type) {
            case 2: {
                this.orbit.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 5: {
                this.radarc.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 6: {
                this.polyarc.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 7: {
                this.polygon.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 1: {
                this.line.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 4: {
                this.circle.setMaxDistance(maxDistanceMeters);
                break;
            }
            case 8: {
                this.route.setMaxDistance(maxDistanceMeters);
                break;
            }
        }
    }

    public void addPoint(GeoPoint point) {
        switch (this.type) {
            case 1: {
                this.line.addPoint(point);
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                this.orbit.addPoint(point);
                break;
            }
            case 6: {
                this.polyarc.addPoint(point);
                break;
            }
            case 7: {
                this.polygon.addPoint(point);
                break;
            }
            case 8: {
                this.route.addPoint(point);
                break;
            }
        }
    }

    public void setFlatness(double flatnessDistanceMeters) {
        switch (this.type) {
            case 1: {
                this.line.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 4: {
                this.circle.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 2: {
                this.orbit.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 5: {
                this.radarc.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 6: {
                this.polyarc.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 7: {
                this.polygon.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
            case 8: {
                this.route.flatnessDistanceMeters = flatnessDistanceMeters;
                break;
            }
        }
        this.shapeChanged();
    }

    public void setLimit(int limit) {
        switch (this.type) {
            case 1: {
                this.line.limit = limit;
                break;
            }
            case 4: {
                this.circle.limit = limit;
                break;
            }
            case 2: {
                this.orbit.limit = limit;
                break;
            }
            case 5: {
                this.radarc.limit = limit;
                break;
            }
            case 6: {
                this.polyarc.limit = limit;
                break;
            }
            case 7: {
                this.polygon.limit = limit;
                break;
            }
            case 8: {
                this.route.limit = limit;
                break;
            }
        }
        this.shapeChanged();
    }

    public double getMinAltitude() {
        switch (this.type) {
            case 1: {
                return this.line.getMinAltitude();
            }
            case 4: {
                return this.circle.getMinAltitude();
            }
            case 2: {
                return this.orbit.getMinAltitude();
            }
            case 6: {
                return this.polyarc.getMinAltitude();
            }
            case 7: {
                return this.polygon.getMinAltitude();
            }
            case 8: {
                return this.route.getMinAltitude();
            }
            case 5: {
                return this.radarc.getMinAltitude();
            }
        }
        return -1.0;
    }

    public double getMaxAltitude() {
        switch (this.type) {
            case 1: {
                return this.line.getMaxAltitude();
            }
            case 4: {
                return this.circle.getMaxAltitude();
            }
            case 2: {
                return this.orbit.getMaxAltitude();
            }
            case 6: {
                return this.polyarc.getMaxAltitude();
            }
            case 7: {
                return this.polygon.getMaxAltitude();
            }
            case 8: {
                return this.route.getMaxAltitude();
            }
            case 5: {
                return this.radarc.getMaxAltitude();
            }
        }
        return -1.0;
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        switch (this.type) {
            case 1: {
                return this.line.getAltitudeMode();
            }
            case 4: {
                return this.circle.getAltitudeMode();
            }
            case 2: {
                return this.orbit.getAltitudeMode();
            }
            case 6: {
                return this.polyarc.getAltitudeMode();
            }
            case 7: {
                return this.polygon.getAltitudeMode();
            }
            case 8: {
                return this.route.getAltitudeMode();
            }
            case 5: {
                return this.radarc.getAltitudeMode();
            }
        }
        return KmlOptions.AltitudeMode.ABSOLUTE;
    }

    public ArrayList getElements() {
        if (this.track != null) {
            return this.track.elements;
        }
        if (this.cake != null) {
            return this.cake.getElements();
        }
        return null;
    }

    public Object getPathIterator(AffineTransform at) {
        switch (this.type) {
            case 1: {
                return this.line.getShape().getPathIterator(at);
            }
            case 2: {
                return this.orbit.getShape().getPathIterator(at);
            }
            case 7: {
                return this.polygon.getShape().getPathIterator(at);
            }
            case 6: {
                return this.polyarc.getShape().getPathIterator(at);
            }
            case 4: {
                return this.circle.getShape().getPathIterator(at);
            }
            case 5: {
                return this.radarc.getShape().getPathIterator(at);
            }
            case 8: {
                return this.route.getShape().getPathIterator(at);
            }
        }
        return null;
    }

    private void shapeChanged() {
        switch (this.type) {
            case 7: {
                this.polygon.shapeChanged();
                break;
            }
            case 2: {
                this.orbit.shapeChanged();
                break;
            }
            case 8: {
                this.route.shapeChanged();
                break;
            }
            case 5: {
                this.radarc.shapeChanged();
                break;
            }
            case 6: {
                this.polyarc.shapeChanged();
                break;
            }
        }
    }
}

