/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.kml;

import armyc2.c2sd.graphics2d.PathIterator;
import java.util.ArrayList;
import sec.geo.kml.KmlPolygon;
import sec.geo.shape.AExtObject;
import sec.geo.shape.Cake;
import sec.geo.shape.Circle;
import sec.geo.shape.Line;
import sec.geo.shape.Orbit;
import sec.geo.shape.Point;
import sec.geo.shape.Polyarc;
import sec.geo.shape.Polygon;
import sec.geo.shape.Radarc;
import sec.geo.shape.Route;
import sec.geo.shape.Track;
import sec.geo.utilities.StringBuilder;
import sec.sun.awt.geom.AreaIterator;

public class KmlRenderer {
    private static final String EXCEPTION = "EXCEPTION:";
    private static final String colorDefault = "ff003fff";
    private static final String descriptionField = "#DESCRIPTION#";
    private static final String extendedData = "#EXTENDEDDATA#";
    private static final String colorField = "#COLOR#";
    private static final String nameField = "#NAME#";
    private static final String idField = "#ID#";
    private static final String placemarkidField = "#PLACEMARKID#";
    private static final String KML_START = "<Folder id=\"#ID#\">\n";
    private static final String KML_END = "</Folder>\n";
    private static final String PLACEMARK_START = "\t\t<Placemark id=\"#PLACEMARKID#\">\n                      <Style>\n                          <PolyStyle>\n                              <color>#COLOR#</color>\n                          </PolyStyle>\n                          <LineStyle>\n                              <color>#COLOR#</color>\n                          </LineStyle>\n                       </Style>\n\t\t\t<name>#NAME#</name>\n\t\t\t<description>#DESCRIPTION#</description>\n\t\t\t<ExtendedData>#EXTENDEDDATA#</ExtendedData>\n\t\t\t<MultiGeometry>\n";
    private static final String PLACEMARK_END = "\t\t\t</MultiGeometry>\n\t\t</Placemark>\n";

    public ArrayList<KmlPolygon> renderPolygons(AExtObject ext) {
        ArrayList<KmlPolygon> polys = new ArrayList<KmlPolygon>();
        ext.setMaxDistance(200000.0);
        ext.setFlatness(2.0);
        ext.setLimit(8);
        ArrayList<Point> perimeterPoints = new ArrayList<Point>();
        PathIterator it = null;
        AreaIterator ait = null;
        Object oit = ext.getPathIterator(null);
        if (oit instanceof PathIterator) {
            it = (PathIterator)oit;
        } else if (oit instanceof AreaIterator) {
            ait = (AreaIterator)oit;
        }
        Point pre = null;
        if (it != null) {
            while (!it.isDone()) {
                double[] strokePoints = new double[6];
                int type = it.currentSegment(strokePoints);
                double longitudeDegrees = strokePoints[0];
                double latitudeDegrees = strokePoints[1];
                if (longitudeDegrees < -180.0) {
                    longitudeDegrees += 360.0;
                }
                switch (type) {
                    case 0: 
                    case 1: {
                        if (pre != null) {
                            ArrayList<Point> ps = new ArrayList<Point>();
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMaxAltitude()));
                            ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMaxAltitude()));
                            ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMinAltitude()));
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                            polys.add(new KmlPolygon(ps, ext.getAltitudeMode()));
                        }
                        pre = new Point(longitudeDegrees, latitudeDegrees);
                        perimeterPoints.add(pre);
                    }
                }
                it.next();
            }
        } else if (ait != null) {
            while (!ait.isDone()) {
                double[] strokePoints = new double[6];
                int type = ait.currentSegment(strokePoints);
                double longitudeDegrees = strokePoints[0];
                double latitudeDegrees = strokePoints[1];
                if (longitudeDegrees < -180.0) {
                    longitudeDegrees += 360.0;
                }
                switch (type) {
                    case 0: 
                    case 1: {
                        if (pre != null) {
                            ArrayList<Point> ps = new ArrayList<Point>();
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMaxAltitude()));
                            ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMaxAltitude()));
                            ps.add(new Point(longitudeDegrees, latitudeDegrees, ext.getMinAltitude()));
                            ps.add(new Point(pre.getLongitude(), pre.getLatitude(), ext.getMinAltitude()));
                            polys.add(new KmlPolygon(ps, ext.getAltitudeMode()));
                        }
                        pre = new Point(longitudeDegrees, latitudeDegrees);
                        perimeterPoints.add(pre);
                    }
                }
                ait.next();
            }
        }
        if (perimeterPoints.size() > 0) {
            if (((Point)perimeterPoints.get(0)).equals(perimeterPoints.get(perimeterPoints.size() - 1))) {
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMinAltitude()), ext.getAltitudeMode()));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMaxAltitude()), ext.getAltitudeMode()));
            } else {
                perimeterPoints.add((Point)perimeterPoints.get(0));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMinAltitude()), ext.getAltitudeMode()));
                polys.add(new KmlPolygon(this.transformPoints(perimeterPoints, ext.getMaxAltitude()), ext.getAltitudeMode()));
            }
        }
        return polys;
    }

    public String getPlacemarkKml(AExtObject ext, String id, String name, String description, String lineColor, String fillColor) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<KmlPolygon> polys = this.renderPolygons(ext);
            sb.append(PLACEMARK_START);
            int placemarkIdIndex = sb.indexOf(placemarkidField);
            int placemarkIdLength = placemarkidField.length();
            if (id != null) {
                sb.replace(placemarkIdIndex, placemarkIdIndex + placemarkIdLength, id + "_mg");
            }
            int descriptionIndex = sb.indexOf(descriptionField);
            int descriptionLength = descriptionField.length();
            if (description != null) {
                sb.replace(descriptionIndex, descriptionIndex + descriptionLength, description);
            }
            int colorIndex = sb.indexOf(colorField);
            int colorLength = colorField.length();
            if (fillColor != null) {
                sb.replace(colorIndex, colorIndex + colorLength, fillColor);
            } else {
                sb.replace(colorIndex, colorIndex + colorLength, colorDefault);
            }
            int lineColorIndex = sb.indexOf2(colorField, colorIndex + colorLength);
            if (lineColor != null) {
                sb.replace(lineColorIndex, lineColorIndex + colorLength, lineColor);
            } else {
                sb.replace(lineColorIndex, lineColorIndex + colorLength, colorDefault);
            }
            int nameIndex = sb.indexOf(nameField);
            int nameLength = nameField.length();
            if (name != null) {
                sb.replace(nameIndex, nameIndex + nameLength, name);
            }
            for (KmlPolygon poly : polys) {
                sb.append(poly.toString());
            }
            sb.append(PLACEMARK_END);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EXCEPTION + e.getMessage();
        }
    }

    public String getKml(Object ext, String id, String name, String description, String lineColor, String fillColor) {
        try {
            AExtObject aext = this.getAExtObject(ext);
            if (aext.getElements() != null) {
                return this.getTrackKml(ext, id, name, description, lineColor, fillColor);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(KML_START);
            int idIndex = sb.indexOf(idField);
            int idLength = idField.length();
            sb.replace(idIndex, idIndex + idLength, id);
            sb.append(this.getPlacemarkKml(aext, id, name, description, lineColor, fillColor));
            sb.append(KML_END);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EXCEPTION + e.getMessage();
        }
    }

    public String getTrackKml(Object ext, String id, String name, String description, String lineColor, String fillColor) {
        try {
            AExtObject aext = this.getAExtObject(ext);
            StringBuilder sb = new StringBuilder();
            sb.append(KML_START);
            int idIndex = sb.indexOf(idField);
            int idLength = idField.length();
            sb.replace(idIndex, idIndex + idLength, id);
            ArrayList elements = aext.getElements();
            int j = 0;
            int n = elements.size();
            for (j = 0; j < n; ++j) {
                Route route = (Route)elements.get(j);
                AExtObject aext2 = new AExtObject(route);
                sb.append(this.getPlacemarkKml(aext2, id, name, description, lineColor, fillColor));
            }
            sb.append(KML_END);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return EXCEPTION + e.getMessage();
        }
    }

    public String getCakeKml(Cake com, String id, String name, String description, String lineColor, String fillColor) {
        StringBuilder sb = new StringBuilder();
        sb.append(KML_START);
        int idIndex = sb.indexOf(idField);
        int idLength = idField.length();
        sb.replace(idIndex, idIndex + idLength, id);
        for (Object ext : com.getElements()) {
            AExtObject aext = new AExtObject(ext);
            String extStr = this.getPlacemarkKml(aext, id, name, description, lineColor, fillColor);
            if (extStr.startsWith(EXCEPTION)) continue;
            sb.append(extStr);
        }
        sb.append(KML_END);
        return sb.toString();
    }

    private AExtObject getAExtObject(Object obj) {
        Line line = null;
        Route route = null;
        Circle circle = null;
        Polyarc polyarc = null;
        Polygon polygon = null;
        Orbit orbit = null;
        Radarc radarc = null;
        Track track = null;
        Cake cake = null;
        Point point = null;
        AExtObject ext = null;
        if (obj instanceof Line) {
            line = (Line)obj;
            ext = new AExtObject(line);
        } else if (obj instanceof Route) {
            route = (Route)obj;
            ext = new AExtObject(route);
        } else if (obj instanceof Polyarc) {
            polyarc = (Polyarc)obj;
            ext = new AExtObject(polyarc);
        } else if (obj instanceof Orbit) {
            orbit = (Orbit)obj;
            ext = new AExtObject(orbit);
        } else if (obj instanceof Polygon) {
            polygon = (Polygon)obj;
            ext = new AExtObject(polygon);
        } else if (obj instanceof Circle) {
            circle = (Circle)obj;
            ext = new AExtObject(circle);
        } else if (obj instanceof Radarc) {
            radarc = (Radarc)obj;
            ext = new AExtObject(radarc);
        } else if (obj instanceof Track) {
            track = (Track)obj;
            ext = new AExtObject(track);
        } else if (obj instanceof Cake) {
            cake = (Cake)obj;
            ext = new AExtObject(cake);
        } else if (obj instanceof Point) {
            point = (Point)obj;
            ext = new AExtObject(point);
        }
        return ext;
    }

    public String[] getCoords(Object obj) {
        AExtObject ext = this.getAExtObject(obj);
        ArrayList<KmlPolygon> polys = this.renderPolygons(ext);
        String[] coords = new String[polys.size()];
        int i = 0;
        for (KmlPolygon poly : polys) {
            coords[i] = poly.toCoordString();
            ++i;
        }
        return coords;
    }

    private ArrayList<Point> transformPoints(ArrayList<Point> points, double altitudeMeters) {
        ArrayList<Point> returnPoints = new ArrayList<Point>();
        for (Point p : points) {
            returnPoints.add(new Point(p.getLongitude(), p.getLatitude(), altitudeMeters));
        }
        return returnPoints;
    }
}

