/*
 * Decompiled with CFR 0.152.
 */
package sec.geo.kml;

import java.util.ArrayList;
import org.gavaghan.geodesy.Ellipsoid;
import sec.geo.kml.KmlOptions;
import sec.geo.shape.Point;
import sec.geo.utilities.StringBuilder;

public class KmlPolygon {
    private final ArrayList<Point> points;
    private KmlOptions.AltitudeMode altitudeMode = KmlOptions.AltitudeMode.ABSOLUTE;
    protected static final Ellipsoid REFERENCE_ELLIPSOID = Ellipsoid.WGS84;
    private static final String altitudeModeField = "#ALTITUDEMODE#";
    private static final String PREFIX = "\t\t\t\t<Polygon>\n\t\t\t\t\t<tessellate>1</tessellate>\n\t\t\t\t\t<altitudeMode>#ALTITUDEMODE#</altitudeMode>\n\t\t\t\t\t<outerBoundaryIs><LinearRing><coordinates>";
    private static final String SUFFIX = "\t\t\t\t\t</coordinates></LinearRing></outerBoundaryIs>\n\t\t\t\t</Polygon>\n";

    public KmlPolygon() {
        this.points = new ArrayList();
    }

    public KmlPolygon(ArrayList<Point> points, KmlOptions.AltitudeMode altitudeMode) {
        this();
        this.points.addAll(points);
        this.altitudeMode = altitudeMode;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public void addPoints(ArrayList<Point> points) {
        this.points.addAll(points);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX);
        sb.append(this.toCoordString());
        sb.append(SUFFIX);
        int altitudeModeIndex = sb.indexOf(altitudeModeField);
        int altitudeModeLength = altitudeModeField.length();
        if (this.altitudeMode != null) {
            sb.replace(altitudeModeIndex, altitudeModeIndex + altitudeModeLength, this.altitudeMode.toString());
        }
        return sb.toString();
    }

    public String toCoordString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Point> orderedPoints = this.getPointsCounterClockwise();
        if (orderedPoints == null) {
            return "";
        }
        for (Point point : orderedPoints) {
            sb.append(point.getLongitude());
            sb.append(",");
            sb.append(point.getLatitude());
            sb.append(",");
            sb.append(point.getAltitude());
            sb.append(" ");
        }
        Point point = orderedPoints.get(0);
        if (!point.equals(orderedPoints.get(orderedPoints.size() - 1))) {
            sb.append(point.getLongitude());
            sb.append(",");
            sb.append(point.getLatitude());
            sb.append(",");
            sb.append(point.getAltitude());
            sb.append(" ");
        }
        return sb.toString();
    }

    public KmlOptions.AltitudeMode getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(KmlOptions.AltitudeMode altitudeMode) {
        this.altitudeMode = altitudeMode;
    }

    public ArrayList<Point> getPointsClockwise() {
        if (this.points == null || this.points.size() < 3) {
            return null;
        }
        ArrayList result = this.subList(this.points, 0, this.points.size() - 1);
        int order = this.getPointOrder();
        if (order < 0) {
            result = this.reverse(result);
            return result;
        }
        return result;
    }

    public ArrayList<Point> getPointsCounterClockwise() {
        if (this.points == null || this.points.size() < 3) {
            return null;
        }
        ArrayList result = this.subList(this.points, 0, this.points.size() - 1);
        int order = this.getPointOrder();
        if (order > 0) {
            result = this.reverse(result);
            return result;
        }
        return result;
    }

    public int getPointOrder() {
        if (this.points == null || this.points.size() < 3) {
            return 0;
        }
        int n = this.points.size();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n;
            int k = (i + 2) % n;
            double z = (this.points.get(j).getLongitude() - this.points.get(i).getLongitude()) * (this.points.get(k).getLatitude() - this.points.get(i).getLatitude());
            if ((z -= (this.points.get(j).getLatitude() - this.points.get(i).getLatitude()) * (this.points.get(k).getLongitude() - this.points.get(i).getLongitude())) < 0.0) {
                --count;
                continue;
            }
            if (!(z > 0.0)) continue;
            ++count;
        }
        if (count > 0) {
            return -1;
        }
        if (count < 0) {
            return 1;
        }
        return 0;
    }

    private ArrayList subList(ArrayList al, int fromIndex, int toIndex) {
        ArrayList result = new ArrayList();
        int j = 0;
        for (j = fromIndex; j < toIndex; ++j) {
            result.add(al.get(j));
        }
        return result;
    }

    private ArrayList reverse(ArrayList al) {
        int j = 0;
        ArrayList result = new ArrayList();
        int n = al.size();
        for (j = n - 1; j >= 0; --j) {
            result.add(al.get(j));
        }
        return result;
    }
}

