/*
 * Decompiled with CFR 0.152.
 */
package sec.geo;

import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.Area;
import armyc2.c2sd.graphics2d.PathIterator;
import org.gavaghan.geodesy.GeodeticCalculator;
import sec.geo.GeoArc;
import sec.geo.GeoBlock;
import sec.geo.GeoBlock2;
import sec.geo.GeoEllipse;
import sec.geo.GeoPath;
import sec.geo.GeoPoint;

public class ShapeObject {
    public static final int GEOARC = 0;
    public static final int GEOBLOCK = 1;
    public static final int GEOBLOCK2 = 2;
    public static final int GEOELLIPSE = 3;
    public static final int GEOPATH = 4;
    public static final int GEOPOINT = 5;
    public static final int AREA = 6;
    private int type = -1;
    private GeoEllipse geoEllipse = null;
    private GeoPath geoPath = null;
    private GeoArc geoArc = null;
    private GeoBlock geoBlock = null;
    private GeoBlock2 geoBlock2 = null;
    private GeoPoint geoPoint = null;
    private Area area = null;
    protected final GeodeticCalculator geoCalc = null;

    public ShapeObject(Object obj) {
        if (obj instanceof GeoArc) {
            this.geoArc = (GeoArc)obj;
            this.type = 0;
        } else if (obj instanceof GeoPath) {
            this.geoPath = (GeoPath)obj;
            this.type = 4;
        } else if (obj instanceof GeoEllipse) {
            this.geoEllipse = (GeoEllipse)obj;
            this.type = 3;
        } else if (obj instanceof GeoBlock) {
            this.geoBlock = (GeoBlock)obj;
            this.type = 1;
        } else if (obj instanceof GeoBlock2) {
            this.geoBlock2 = (GeoBlock2)obj;
            this.type = 2;
        } else if (obj instanceof GeoPoint) {
            this.geoPoint = (GeoPoint)obj;
            this.type = 5;
        } else if (obj instanceof Area) {
            this.area = (Area)obj;
            this.type = 6;
        }
    }

    public void arcTo(GeoPoint pivot, double widthMeters, double heightMeters, double leftAzimuthDegrees, double rightAzimuthDegrees) {
        switch (this.type) {
            case 3: {
                this.geoEllipse.arcTo(pivot, widthMeters, heightMeters, leftAzimuthDegrees, rightAzimuthDegrees);
                break;
            }
            case 0: {
                this.geoArc.arcTo(pivot, widthMeters, heightMeters, leftAzimuthDegrees, rightAzimuthDegrees);
                break;
            }
            case 4: {
                this.geoPath.arcTo(pivot, widthMeters, heightMeters, leftAzimuthDegrees, rightAzimuthDegrees);
                break;
            }
        }
    }

    public PathIterator getPathIterator(AffineTransform at) {
        switch (this.type) {
            case 3: {
                return this.geoEllipse.getPathIterator(at);
            }
            case 4: {
                return this.geoPath.getPathIterator(at);
            }
            case 1: {
                return this.geoBlock.getPathIterator(at);
            }
            case 2: {
                return this.geoBlock2.getPathIterator(at, 0.0);
            }
            case 0: {
                return this.geoArc.getPathIterator(at);
            }
        }
        return null;
    }

    public void moveTo(GeoPoint point) {
        switch (this.type) {
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 0: {
                this.geoArc.moveTo(point);
                break;
            }
            case 4: {
                this.geoPath.moveTo(point);
                break;
            }
            case 1: {
                this.geoBlock.moveTo(point);
                break;
            }
            case 2: {
                this.geoBlock2.moveTo(point);
                break;
            }
        }
    }

    public void moveToLatLong(double longitudeDegrees, double latitudeDegrees) {
        switch (this.type) {
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 0: {
                this.geoArc.moveToLatLong(longitudeDegrees, latitudeDegrees);
                break;
            }
            case 4: {
                this.geoPath.moveToLatLong(longitudeDegrees, latitudeDegrees);
                break;
            }
            case 1: {
                this.geoBlock.moveToLatLong(longitudeDegrees, latitudeDegrees);
                break;
            }
            case 2: {
                this.geoBlock2.moveToLatLong(longitudeDegrees, latitudeDegrees);
                break;
            }
        }
    }

    public void lineTo(GeoPoint point) {
        switch (this.type) {
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 0: {
                this.geoArc.lineTo(point);
                break;
            }
            case 4: {
                this.geoPath.lineTo(point);
                break;
            }
            case 1: {
                this.geoBlock.lineTo(point);
                break;
            }
            case 2: {
                this.geoBlock2.lineTo(point);
                break;
            }
        }
    }

    public void lineToLatLong(double longitudeDegrees, double latitudeDegrees) {
        this.lineTo(new GeoPoint(longitudeDegrees, latitudeDegrees));
    }

    public void closePath() {
        switch (this.type) {
            case 0: {
                this.geoArc.closePath();
                break;
            }
            case 1: {
                this.geoBlock.closePath();
                break;
            }
            case 2: {
                this.geoBlock2.closePath();
                break;
            }
            case 4: {
                this.geoPath.closePath();
                break;
            }
        }
    }
}

