/*
 * Decompiled with CFR 0.152.
 */
package sec.geo;

import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.Arc2D;
import armyc2.c2sd.graphics2d.FlatteningPathIterator;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.PathIterator;
import armyc2.c2sd.graphics2d.Point2D;
import java.util.ArrayList;
import org.gavaghan.geodesy.Angle;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import sec.geo.GeoPoint;

public class GeoEllipse {
    protected static final Ellipsoid REFERENCE_ELLIPSOID = Ellipsoid.WGS84;
    private GeneralPath path = new GeneralPath();
    private ArrayList<GeoPoint> toPoints = new ArrayList();
    private double maxDistanceMeters;
    private double flatnessDistanceMeters;
    private int limit;
    protected final GeodeticCalculator geoCalc = new GeodeticCalculator();

    public GeoEllipse(GeoPoint pivot, double widthMeters, double heightMeters, double maxDistanceMeters, double flatnessDistanceMeters, int limit) {
        this.maxDistanceMeters = maxDistanceMeters;
        this.flatnessDistanceMeters = flatnessDistanceMeters;
        this.limit = limit;
        this.arcTo(pivot, widthMeters, heightMeters, 0.0, 180.0);
        this.arcTo(pivot, widthMeters, heightMeters, 180.0, 0.0);
    }

    public final void arcTo(GeoPoint pivot, double widthMeters, double heightMeters, double leftAzimuthDegrees, double rightAzimuthDegrees) {
        GeneralPath newPath = new GeneralPath();
        Arc2D arc = leftAzimuthDegrees > rightAzimuthDegrees ? new Arc2D(-widthMeters / 2.0, -heightMeters / 2.0, widthMeters, heightMeters, leftAzimuthDegrees - 90.0, Math.abs(360.0 - leftAzimuthDegrees + rightAzimuthDegrees), 0) : new Arc2D(-widthMeters / 2.0, -heightMeters / 2.0, widthMeters, heightMeters, leftAzimuthDegrees - 90.0, Math.abs(leftAzimuthDegrees - rightAzimuthDegrees), 0);
        GeoPoint point = null;
        if (pivot != null) {
            FlatteningPathIterator it = new FlatteningPathIterator(arc.getPathIterator(null), this.flatnessDistanceMeters, this.limit);
            while (!it.isDone()) {
                double[] strokePoints = new double[6];
                int type = it.currentSegment(strokePoints);
                double x = strokePoints[0];
                double y = strokePoints[1];
                double azimuth = Angle.toDegrees(Math.atan2(x, y));
                GlobalCoordinates coord = new GlobalCoordinates(pivot.getLatitude(), pivot.getLongitude());
                GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, coord, azimuth, Point2D.distance(0.0, 0.0, x, y));
                switch (type) {
                    case 0: {
                        newPath.moveTo(c.getLongitude(), c.getLatitude());
                        GeoPoint startPoint = new GeoPoint(c.getLongitude(), c.getLatitude());
                        if (this.toPoints.size() <= 0 || startPoint.equals(this.toPoints.get(this.toPoints.size() - 1))) break;
                        this.lineTo(startPoint);
                        break;
                    }
                    case 1: {
                        newPath.lineTo(c.getLongitude(), c.getLatitude());
                        point = new GeoPoint(c.getLongitude(), c.getLatitude());
                    }
                }
                it.next();
            }
        }
        this.path.append(newPath, true);
        this.toPoints.add(point);
    }

    public void lineTo(GeoPoint point) {
        GeneralPath newPath = new GeneralPath();
        GeoPoint lastPoint = new GeoPoint();
        if (this.toPoints.size() > 0) {
            lastPoint = this.toPoints.get(this.toPoints.size() - 1);
            newPath.moveTo(lastPoint.x, lastPoint.y);
        }
        GlobalCoordinates start = this.toGlobalCoord(lastPoint);
        GlobalCoordinates end = this.toGlobalCoord(point);
        GeodeticCurve curve = this.geoCalc.calculateGeodeticCurve(REFERENCE_ELLIPSOID, start, end);
        for (double distance = this.maxDistanceMeters; distance < curve.getEllipsoidalDistance(); distance += this.maxDistanceMeters) {
            GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, start, curve.getAzimuth(), distance);
            newPath.lineTo(c.getLongitude(), c.getLatitude());
        }
        newPath.lineTo(point.x, point.y);
        this.path.append(newPath, true);
        this.toPoints.add(point);
    }

    protected GlobalCoordinates toGlobalCoord(GeoPoint point) {
        return new GlobalCoordinates(point.getLatitude(), point.getLongitude());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    public GeneralPath getPath() {
        return this.path;
    }
}

