/*
 * Decompiled with CFR 0.152.
 */
package sec.geo;

import armyc2.c2sd.JavaLineArray.POINT2;
import armyc2.c2sd.graphics2d.AffineTransform;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.PathIterator;
import java.util.ArrayList;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import sec.geo.GeoPoint;

public class GeoBlock2 {
    protected static final Ellipsoid REFERENCE_ELLIPSOID = Ellipsoid.WGS84;
    private GeneralPath path = new GeneralPath();
    private ArrayList<GeoPoint> toPoints = new ArrayList();
    private double maxDistanceMeters;
    private double flatnessDistanceMeters;
    private int limit;
    protected final GeodeticCalculator geoCalc = new GeodeticCalculator();

    public GeoBlock2(GeoPoint p1, GeoPoint p2, double leftWidthMeters, double rightWidthMeters, double maxDistanceMeters, double flatnessDistanceMeters, int limit) {
        this.maxDistanceMeters = maxDistanceMeters;
        GlobalCoordinates c1 = this.toGlobalCoord(p1);
        GlobalCoordinates c2 = this.toGlobalCoord(p2);
        GeodeticCurve curve = this.geoCalc.calculateGeodeticCurve(REFERENCE_ELLIPSOID, c1, c2);
        double a1 = curve.getAzimuth();
        double a2 = curve.getReverseAzimuth();
        double leftRadius = leftWidthMeters;
        double rightRadius = rightWidthMeters;
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c1, a1 - 90.0, leftRadius);
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c1, a1 - 90.0, leftRadius);
        this.moveToLatLong(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c2, a2 + 90.0, leftRadius);
        this.lineToLatLong(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c2, a2 - 90.0, rightRadius);
        this.lineToLatLong(c.getLongitude(), c.getLatitude());
        c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, c1, a1 + 90.0, rightRadius);
        this.lineToLatLong(c.getLongitude(), c.getLatitude());
        this.closePath();
    }

    public void moveTo(GeoPoint point) {
        this.path.moveTo(point.x, point.y);
        this.toPoints.add(point);
    }

    public final void moveToLatLong(double longitudeDegrees, double latitudeDegrees) {
        this.moveTo(new GeoPoint(longitudeDegrees, latitudeDegrees));
    }

    public void lineTo(GeoPoint point) {
        GeneralPath newPath = new GeneralPath();
        GeoPoint lastPoint = new GeoPoint();
        if (this.toPoints.size() > 0) {
            lastPoint = this.toPoints.get(this.toPoints.size() - 1);
            newPath.moveTo(lastPoint.x, lastPoint.y);
        }
        GlobalCoordinates start = this.toGlobalCoord(lastPoint);
        GlobalCoordinates end = this.toGlobalCoord(point);
        GeodeticCurve curve = this.geoCalc.calculateGeodeticCurve(REFERENCE_ELLIPSOID, start, end);
        for (double distance = this.maxDistanceMeters; distance < curve.getEllipsoidalDistance(); distance += this.maxDistanceMeters) {
            GlobalCoordinates c = this.geoCalc.calculateEndingGlobalCoordinates(REFERENCE_ELLIPSOID, start, curve.getAzimuth(), distance);
            newPath.lineTo(c.getLongitude(), c.getLatitude());
        }
        newPath.lineTo(point.x, point.y);
        this.path.append(newPath, true);
        this.toPoints.add(point);
        this.simplify();
    }

    public final void lineToLatLong(double longitudeDegrees, double latitudeDegrees) {
        this.lineTo(new GeoPoint(longitudeDegrees, latitudeDegrees));
    }

    public ArrayList<GeoPoint> getToPoints() {
        return this.toPoints;
    }

    public final void closePath() {
        if (this.toPoints.size() > 0 && !this.toPoints.get(0).equals(this.toPoints.get(this.toPoints.size() - 1))) {
            this.lineTo(this.toPoints.get(0));
        }
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at);
    }

    public String toString() {
        return this.toPoints.toString();
    }

    protected final GlobalCoordinates toGlobalCoord(GeoPoint point) {
        return new GlobalCoordinates(point.getLatitude(), point.getLongitude());
    }

    public void simplify() {
        PathIterator pi = this.path.getPathIterator(null);
        ArrayList<POINT2> pts = pi.getPoints();
        ArrayList<POINT2> newPts = new ArrayList<POINT2>();
        int j = 0;
        int style = -1;
        int lastStyle = -1;
        int nextstyle = -1;
        POINT2 currentPt = null;
        POINT2 lastPt = null;
        int n = pts.size();
        for (j = 0; j < n; ++j) {
            style = pts.get((int)j).style;
            currentPt = pts.get(j);
            if (j > 0) {
                lastStyle = pts.get((int)(j - 1)).style;
                lastPt = pts.get(j - 1);
            }
            if (lastStyle == 1 && style == 0 && currentPt.x == lastPt.x && currentPt.y == lastPt.y) continue;
            newPts.add(currentPt);
        }
        pi.setPathIterator(newPts);
    }
}

