/*
 * Decompiled with CFR 0.152.
 */
package org.gavaghan.geodesy;

import org.gavaghan.geodesy.GlobalCoordinates;

public class GlobalPosition {
    private double mElevation;
    private double mLatitude;
    private double mLongitude;

    public GlobalPosition(double latitude, double longitude, double elevation) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.canonicalize();
        this.mElevation = elevation;
    }

    public GlobalPosition(GlobalCoordinates coords, double elevation) {
        this(coords.getLatitude(), coords.getLongitude(), elevation);
    }

    public double getElevation() {
        return this.mElevation;
    }

    public void setElevation(double elevation) {
        this.mElevation = elevation;
    }

    public int compareTo(GlobalPosition other) {
        int retval = this.mLongitude < other.mLongitude ? -1 : (this.mLongitude > other.mLongitude ? 1 : (this.mLatitude < other.mLatitude ? -1 : (this.mLatitude > other.mLatitude ? 1 : 0)));
        if (retval == 0) {
            if (this.mElevation < other.mElevation) {
                retval = -1;
            } else if (this.mElevation > other.mElevation) {
                retval = 1;
            }
        }
        return retval;
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.mElevation != 0.0) {
            hash *= (int)this.mElevation;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalPosition)) {
            return false;
        }
        GlobalPosition other = (GlobalPosition)obj;
        return this.mElevation == other.mElevation && super.equals(other);
    }

    public String toString() {
        String buffer = "";
        buffer = buffer + Math.abs(this.mLatitude);
        buffer = buffer + (this.mLatitude >= 0.0 ? (char)'N' : 'S');
        buffer = buffer + ';';
        buffer = buffer + Math.abs(this.mLongitude);
        buffer = buffer + (this.mLongitude >= 0.0 ? (char)'E' : 'W');
        buffer = buffer + ';';
        buffer = buffer + "elevation=";
        buffer = buffer + Double.toString(this.mElevation);
        buffer = buffer + "m";
        return buffer;
    }

    private void canonicalize() {
        this.mLatitude = (this.mLatitude + 180.0) % 360.0;
        if (this.mLatitude < 0.0) {
            this.mLatitude += 360.0;
        }
        this.mLatitude -= 180.0;
        if (this.mLatitude > 90.0) {
            this.mLatitude = 180.0 - this.mLatitude;
            this.mLongitude += 180.0;
        } else if (this.mLatitude < -90.0) {
            this.mLatitude = -180.0 - this.mLatitude;
            this.mLongitude += 180.0;
        }
        this.mLongitude = (this.mLongitude + 180.0) % 360.0;
        if (this.mLongitude <= 0.0) {
            this.mLongitude += 360.0;
        }
        this.mLongitude -= 180.0;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }
}

