/*
 * Decompiled with CFR 0.152.
 */
package org.gavaghan.geodesy;

public class GlobalCoordinates {
    private double mLatitude;
    private double mLongitude;

    private void canonicalize() {
        this.mLatitude = (this.mLatitude + 180.0) % 360.0;
        if (this.mLatitude < 0.0) {
            this.mLatitude += 360.0;
        }
        this.mLatitude -= 180.0;
        if (this.mLatitude > 90.0) {
            this.mLatitude = 180.0 - this.mLatitude;
            this.mLongitude += 180.0;
        } else if (this.mLatitude < -90.0) {
            this.mLatitude = -180.0 - this.mLatitude;
            this.mLongitude += 180.0;
        }
        this.mLongitude = (this.mLongitude + 180.0) % 360.0;
        if (this.mLongitude <= 0.0) {
            this.mLongitude += 360.0;
        }
        this.mLongitude -= 180.0;
    }

    public GlobalCoordinates(double latitude, double longitude) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.canonicalize();
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double latitude) {
        this.mLatitude = latitude;
        this.canonicalize();
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double longitude) {
        this.mLongitude = longitude;
        this.canonicalize();
    }

    public int compareTo(GlobalCoordinates other) {
        int retval = this.mLongitude < other.mLongitude ? -1 : (this.mLongitude > other.mLongitude ? 1 : (this.mLatitude < other.mLatitude ? -1 : (this.mLatitude > other.mLatitude ? 1 : 0)));
        return retval;
    }

    public int hashCode() {
        return (int)(this.mLongitude * this.mLatitude * 1000000.0 + 1021.0) * 1000033;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalCoordinates)) {
            return false;
        }
        GlobalCoordinates other = (GlobalCoordinates)obj;
        return this.mLongitude == other.mLongitude && this.mLatitude == other.mLatitude;
    }

    public String toString() {
        String buffer = "";
        buffer = buffer + Math.abs(this.mLatitude);
        buffer = buffer + (this.mLatitude >= 0.0 ? (char)'N' : 'S');
        buffer = buffer + ';';
        buffer = buffer + Math.abs(this.mLongitude);
        buffer = buffer + (this.mLongitude >= 0.0 ? (char)'E' : 'W');
        buffer = buffer + ';';
        return buffer;
    }
}

