/*
 * Decompiled with CFR 0.152.
 */
package org.gavaghan.geodesy;

import org.gavaghan.geodesy.GeodeticCurve;

public class GeodeticMeasurement {
    private final double mElevationChange;
    private final double mP2P;
    private final double mEllipsoidalDistance;
    private final double mAzimuth;
    private final double mReverseAzimuth;

    public GeodeticMeasurement(double ellipsoidalDistance, double azimuth, double reverseAzimuth, double elevationChange) {
        this.mEllipsoidalDistance = ellipsoidalDistance;
        this.mAzimuth = azimuth;
        this.mReverseAzimuth = reverseAzimuth;
        this.mElevationChange = elevationChange;
        this.mP2P = Math.sqrt(ellipsoidalDistance * ellipsoidalDistance + this.mElevationChange * this.mElevationChange);
    }

    public GeodeticMeasurement(GeodeticCurve averageCurve, double elevationChange) {
        this(averageCurve.getEllipsoidalDistance(), averageCurve.getAzimuth(), averageCurve.getReverseAzimuth(), elevationChange);
    }

    public double getElevationChange() {
        return this.mElevationChange;
    }

    public double getPointToPointDistance() {
        return this.mP2P;
    }

    public String toString() {
        String buffer = "";
        buffer = buffer + "s=";
        buffer = buffer + this.mEllipsoidalDistance;
        buffer = buffer + ";a12=";
        buffer = buffer + this.mAzimuth;
        buffer = buffer + ";a21=";
        buffer = buffer + this.mReverseAzimuth;
        buffer = buffer + ";";
        buffer = buffer + "elev12=";
        buffer = buffer + this.mElevationChange;
        buffer = buffer + ";p2p=";
        buffer = buffer + this.mP2P;
        return buffer;
    }
}

