/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParser {
    public static Document getDomElement(String xml) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            Log.e((String)"Error: ", (String)e.getMessage());
            return null;
        }
        catch (SAXException e) {
            Log.e((String)"Error: ", (String)e.getMessage());
            return null;
        }
        catch (IOException e) {
            Log.e((String)"Error: ", (String)e.getMessage());
            return null;
        }
        return doc;
    }

    public static final String getElementValue(Node elem) {
        if (elem != null && elem.hasChildNodes()) {
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue();
            }
        }
        return "";
    }

    public static final String getAttributeValue(Node node, String str) {
        Element elem = null;
        if (node != null) {
            elem = (Element)node;
        }
        if (elem.hasAttribute(str)) {
            return elem.getAttribute(str);
        }
        return "";
    }

    public static String getValue(Element item, String str) {
        NodeList n = item.getElementsByTagName(str);
        return XMLParser.getElementValue(n.item(0));
    }

    public static String getAttribute(Element elem, String attribName) {
        if (elem != null && elem.hasAttribute(attribName)) {
            return elem.getAttribute(attribName);
        }
        return "";
    }
}

