/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.UnitFontLookupInfo;
import armyc2.c2sd.renderer.utilities.XMLParser;
import armyc2.c2sd.renderer.utilities.XMLUtil;
import java.util.HashMap;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnitFontLookup {
    private static boolean _initCalled = false;
    private static UnitFontLookup _instance;
    private boolean _ready = false;
    private static HashMap<String, UnitFontLookupInfo> hashMapB;
    private static HashMap<String, UnitFontLookupInfo> hashMapC;
    private static final int FillIndexUZ = 800;
    private static final int FillIndexUP = 849;
    private static final int FillIndexUA = 825;
    private static final int FillIndexUG = 800;
    private static final int FillIndexUGE = 800;
    private static final int FillIndexUS = 800;
    private static final int FillIndexUU = 837;
    private static final int FillIndexUF = 800;
    private static final int FillIndexFZ = 812;
    private static final int FillIndexFP = 843;
    private static final int FillIndexFA = 819;
    private static final int FillIndexFG = 803;
    private static final int FillIndexFGE = 812;
    private static final int FillIndexFS = 812;
    private static final int FillIndexFU = 831;
    private static final int FillIndexFF = 803;
    private static final int FillIndexNZ = 809;
    private static final int FillIndexNP = 846;
    private static final int FillIndexNA = 822;
    private static final int FillIndexNG = 809;
    private static final int FillIndexNGE = 809;
    private static final int FillIndexNS = 809;
    private static final int FillIndexNU = 834;
    private static final int FillIndexNF = 809;
    private static final int FillIndexHZ = 806;
    private static final int FillIndexHP = 840;
    private static final int FillIndexHA = 816;
    private static final int FillIndexHG = 806;
    private static final int FillIndexHGE = 806;
    private static final int FillIndexHS = 806;
    private static final int FillIndexHU = 828;
    private static final int FillIndexHF = 806;

    public boolean getReady() {
        return this._ready;
    }

    private UnitFontLookup() {
    }

    public static synchronized UnitFontLookup getInstance() {
        if (_instance == null) {
            _instance = new UnitFontLookup();
        }
        return _instance;
    }

    public synchronized void init(String[] unitFontMappingsStream) {
        if (!_initCalled) {
            _instance = new UnitFontLookup();
            String lookupXmlB = unitFontMappingsStream[0];
            String lookupXmlC = unitFontMappingsStream[1];
            UnitFontLookup.populateLookup(lookupXmlB, 0);
            UnitFontLookup.populateLookup(lookupXmlC, 1);
            _initCalled = true;
        }
    }

    private static void populateLookup(String xml, int SymbologyStandard) {
        Document document = XMLParser.getDomElement(xml);
        NodeList symbols = XMLUtil.getItemList(document, "SYMBOL");
        for (int i = 0; i < symbols.getLength(); ++i) {
            Node node = symbols.item(i);
            String ID = XMLUtil.parseTagValue(node, "SYMBOLID");
            String description = XMLUtil.parseTagValue(node, "DESCRIPTION");
            String m1u = XMLUtil.parseTagValue(node, "MAPPING1U");
            String m1f = XMLUtil.parseTagValue(node, "MAPPING1F");
            String m1n = XMLUtil.parseTagValue(node, "MAPPING1N");
            String m1h = XMLUtil.parseTagValue(node, "MAPPING1H");
            String m2 = XMLUtil.parseTagValue(node, "MAPPING2");
            String c1 = XMLUtil.parseTagValue(node, "MAPPING1COLOR");
            String c2 = XMLUtil.parseTagValue(node, "MAPPING2COLOR");
            UnitFontLookupInfo uflTemp = null;
            uflTemp = new UnitFontLookupInfo(ID, description, m1u = UnitFontLookup.checkMappingIndex(m1u), m1f = UnitFontLookup.checkMappingIndex(m1f), m1n = UnitFontLookup.checkMappingIndex(m1n), m1h = UnitFontLookup.checkMappingIndex(m1h), c1, m2 = UnitFontLookup.checkMappingIndex(m2), c2);
            if (uflTemp == null) continue;
            if (SymbologyStandard == 0) {
                hashMapB.put(ID, uflTemp);
                continue;
            }
            if (SymbologyStandard != 1) continue;
            hashMapC.put(ID, uflTemp);
        }
    }

    private static String checkMappingIndex(String index) {
        int i = -1;
        if (SymbolUtilities.isNumber(index)) {
            i = Integer.valueOf(index);
            if (i < 9000) {
                return String.valueOf(i + 57000);
            }
            return String.valueOf(i + 54000);
        }
        return index;
    }

    private String resolveAffiliation(String symbolID) {
        String code = symbolID.substring(0);
        String affiliation = symbolID.substring(1, 2);
        if (affiliation.equals("F") || affiliation.equals("H") || affiliation.equals("U") || affiliation.equals("N")) {
            return code;
        }
        code = affiliation.equals("S") ? code.substring(0, 1) + "H" + code.substring(2, 15) : (affiliation.equals("L") ? code.substring(0, 1) + "N" + code.substring(2, 15) : (affiliation.equals("A") || affiliation.equals("D") || affiliation.equals("M") || affiliation.equals("K") || affiliation.equals("J") ? code.substring(0, 1) + "F" + code.substring(2, 15) : (affiliation.equals("P") || affiliation.equals("G") || affiliation.equals("O") || affiliation.equals("W") ? code.substring(0, 1) + "U" + code.substring(2, 15) : code.substring(0, 1) + "U" + code.substring(2, 15))));
        return code;
    }

    public static UnitFontLookupInfo adjustSubSurfaceIfNot2525C(UnitFontLookupInfo original) {
        UnitFontLookupInfo result = null;
        return result;
    }

    public static int getFillCode(String SymbolID, int symStd) {
        int returnVal = -1;
        char scheme = '\u0000';
        char battleDimension = '\u0000';
        char status = '\u0000';
        char affiliation = '\u0000';
        char grdtrkSubset = '\u0000';
        try {
            if (SymbolID != null && SymbolID.length() >= 10) {
                scheme = SymbolID.charAt(0);
                affiliation = SymbolID.charAt(1);
                battleDimension = SymbolID.charAt(2);
                status = SymbolID.charAt(3);
                grdtrkSubset = SymbolID.charAt(4);
                if (scheme == 'S') {
                    returnVal = affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (battleDimension == 'F' || battleDimension == 'G' ? (battleDimension == 'F' || battleDimension == 'G' && (grdtrkSubset == 'U' || grdtrkSubset == 'I' || grdtrkSubset == '0' || grdtrkSubset == '-') ? 803 : (battleDimension == 'G' && grdtrkSubset == 'E' ? 812 : 803)) : (battleDimension == 'A' ? 819 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID) : (battleDimension == 'P' ? (symStd == 0 ? 819 : 843) : 812))))) : (affiliation == 'H' || affiliation == 'S' ? (battleDimension == 'Z' ? 806 : (battleDimension == 'F' || battleDimension == 'G' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID) : (battleDimension == 'P' ? (symStd == 0 ? 816 : 840) : 806)))))) : (affiliation == 'N' || affiliation == 'L' ? (battleDimension == 'Z' ? 809 : (battleDimension == 'F' || battleDimension == 'G' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID) : (battleDimension == 'P' ? (symStd == 0 ? 822 : 846) : 809)))))) : (battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'S' ? UnitFontLookup.getSeaSurfaceFill(SymbolID) : (battleDimension == 'U' ? UnitFontLookup.getSubSurfaceFill(SymbolID) : (battleDimension == 'P' ? (symStd == 0 ? 825 : 849) : 800)))))));
                } else if (scheme == 'E') {
                    returnVal = battleDimension != 'N' ? (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? (SymbolUtilities.isEMSEquipment(SymbolID) ? 812 : 803) : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800))) : -1;
                } else if (scheme == 'I') {
                    if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                        returnVal = battleDimension == 'Z' ? 812 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? (scheme == 'I' ? 812 : 803) : (battleDimension == 'A' ? 819 : (battleDimension == 'U' ? 831 : (battleDimension == 'P' ? (symStd == 0 ? 819 : 843) : (scheme == 'I' ? 812 : 803)))));
                    }
                    if (affiliation == 'H' || affiliation == 'S') {
                        returnVal = battleDimension == 'Z' ? 806 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 806 : (battleDimension == 'A' ? 816 : (battleDimension == 'U' ? 828 : (battleDimension == 'P' ? (symStd == 0 ? 816 : 840) : 806))));
                    }
                    if (affiliation == 'N' || affiliation == 'L') {
                        returnVal = battleDimension == 'Z' ? 809 : (battleDimension == 'F' || battleDimension == 'G' || battleDimension == 'S' ? 809 : (battleDimension == 'A' ? 822 : (battleDimension == 'U' ? 834 : (battleDimension == 'P' ? (symStd == 0 ? 822 : 846) : 809))));
                    } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                        returnVal = battleDimension == 'Z' || battleDimension == 'G' || battleDimension == 'S' || battleDimension == 'F' ? 800 : (battleDimension == 'A' ? 825 : (battleDimension == 'U' ? 837 : (battleDimension == 'P' ? (symStd == 0 ? 825 : 849) : 800)));
                    }
                } else {
                    returnVal = affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? 803 : (affiliation == 'H' || affiliation == 'S' ? 806 : (affiliation == 'N' || affiliation == 'L' ? 809 : 800));
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookup", "getFillCode", exc, Level.SEVERE);
        }
        return returnVal + 57000;
    }

    public static int getFrameCode(String SymbolID, int FillCode) {
        int returnVal = 0;
        char status = SymbolID.charAt(3);
        returnVal = status == 'A' ? FillCode + 2 : FillCode + 1;
        if (returnVal == 847) {
            returnVal = 852;
        }
        if (SymbolUtilities.isSeaSurface(SymbolID)) {
            returnVal = UnitFontLookup.getSeaSurfaceFrame(SymbolID, FillCode);
        }
        if (SymbolUtilities.isSubSurface(SymbolID)) {
            returnVal = UnitFontLookup.getSubSurfaceFrame(SymbolID, FillCode);
        }
        return returnVal;
    }

    private static int getSeaSurfaceFill(String SymbolID) {
        char affiliation = '\u0000';
        char status = '\u0000';
        boolean returnVal = false;
        try {
            affiliation = SymbolID.charAt(1);
            status = SymbolID.charAt(3);
            if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*S*O-----*****")) {
                return 2016;
            }
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                return 812;
            }
            if (affiliation == 'H' || affiliation == 'S') {
                return 806;
            }
            if (affiliation == 'N' || affiliation == 'L') {
                return 809;
            }
            if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                return 800;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getSeaSurfaceFill", exc);
            return 800;
        }
        return 800;
    }

    private static int getSubSurfaceFill(String SymbolID) {
        char affiliation = '\u0000';
        char status = '\u0000';
        int returnVal = 0;
        returnVal = 831;
        try {
            affiliation = SymbolID.charAt(1);
            status = SymbolID.charAt(3);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                returnVal = 831;
            } else if (affiliation == 'H' || affiliation == 'S') {
                returnVal = 828;
            } else if (affiliation == 'N' || affiliation == 'L') {
                returnVal = 834;
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                returnVal = 837;
            }
            if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*X-----*****")) {
                returnVal = status == 'A' ? (returnVal += 2) : ++returnVal;
            }
            if (RendererSettings.getInstance().getSymbologyStandard() == 1) {
                if (SymbolID.indexOf("WM") == 4 || SymbolID.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*V-----*****")) {
                    ++returnVal;
                    if (status == 'A') {
                        ++returnVal;
                    }
                } else if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = 2121;
                }
            } else if (SymbolID.indexOf("WM") == 4) {
                if (SymbolID.indexOf("----", 6) == 6 || SymbolID.indexOf("D---", 6) == 6) {
                    returnVal = 2059;
                } else if (SymbolID.indexOf("G---", 6) == 6) {
                    returnVal = 2062;
                } else if (SymbolID.indexOf("GD--", 6) == 6) {
                    returnVal = 2064;
                } else if (SymbolID.indexOf("M---", 6) == 6) {
                    returnVal = 2073;
                } else if (SymbolID.indexOf("MD--", 6) == 6) {
                    returnVal = 2075;
                } else if (SymbolID.indexOf("F---", 6) == 6) {
                    returnVal = 2084;
                } else if (SymbolID.indexOf("FD--", 6) == 6) {
                    returnVal = 2086;
                } else if (SymbolID.indexOf("O---", 6) == 6 || SymbolID.indexOf("OD--", 6) == 6) {
                    returnVal = 2094;
                }
            } else if (SymbolID.indexOf("WDM") == 4) {
                returnVal = 2115;
            } else if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*ND----*****")) {
                returnVal = 2121;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFill", exc);
            return 837;
        }
        return returnVal;
    }

    private static int getSeaSurfaceFrame(String SymbolID, int fillCode) {
        int returnVal = fillCode + 1;
        if (!SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*S*O-----*****")) {
            if (SymbolID.charAt(3) == 'A' || SymbolID.charAt(3) == 'a') {
                return fillCode + 2;
            }
            return fillCode + 1;
        }
        returnVal = -1;
        return returnVal;
    }

    private static int getSubSurfaceFrame(String SymbolID, int fillCode) {
        int returnVal;
        block11: {
            returnVal = 0;
            returnVal = 831;
            try {
                if (RendererSettings.getInstance().getSymbologyStandard() == 1) {
                    if (SymbolID.indexOf("WM") == 4 || SymbolID.indexOf("WDM") == 4 || SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*E-----*****") || SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*V-----*****") || SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*X-----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*ND----*****")) {
                        returnVal = -1;
                        break block11;
                    }
                    if (SymbolID.charAt(3) == 'A' || SymbolID.charAt(3) == 'a') {
                        return fillCode + 2;
                    }
                    return fillCode + 1;
                }
                if (SymbolID.indexOf("WM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID.indexOf("WDM") == 4) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*ND----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolUtilities.getBasicSymbolID(SymbolID).equalsIgnoreCase("S*U*X-----*****")) {
                    returnVal = -1;
                    break block11;
                }
                if (SymbolID.charAt(3) == 'A' || SymbolID.charAt(3) == 'a') {
                    return fillCode + 2;
                }
                return fillCode + 1;
            }
            catch (Exception exc) {
                ErrorLogger.LogException("UnitFontLookupC", "getSubSurfaceFrame", exc);
                return fillCode;
            }
        }
        return returnVal;
    }

    public UnitFontLookupInfo getLookupInfo(String SymbolID) {
        return this.getLookupInfo(SymbolID, RendererSettings.getInstance().getSymbologyStandard());
    }

    public UnitFontLookupInfo getLookupInfo(String SymbolID, int symbologyStandard) {
        UnitFontLookupInfo data = null;
        try {
            String code = SymbolUtilities.getBasicSymbolID(SymbolID);
            if (code.length() >= 10) {
                code = code.substring(0, 10) + "*****";
            }
            try {
                if (symbologyStandard == 0) {
                    if (hashMapB.containsKey(code)) {
                        data = hashMapB.get(code);
                    }
                } else if (hashMapC.containsKey(code)) {
                    data = hashMapC.get(code);
                }
            }
            catch (Exception exc) {
                Log.e((String)"UnitFontLookup", (String)exc.getMessage(), (Throwable)exc);
            }
            catch (Throwable thrown) {
                Log.wtf((String)"UnitFontLookup", (String)thrown.getMessage(), (Throwable)thrown);
                Exception ex = new Exception(thrown.getMessage());
                ErrorLogger.LogException("UnitFontLookup", "getLookupInfo(" + String.valueOf(SymbolID) + ")", ex, Level.WARNING);
            }
            return data;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("UnitFontLookup", "getLookupInfo(" + String.valueOf(SymbolID) + ")", exc, Level.WARNING);
            return null;
        }
    }

    public static float getUnitRatioHeight(int charIndex) {
        int characterIndex = charIndex - 57000;
        if (characterIndex == 840 || characterIndex == 816 || characterIndex == 828 || characterIndex == 829 || characterIndex == 830 || characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839) {
            return 1.3f;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44f;
        }
        if (characterIndex == 812 || characterIndex == 843 || characterIndex == 819 || characterIndex == 831 || characterIndex == 832 || characterIndex == 833 || characterIndex == 812 || characterIndex == 812 || characterIndex == 846 || characterIndex == 822 || characterIndex == 834 || characterIndex == 835 || characterIndex == 836) {
            return 1.2f;
        }
        if (characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809 || characterIndex == 809) {
            return 1.1f;
        }
        if (characterIndex == 803 || characterIndex == 812) {
            return 1.0f;
        }
        return 1.2f;
    }

    public static float getUnitRatioWidth(int charIndex) {
        int characterIndex = charIndex - 57000;
        if (characterIndex == 849 || characterIndex == 825 || characterIndex == 837 || characterIndex == 838 || characterIndex == 839 || characterIndex == 803 || characterIndex == 803) {
            return 1.5f;
        }
        if (characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 806 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800 || characterIndex == 800) {
            return 1.44f;
        }
        if (characterIndex == 812 || characterIndex == 812 || characterIndex == 812) {
            return 1.2f;
        }
        return 1.1f;
    }

    static {
        hashMapB = new HashMap();
        hashMapC = new HashMap();
    }
}

