/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import armyc2.c2sd.renderer.utilities.RectUtilities;
import armyc2.c2sd.renderer.utilities.RendererSettings;

public class TextInfo {
    String _text = "";
    Point _location = null;
    Rect _bounds = null;

    public TextInfo(String text, int x, int y, Paint font) {
        if (text != null) {
            this._text = text;
        }
        this._location = new Point(x, y);
        this._bounds = new Rect();
        font.getTextBounds(this._text, 0, this._text.length(), this._bounds);
    }

    public void setLocation(int x, int y) {
        this._bounds.offset(x - this._location.x, y - this._location.y);
        this._location = new Point(x, y);
    }

    public Point getLocation() {
        return this._location;
    }

    public void shift(int x, int y) {
        this._location.offset(x, y);
        this._bounds.offset(x, y);
    }

    public String getText() {
        return this._text;
    }

    public Rect getTextBounds() {
        return this._bounds;
    }

    public Rect getTextOutlineBounds() {
        RendererSettings RS = RendererSettings.getInstance();
        int outlineOffset = RS.getTextOutlineWidth();
        Rect bounds = new Rect(this._bounds);
        if (outlineOffset > 0) {
            if (RS.getTextBackgroundMethod() == 2) {
                RectUtilities.grow(bounds, outlineOffset / 2);
            } else {
                RectUtilities.grow(bounds, outlineOffset);
            }
        }
        return bounds;
    }
}

