/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import armyc2.c2sd.renderer.utilities.SVGPath;
import armyc2.c2sd.renderer.utilities.XMLParser;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymbolSVGTable {
    private static Boolean _initCalled = false;
    private static SymbolSVGTable _instance = null;
    private static Map<String, SVGPath> _SymbolDefinitions = null;

    private SymbolSVGTable() {
    }

    public static synchronized SymbolSVGTable getInstance() {
        if (_instance == null) {
            _instance = new SymbolSVGTable();
        }
        return _instance;
    }

    public synchronized void init(String symbolSVG) {
        if (!_initCalled.booleanValue()) {
            _instance = new SymbolSVGTable();
            _SymbolDefinitions = new HashMap<String, SVGPath>();
            String lookupXml = symbolSVG;
            this.populateLookup(lookupXml);
            _initCalled = true;
        }
    }

    private void populateLookup(String xml) {
        try {
            Document doc = XMLParser.getDomElement(xml);
            NodeList nl = doc.getElementsByTagName("glyph");
            for (int i = 0; i < nl.getLength(); ++i) {
                String index = XMLParser.getAttribute((Element)nl.item(i), "unicode");
                String strPath = XMLParser.getAttribute((Element)nl.item(i), "d");
                if (strPath == null || strPath.equals("") || index == null || index.length() <= 3) continue;
                index = index.substring(3);
                SVGPath path = new SVGPath(index, strPath);
                index = path.getID();
                _SymbolDefinitions.put(index, path);
            }
        }
        catch (Exception exc) {
            Log.e((String)"SymbolSVGTable", (String)exc.getMessage(), (Throwable)exc);
        }
    }

    public SVGPath getSVGPath(String index) {
        SVGPath returnVal = null;
        try {
            if (_SymbolDefinitions.containsKey(index)) {
                returnVal = new SVGPath(_SymbolDefinitions.get(index));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnVal;
    }

    public Boolean HasSVGPath(String index) {
        if (index != null && index.length() > 0) {
            return _SymbolDefinitions.containsKey(index);
        }
        return false;
    }
}

