/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.util.Log;
import armyc2.c2sd.renderer.utilities.SymbolDef;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.XMLParser;
import armyc2.c2sd.renderer.utilities.XMLUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymbolDefTable {
    private static SymbolDefTable _instance = null;
    private static Boolean _initCalled = false;
    private static Map<String, SymbolDef> _SymbolDefinitionsB = null;
    private static ArrayList<SymbolDef> _SymbolDefDupsB = null;
    private String TAG = "SymbolDefTable";
    private static Map<String, SymbolDef> _SymbolDefinitionsC = null;
    private static ArrayList<SymbolDef> _SymbolDefDupsC = null;
    private static String propSymbolID = "SYMBOLID";
    private static String propGeometry = "GEOMETRY";
    private static String propDrawCategory = "DRAWCATEGORY";
    private static String propMaxPoint = "MAXPOINTS";
    private static String propMinPoints = "MINPOINTS";
    private static String propHasWidth = "HASWIDTH";
    private static String propModifiers = "MODIFIERS";
    private static String propDescription = "DESCRIPTION";
    private static String propHierarchy = "HIERARCHY";

    private SymbolDefTable() {
    }

    public static synchronized SymbolDefTable getInstance() {
        if (_instance == null) {
            _instance = new SymbolDefTable();
        }
        return _instance;
    }

    private String getXML(String xmlName) {
        String xmlFolder = "res/raw/";
        String xml = null;
        Object tf = null;
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(xmlFolder + xmlName);
            if (is != null) {
                String line;
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader r = new BufferedReader(isr);
                StringBuilder total = new StringBuilder();
                while ((line = r.readLine()) != null) {
                    total.append(line);
                }
                xml = total.toString();
                r.close();
                isr.close();
                is.close();
                r = null;
                isr = null;
                is = null;
                total = null;
            }
        }
        catch (Exception exc) {
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
        }
        return xml;
    }

    public final synchronized void init() {
        if (!_initCalled.booleanValue()) {
            String[] xml = new String[]{this.getXML("symbolconstantsb.xml"), this.getXML("symbolconstantsc.xml")};
            this.init(xml);
        }
    }

    public final synchronized void init(String[] symbolConstantsXML) {
        if (!_initCalled.booleanValue()) {
            _SymbolDefinitionsB = new HashMap<String, SymbolDef>();
            _SymbolDefDupsB = new ArrayList();
            _SymbolDefinitionsC = new HashMap<String, SymbolDef>();
            _SymbolDefDupsC = new ArrayList();
            String lookupXmlB = symbolConstantsXML[0];
            String lookupXmlC = symbolConstantsXML[1];
            this.populateLookup(lookupXmlB, 0);
            this.populateLookup(lookupXmlC, 1);
            _initCalled = true;
        }
    }

    private void populateLookup(String xml, int symStd) {
        Document document = XMLParser.getDomElement(xml);
        SymbolDef sd = null;
        NodeList symbols = XMLUtil.getItemList(document, "SYMBOL");
        for (int i = 0; i < symbols.getLength(); ++i) {
            Node node = symbols.item(i);
            String symbolID = XMLUtil.parseTagValue(node, "SYMBOLID");
            String geometry = XMLUtil.parseTagValue(node, "GEOMETRY");
            String drawCategory = XMLUtil.parseTagValue(node, "DRAWCATEGORY");
            String maxpoints = XMLUtil.parseTagValue(node, "MAXPOINTS");
            String minpoints = XMLUtil.parseTagValue(node, "MINPOINTS");
            String modifiers = XMLUtil.parseTagValue(node, "MODIFIERS");
            String description = XMLUtil.parseTagValue(node, "DESCRIPTION");
            description = description.replaceAll("&amp;", "&");
            String hierarchy = XMLUtil.parseTagValue(node, "HIERARCHY");
            String path = XMLUtil.parseTagValue(node, "PATH");
            sd = new SymbolDef(symbolID, description, Integer.valueOf(drawCategory), hierarchy, Integer.valueOf(minpoints), Integer.valueOf(maxpoints), modifiers, path);
            boolean isMCSSpecific = SymbolUtilities.isMCSSpecificTacticalGraphic(sd);
            if (symStd == 0) {
                if (!_SymbolDefinitionsB.containsKey(symbolID) && !isMCSSpecific) {
                    _SymbolDefinitionsB.put(symbolID, sd);
                    continue;
                }
                if (isMCSSpecific) continue;
                _SymbolDefDupsB.add(sd);
                continue;
            }
            if (symStd != 1) continue;
            if (!_SymbolDefinitionsC.containsKey(symbolID) && !isMCSSpecific) {
                _SymbolDefinitionsC.put(symbolID, sd);
                continue;
            }
            if (isMCSSpecific) continue;
            _SymbolDefDupsC.add(sd);
        }
    }

    public SymbolDef getSymbolDef(String basicSymbolID, int symStd) {
        SymbolDef returnVal = null;
        if (symStd == 0) {
            returnVal = _SymbolDefinitionsB.get(basicSymbolID);
        } else if (symStd == 1) {
            returnVal = _SymbolDefinitionsC.get(basicSymbolID);
        }
        return returnVal;
    }

    public Map<String, SymbolDef> GetAllSymbolDefs(int symStd) {
        if (symStd == 0) {
            return _SymbolDefinitionsB;
        }
        if (symStd == 1) {
            return _SymbolDefinitionsC;
        }
        return null;
    }

    public ArrayList<SymbolDef> GetAllSymbolDefDups(int symStd) {
        if (symStd == 0) {
            return _SymbolDefDupsB;
        }
        if (symStd == 1) {
            return _SymbolDefDupsC;
        }
        return null;
    }

    public Boolean HasSymbolDef(String basicSymbolID, int symStd) {
        if (basicSymbolID != null && basicSymbolID.length() == 15) {
            if (symStd == 0) {
                return _SymbolDefinitionsB.containsKey(basicSymbolID);
            }
            if (symStd == 1) {
                return _SymbolDefinitionsC.containsKey(basicSymbolID);
            }
            return false;
        }
        return false;
    }

    public Boolean isMultiPoint(String symbolID, int symStd) {
        char codingScheme = symbolID.charAt(0);
        Boolean returnVal = false;
        if (codingScheme == 'G' || codingScheme == 'W') {
            String basicSymbolID = symbolID.charAt(1) != '*' ? SymbolUtilities.getBasicSymbolID(symbolID) : symbolID;
            SymbolDef sd = this.getSymbolDef(basicSymbolID, symStd);
            if (sd != null) {
                if (sd.getMaxPoints() > 1) {
                    returnVal = true;
                } else {
                    switch (sd.getDrawCategory()) {
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: {
                            returnVal = true;
                            break;
                        }
                        default: {
                            returnVal = false;
                        }
                    }
                }
                return returnVal;
            }
            return false;
        }
        if (symbolID.startsWith("BS_") || symbolID.startsWith("BBS_") || symbolID.startsWith("PBS_")) {
            return true;
        }
        return false;
    }
}

