/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import armyc2.c2sd.graphics2d.BasicStroke;
import armyc2.c2sd.graphics2d.GeneralPath;
import armyc2.c2sd.graphics2d.Point;
import armyc2.c2sd.graphics2d.Point2D;
import armyc2.c2sd.graphics2d.Rectangle;
import armyc2.c2sd.graphics2d.Shape;
import armyc2.c2sd.graphics2d.Stroke;
import armyc2.c2sd.graphics2d.TextLayout;
import armyc2.c2sd.graphics2d.TexturePaint;
import armyc2.c2sd.renderer.utilities.Color;
import java.util.ArrayList;

public class ShapeInfo {
    public static final int SHAPE_TYPE_POLYLINE = 0;
    public static final int SHAPE_TYPE_FILL = 1;
    public static final int SHAPE_TYPE_MODIFIER = 2;
    public static final int SHAPE_TYPE_MODIFIER_FILL = 3;
    public static final int SHAPE_TYPE_UNIT_FRAME = 4;
    public static final int SHAPE_TYPE_UNIT_FILL = 5;
    public static final int SHAPE_TYPE_UNIT_SYMBOL1 = 6;
    public static final int SHAPE_TYPE_UNIT_SYMBOL2 = 7;
    public static final int SHAPE_TYPE_UNIT_DISPLAY_MODIFIER = 8;
    public static final int SHAPE_TYPE_UNIT_ECHELON = 9;
    public static final int SHAPE_TYPE_UNIT_AFFILIATION_MODIFIER = 10;
    public static final int SHAPE_TYPE_UNIT_HQ_STAFF = 11;
    public static final int SHAPE_TYPE_TG_SP_FILL = 12;
    public static final int SHAPE_TYPE_TG_SP_FRAME = 13;
    public static final int SHAPE_TYPE_TG_Q_MODIFIER = 14;
    public static final int SHAPE_TYPE_TG_SP_OUTLINE = 15;
    public static final int SHAPE_TYPE_SINGLE_POINT_OUTLINE = 16;
    public static final int SHAPE_TYPE_UNIT_OUTLINE = 17;
    public static final int justify_left = 0;
    public static final int justify_center = 1;
    public static final int justify_right = 2;
    protected Shape _Shape;
    private Stroke stroke;
    private GeneralPath gp;
    private int fillStyle;
    private TexturePaint texturePaint;
    private int shapeType = -1;
    private Color lineColor = null;
    private Color fillColor = null;
    private int lineWidth = 2;
    private int _justify = 0;
    private TextLayout _TextLayout = null;
    private Point2D _Position = null;
    private String _ModifierString = null;
    private Point2D _ModifierStringPosition = null;
    private double _ModifierStringAngle = 0.0;
    private Object _Tag = null;
    private BitmapShader _shader = null;
    private Bitmap _patternFill = null;
    private ArrayList<ArrayList<Point2D>> _Polylines = null;

    protected ShapeInfo() {
    }

    public ShapeInfo(Shape shape) {
        this._Shape = shape;
    }

    public ShapeInfo(TextLayout textLayout, Point2D position) {
        this._TextLayout = textLayout;
        this._Position = position;
    }

    public ShapeInfo(Shape shape, int shapeType) {
        this._Shape = shape;
    }

    public Shape getShape() {
        return this._Shape;
    }

    public void setShape(Shape value) {
        this._Shape = value;
        this._TextLayout = null;
    }

    public TextLayout getTextLayout() {
        return this._TextLayout;
    }

    public void setTextLayout(TextLayout value) {
        this._TextLayout = value;
        this._Shape = null;
    }

    public void setModifierString(String value) {
        this._ModifierString = value;
    }

    public String getModifierString() {
        return this._ModifierString;
    }

    public void setModifierStringPosition(Point2D value) {
        this._ModifierStringPosition = value;
    }

    public Point2D getModifierStringPosition() {
        return this._ModifierStringPosition;
    }

    public void setModifierStringAngle(double value) {
        this._ModifierStringAngle = value;
    }

    public double getModifierStringAngle() {
        return this._ModifierStringAngle;
    }

    public void setTag(Object value) {
        this._Tag = value;
    }

    public Object getTag() {
        return this._Tag;
    }

    public Rectangle getBounds() {
        Rectangle temp = null;
        if (this._Shape != null) {
            temp = this._Shape.getBounds();
            if (this._Shape instanceof GeneralPath) {
                BasicStroke bs;
                if (this.shapeType == 17) {
                    BasicStroke bs2;
                    if (this.lineColor != null && this.stroke != null && (bs2 = (BasicStroke)this.stroke) != null && bs2.getLineWidth() > 2.0f) {
                        temp.grow((int)bs2.getLineWidth() / 2, (int)bs2.getLineWidth() / 2);
                    }
                } else if (this.lineColor != null && this.stroke != null && (bs = (BasicStroke)this.stroke) != null && bs.getLineWidth() > 2.0f) {
                    temp.grow((int)bs.getLineWidth() - 1, (int)bs.getLineWidth() - 1);
                }
            }
        }
        if (this._TextLayout != null && this._Position != null) {
            temp = this._TextLayout.getPixelBounds(null, (float)this._Position.getX(), (float)this._Position.getY());
        } else if (this._TextLayout != null) {
            temp = new Rectangle(0, 0, 0, 0);
            temp.setRect(this._TextLayout.getBounds());
        } else {
            return null;
        }
        return temp;
    }

    public void setGlyphPosition(Point position) {
        this._Position = new Point2D.Double(position.x, position.y);
    }

    public void setGlyphPosition(Point2D position) {
        this._Position = position;
    }

    public Point2D getGlyphPosition() {
        return this._Position;
    }

    public void setLineColor(Color value) {
        this.lineColor = value;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setFillColor(Color value) {
        this.fillColor = value;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public TexturePaint getTexturePaint() {
        return this.texturePaint;
    }

    public void setTexturePaint(TexturePaint value) {
        this.texturePaint = value;
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(int value) {
        this.fillStyle = value;
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public void setShapeType(int value) {
        this.shapeType = value;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public ArrayList<ArrayList<Point2D>> getPolylines() {
        return this._Polylines;
    }

    public void setPolylines(ArrayList<ArrayList<Point2D>> value) {
        this._Polylines = value;
    }

    public void setShader(BitmapShader value) {
        this._shader = value;
    }

    public BitmapShader getShader() {
        return this._shader;
    }

    public void setPatternFillImage(Bitmap bmp) {
        this._patternFill = bmp;
    }

    public Bitmap getPatternFillImage() {
        return this._patternFill;
    }

    public int getTextJustify() {
        return this._justify;
    }

    public void setTextJustify(int value) {
        this._justify = value;
    }
}

