/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer.utilities;

import armyc2.c2sd.renderer.utilities.SymbolUtilities;

public class Color {
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private int _A = 255;
    private int _R = 0;
    private int _G = 0;
    private int _B = 0;

    public Color(int R2, int G, int B) {
        this._A = 255;
        this._R = R2;
        this._G = G;
        this._B = B;
    }

    public Color(int R2, int G, int B, int A) {
        this._A = A;
        this._R = R2;
        this._G = G;
        this._B = B;
    }

    public Color(Color color) {
        if (color != null) {
            this._A = color.getAlpha();
            this._R = color.getRed();
            this._G = color.getGreen();
            this._B = color.getBlue();
        } else {
            this._A = 255;
            this._R = 0;
            this._G = 0;
            this._B = 0;
        }
    }

    public Color(int color) {
        this._A = this.getAlphaFromColor(color);
        this._R = this.getRedFromColor(color);
        this._G = this.getGreenFromColor(color);
        this._B = this.getBlueFromColor(color);
    }

    public Color(String hexString) {
        Color temp = SymbolUtilities.getColorFromHexString(hexString);
        if (temp != null) {
            this._A = temp.getAlpha();
            this._R = temp.getRed();
            this._G = temp.getGreen();
            this._B = temp.getBlue();
        } else {
            this._A = 255;
            this._R = 0;
            this._G = 0;
            this._B = 0;
        }
    }

    public Color(Object color) {
        try {
            if (color instanceof String) {
                Color cTemp = SymbolUtilities.getColorFromHexString((String)color);
                if (cTemp != null) {
                    this._A = cTemp.getAlpha();
                    this._R = cTemp.getRed();
                    this._G = cTemp.getGreen();
                    this._B = cTemp.getBlue();
                }
            } else if (color instanceof Integer) {
                int iTemp = (Integer)color;
                this._A = this.getAlphaFromColor(iTemp);
                this._R = this.getRedFromColor(iTemp);
                this._G = this.getGreenFromColor(iTemp);
                this._B = this.getBlueFromColor(iTemp);
            } else {
                this._A = 255;
                this._R = 0;
                this._G = 0;
                this._B = 0;
            }
        }
        catch (Exception exc) {
            this._A = 255;
            this._R = 0;
            this._G = 0;
            this._B = 0;
        }
    }

    public int toARGB() {
        int returnVal = 0;
        returnVal = (this._A << 24) + ((this._R & 0xFF) << 16) + ((this._G & 0xFF) << 8) + (this._B & 0xFF);
        return returnVal;
    }

    public String toHexString() {
        return Integer.toHexString(this.toARGB());
    }

    public String toString() {
        return "Color{A=" + String.valueOf(this._A) + ",R=" + String.valueOf(this._R) + ",G=" + String.valueOf(this._G) + ",B=" + String.valueOf(this._B) + "}";
    }

    public int getRed() {
        return this._R;
    }

    public int getGreen() {
        return this._G;
    }

    public int getBlue() {
        return this._B;
    }

    public int getAlpha() {
        return this._A;
    }

    public void setAlpha(int alpha) {
        this._A = alpha;
    }

    public int toInt() {
        return android.graphics.Color.argb((int)this._A, (int)this._R, (int)this._G, (int)this._B);
    }

    private int getAlphaFromColor(int color) {
        int alpha = 255;
        if (color > 0xFFFFFF) {
            alpha = color >>> 24;
        }
        return alpha;
    }

    private int getRedFromColor(int color) {
        int red = 255;
        red = color >> 16 & 0xFF;
        return red;
    }

    private int getGreenFromColor(int color) {
        int green = 255;
        green = color >> 8 & 0xFF;
        return green;
    }

    private int getBlueFromColor(int color) {
        int blue = 255;
        blue = color > 0xFFFFFF ? color & 0xFF : color & 0xFF;
        return blue;
    }

    static {
        WHITE = white = new Color(255, 255, 255);
        LIGHT_GRAY = lightGray = new Color(192, 192, 192);
        GRAY = gray = new Color(128, 128, 128);
        DARK_GRAY = darkGray = new Color(64, 64, 64);
        BLACK = black = new Color(0, 0, 0);
        RED = red = new Color(255, 0, 0);
        PINK = pink = new Color(255, 175, 175);
        ORANGE = orange = new Color(255, 200, 0);
        YELLOW = yellow = new Color(255, 255, 0);
        GREEN = green = new Color(0, 255, 0);
        MAGENTA = magenta = new Color(255, 0, 255);
        CYAN = cyan = new Color(0, 255, 255);
        BLUE = blue = new Color(0, 0, 255);
    }
}

