/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Base64;
import android.util.SparseArray;
import armyc2.c2sd.renderer.MilStdIconRenderer;
import armyc2.c2sd.renderer.utilities.ImageInfo;

public class PatternFillRenderer {
    private static String duriBeachSlopeModerate = "iVBORw0KGgoAAAANSUhEUgAAADYAAAAzBAMAAAAupuZdAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAYUExURQAAAMXFxczMzM3NzdXV1dnZ2eLi4ubm5nz94OEAAAABdFJOUwBA5thmAAAAWklEQVQ4y2NgoD8wA5PMCQgSKgTkCjuAKEMTBAkRYgIyhAxAfCNlBAkVAgJ3MMlSgCChQiMc4AtrIcywFoKFtTJmWCuPhjXJaVcIT9odDU/qpl1hPGl3SJUTACZHFZF+np+2AAAAAElFTkSuQmCC";
    private static String duriBeachSlopeSteep = "iVBORw0KGgoAAAANSUhEUgAAABoAAAAaBAMAAABbZFH9AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAVUExURQAAAJSUlKKioru7u87OztfX1+Li4hAmdeYAAAABdFJOUwBA5thmAAAAJElEQVQY02NgIB+YIpEMzEIOMJIJiAQVGGAkELghkfQHg8WdABqRBBGoXfbeAAAAAElFTkSuQmCC";
    private static String duriBeigeStipple = "iVBORw0KGgoAAAANSUhEUgAAAB4AAAAeAQMAAAAB/jzhAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9gMHhIBKQOEJ3wAAAADUExURfnz8ehEBXEAAAAMSURBVAgdY2AYjAAAAJYAASEQeSYAAAAASUVORK5CYII=";
    private static String duriFoulGround = "iVBORw0KGgoAAAANSUhEUgAAADwAAAA8CAMAAAANIilAAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAABOUExURQAAAICAgIaGhouLi42NjZCQkJSUlJiYmJycnKCgoKWlpampqa6urrGxsbe3t7u7u7y8vMbGxsjIyMzMzNHR0djY2N/f3+Xl5evr6/Ly8oBtGtwAAAABdFJOUwBA5thmAAAA50lEQVRIx+2UwW7DMAxDySVy0iqRl7WL6v//0R2GDttR8iHoEN4JU7T0gFOngrpZBZqZZ8yFM1DJe8LbRl4ApTwS5k/SgJklk3olHRBeo8bdzArH1ZSUaGPG37KYuf4x12DT7u/k4l5Y3Fuur1bifQGAcgL28MDfsYWzu5JbOHZX213m3UZSq76xmNkenfrK8lzvzD1enusdlg9cAKVkHt7IDRBOGXNzB+D+wH/R4VAdk1CtwJz7xE6oDqstpETv5bgz/4Hq1ANV6YNqzdyacHJX8iMcux4I1YHUqgPl1aCqJ1RPvZy+AED/Df1MKozlAAAAAElFTkSuQmCC";
    private static String duriKelp = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA5CAMAAABwHZdJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAABFUExURQAAAICAgIeHh4qKio+Pj5KSkpSUlJqamp6enqGhoaenp6+vr7Gxsbi4uMDAwMjIyM/Pz9bW1tra2t7e3uDg4OXl5evr67APy9YAAAABdFJOUwBA5thmAAABCUlEQVQYGe3BQXbCMAwFwO8KXMWJI6uudP+j9kGB57AjMaw8AwzD8FnueAON6MDxJGUcx5QNG1HQgcRzQcOpoAP9msKiuNF1CjOeVbxojgYUDknUJIVF7DedDRuF8BrL+FclBVJcFUoVd1aYHXslUjwUpjhRuOBZsZfQikadKP3gIGd2NFJUHCZB0FBa0cGM1kqG7owdwzB8TsU7kOENlHCcECs2MqMDTbQ4GpnRgX9HigU3VdLp5HjihtcUEqDOxLlYzcRSLQfBhlPBa2bDlclyChlXnmLBnddMir2EMh5sDueJw0VMBXtZTI5GDpMYDlqpoFFCxmEWE1rMjuOyouG0oj9SDMPwcX/MrgqpcUsGFwAAAABJRU5ErkJggg==";
    private static String duriRigField = "iVBORw0KGgoAAAANSUhEUgAAACwAAAAsBAMAAADsqkcyAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAqUExURQAAAMDAwMTExMjIyM3NzdHR0dXV1dnZ2d3d3eHh4eXl5enp6e3t7fDw8Awi1VsAAAABdFJOUwBA5thmAAAAh0lEQVQoz2NgGAqATdAHxiwSngBj8goKCkI5TIKCojBhZqCwAIRZCGRugCpmBLKlIGxFIDMBqhokLAlhAlmCAUjC0hCmIZBZABVmBbIVIMyJQOYFmJ2GgkIH4Cok4e7mCm2AMbeFX2AYBbgBjqDCHrDYo4EXR6ThiWIsCQJ78sGV2HAkzUENAN13GlU/PHOyAAAAAElFTkSuQmCC";
    private static String duriSweptArea = "iVBORw0KGgoAAAANSUhEUgAAACQAAAAkBAMAAAATLoWrAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAnUExURQAAAP4A/v41/v5k/v51/v6F/v6T/v6h/v6t/v7E/v7P/v7Z/v7j/s8+NL4AAAABdFJOUwBA5thmAAAAbElEQVQoz2NgGHLgmKHZAVQRVkFBQVFUIUOgkKABsggLSERQBFloIlhIcAK6PkFBByQhiIigAEKEGyokjVcIi0YGRYiQApJQIUSoAEmICSwihOxUTrCQJAOG8yegCPEECgrGoAfYigUMwwIAAJevDkkSlISwAAAAAElFTkSuQmCC";
    private static String duriWeirs = "iVBORw0KGgoAAAANSUhEUgAAACQAAAAiBAMAAADFd2a2AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAhUExURQAAAMDAwMTExMjIyM7OztHR0dXV1d3d3eHh4enp6fDw8MnCp1cAAAABdFJOUwBA5thmAAAASUlEQVQoz2NgIBp4YoiwCU7AEFOUxBBioqEy1lAgCBEUCQUDsNBCQWSwACxk0QEE7R1gYAgRCkAyJXDICWHxI6YQ1ypkwDB4AQCRDzCzcuhQTwAAAABJRU5ErkJggg==";
    private static Bitmap patternBeachSlopeModerate = null;
    private static Bitmap patternBeachSlopeSteep = null;
    private static Bitmap patternBeigeStipple = null;
    private static Bitmap patternFoulGround = null;
    private static Bitmap patternKelp = null;
    private static Bitmap patternRigField = null;
    private static Bitmap patternSweptArea = null;
    private static Bitmap patternWeirs = null;

    public static Bitmap MakeSymbolPatternFill(String symbolFillIDs, int symbolFillSize) {
        String[] IDs = symbolFillIDs.split(",");
        return PatternFillRenderer.MakeSymbolPatternFill(IDs, symbolFillSize);
    }

    public static Bitmap MakeSymbolPatternFill(String[] symbolFillIDs, int symbolFillSize) {
        Bitmap fill = null;
        int symCount = symbolFillIDs.length;
        ImageInfo[] symbols = new ImageInfo[symCount];
        int width = 0;
        int height = 0;
        int top = 0;
        int bottom = 0;
        int spacerW = 0;
        int spacerH = 0;
        Rect rect = null;
        SparseArray mods = new SparseArray();
        SparseArray sa = new SparseArray();
        sa.put(3, (Object)String.valueOf(symbolFillSize));
        for (int i = 0; i < symCount; ++i) {
            if (symbolFillIDs[i].charAt(0) == 'W') {
                mods.put(7, (Object)"false");
            } else {
                mods.put(7, (Object)"true");
            }
            symbols[i] = MilStdIconRenderer.getInstance().RenderIcon(symbolFillIDs[i], (SparseArray<String>)mods, (SparseArray<String>)sa);
            if (symbols[i] == null) continue;
            rect = symbols[i].getImageBounds();
            if (rect.width() > width) {
                width = rect.width();
            }
            if (rect.height() > height) {
                height = rect.height();
            }
            if (top < symbols[i].getCenterPoint().y) {
                top = symbols[i].getCenterPoint().y;
            }
            if (bottom >= rect.height() - symbols[i].getCenterPoint().y) continue;
            bottom = rect.height() - symbols[i].getCenterPoint().y;
        }
        height = top + bottom;
        spacerW = width / 3;
        spacerH = height / 3;
        int bWidth = width * symCount + spacerW * symCount;
        int bHeight = height + spacerH;
        if (bWidth > 0 && bHeight > 0) {
            fill = Bitmap.createBitmap((int)bWidth, (int)bHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(fill);
            int x = spacerW;
            int y = spacerH;
            for (int j = 0; j < symCount; ++j) {
                ImageInfo ii = symbols[j];
                if (ii == null) continue;
                Point center = ii.getCenterPoint();
                canvas.drawBitmap(ii.getImage(), (float)(x + width / 2 - center.x), (float)(y + top - center.y), null);
                x += spacerW + width;
            }
        }
        return fill;
    }

    public static Bitmap MakeMetocPatternFill(String symbolID) {
        if (symbolID.equals("WO-DBSM-----A--")) {
            if (patternBeachSlopeModerate == null) {
                patternBeachSlopeModerate = PatternFillRenderer.LoadBMPFromDataURL(duriBeachSlopeModerate);
            }
            return patternBeachSlopeModerate;
        }
        if (symbolID.equals("WO-DBST-----A--")) {
            if (patternBeachSlopeSteep == null) {
                patternBeachSlopeSteep = PatternFillRenderer.LoadBMPFromDataURL(duriBeachSlopeSteep);
            }
            return patternBeachSlopeSteep;
        }
        if (symbolID.equals("WO-DHCB-----A--")) {
            if (patternBeigeStipple == null) {
                patternBeigeStipple = PatternFillRenderer.LoadBMPFromDataURL(duriBeigeStipple);
            }
            return patternBeigeStipple;
        }
        if (symbolID.equals("WO-DHHDF----A--")) {
            if (patternFoulGround == null) {
                patternFoulGround = PatternFillRenderer.LoadBMPFromDataURL(duriFoulGround);
            }
            return patternFoulGround;
        }
        if (symbolID.equals("WO-DHHDK----A--")) {
            if (patternKelp == null) {
                patternKelp = PatternFillRenderer.LoadBMPFromDataURL(duriKelp);
            }
            return patternKelp;
        }
        if (symbolID.equals("WO-DMOA-----A--")) {
            if (patternRigField == null) {
                patternRigField = PatternFillRenderer.LoadBMPFromDataURL(duriRigField);
            }
            return patternRigField;
        }
        if (symbolID.equals("WO-DL-SA----A--")) {
            if (patternSweptArea == null) {
                patternSweptArea = PatternFillRenderer.LoadBMPFromDataURL(duriSweptArea);
            }
            return patternSweptArea;
        }
        if (symbolID.equals("WOS-HPFF----A--")) {
            if (patternWeirs == null) {
                patternWeirs = PatternFillRenderer.LoadBMPFromDataURL(duriWeirs);
            }
            return patternWeirs;
        }
        return null;
    }

    private static Bitmap LoadBMPFromDataURL(String durl) {
        byte[] decodedString = Base64.decode((String)durl, (int)0);
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
        return bmp;
    }

    public static Bitmap MakeHatchPatternFill() {
        return null;
    }
}

