/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.SparseArray;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ImageInfo;
import armyc2.c2sd.renderer.utilities.PathUtilties;
import armyc2.c2sd.renderer.utilities.RectUtilities;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.RendererUtilities;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.TextInfo;
import armyc2.c2sd.renderer.utilities.UnitFontLookup;
import java.util.ArrayList;
import java.util.Locale;

public class ModifierRenderer {
    private static Paint _modifierFont = null;
    private static float _modifierFontHeight = 10.0f;
    private static float _modifierFontDescent = 2.0f;
    private static RendererSettings RS = RendererSettings.getInstance();

    public static void setModifierFont(Paint font, float height, float descent) {
        _modifierFont = font;
        _modifierFontHeight = height;
        _modifierFontDescent = descent;
    }

    public static ImageInfo processUnitDisplayModifiers(ImageInfo ii, String symbolID, SparseArray<String> modifiers, Boolean hasTextModifiers, SparseArray<String> attributes) {
        Paint ociPaint;
        String strQ;
        int x;
        String strEchelon;
        ImageInfo newii = null;
        Rect symbolBounds = new Rect(ii.getSymbolBounds());
        Rect imageBounds = new Rect(ii.getImageBounds());
        Point centerPoint = new Point(ii.getCenterPoint());
        Point symbolCenter = new Point(symbolBounds.centerX(), symbolBounds.centerY());
        TextInfo tiEchelon = null;
        TextInfo tiAM = null;
        Rect echelonBounds = null;
        Rect amBounds = null;
        Color textColor = Color.BLACK;
        Color textBackgroundColor = null;
        Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        boolean buffer = false;
        int alpha = -1;
        boolean offsetX = false;
        int offsetY = 0;
        int symStd = RS.getSymbologyStandard();
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        if (attributes.indexOfKey(6) >= 0) {
            alpha = Integer.parseInt((String)attributes.get(6));
            textColor.setAlpha(alpha);
        }
        if (attributes.indexOfKey(13) >= 0) {
            textColor = SymbolUtilities.getColorFromHexString((String)attributes.get(13));
            if (alpha > -1) {
                textColor.setAlpha(alpha);
            }
        }
        if (attributes.indexOfKey(14) >= 0) {
            textBackgroundColor = SymbolUtilities.getColorFromHexString((String)attributes.get(14));
            if (alpha > -1) {
                textBackgroundColor.setAlpha(alpha);
            }
        }
        if (attributes.indexOfKey(0) >= 0) {
            lineColor = SymbolUtilities.getColorFromHexString((String)attributes.get(0));
        }
        RectF mobilityBounds = null;
        ArrayList shapes = new ArrayList();
        Path mobilityPath = null;
        Path mobilityPathFill = null;
        if (symbolID.charAt(10) == 'M' && SymbolUtilities.canUnitHaveModifier(symbolID, 18) || symbolID.charAt(10) == 'N' && SymbolUtilities.canUnitHaveModifier(symbolID, 35)) {
            int fifth = (int)((double)symbolBounds.width() * 0.2 + 0.5);
            mobilityPath = new Path();
            int x2 = 0;
            int y = 0;
            int centerX = 0;
            int bottomY = 0;
            int height = 0;
            int width = 0;
            int middleY = 0;
            int wheelOffset = 2;
            int wheelSize = fifth;
            int rrHeight = fifth;
            int rrArcWidth = (int)((double)fifth * 1.5 + 0.5);
            String mobility = symbolID.substring(10, 12);
            x2 = symbolBounds.left + 1;
            y = symbolBounds.top;
            height = Math.round(symbolBounds.height());
            width = Math.round(symbolBounds.width()) - 3;
            bottomY = y + height + 2;
            if (symbolID.charAt(10) == 'M') {
                bottomY = y + height + 2;
                if (mobility.equals("MO")) {
                    PathUtilties.addLine(mobilityPath, x2, bottomY, x2 + width, bottomY);
                    PathUtilties.addEllipse(mobilityPath, x2, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize);
                } else if (mobility.equals("MP")) {
                    PathUtilties.addLine(mobilityPath, x2, bottomY, x2 + width, bottomY);
                    PathUtilties.addEllipse(mobilityPath, x2, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width / 2 - wheelSize / 2, bottomY + wheelOffset, wheelSize, wheelSize);
                } else if (mobility.equals("MQ")) {
                    PathUtilties.addRoundedRect(mobilityPath, x2, bottomY, width, rrHeight, rrHeight / 2, rrHeight);
                } else if (mobility.equals("MR")) {
                    PathUtilties.addRoundedRect(mobilityPath, x2, bottomY, width, rrHeight, wheelSize / 2, rrHeight);
                    PathUtilties.addEllipse(mobilityPath, x2 - wheelSize - wheelSize, bottomY, wheelSize, wheelSize);
                } else if (mobility.equals("MS")) {
                    PathUtilties.addLine(mobilityPath, x2 + wheelSize, bottomY + wheelSize / 2, x2 + width - wheelSize, bottomY + wheelSize / 2);
                    PathUtilties.addEllipse(mobilityPath, x2, bottomY, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width - wheelSize, bottomY, wheelSize, wheelSize);
                } else if (mobility.equals("MT")) {
                    PathUtilties.addLine(mobilityPath, x2, bottomY, x2 + width, bottomY);
                    PathUtilties.addEllipse(mobilityPath, x2 + wheelSize, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize);
                    PathUtilties.addEllipse(mobilityPath, x2 + width - wheelSize - wheelSize, bottomY + wheelOffset, wheelSize, wheelSize);
                } else if (mobility.equals("MU")) {
                    float halfWidth = (float)rrArcWidth * 0.5f;
                    mobilityPath.moveTo((float)x2, (float)bottomY);
                    mobilityPath.lineTo((float)x2 + halfWidth, (float)bottomY + halfWidth);
                    mobilityPath.lineTo((float)(x2 + width), (float)bottomY + halfWidth);
                } else if (mobility.equals("MV")) {
                    mobilityPath.moveTo((float)x2, (float)bottomY);
                    mobilityPath.cubicTo((float)x2, (float)bottomY, (float)(x2 - rrHeight), (float)(bottomY + rrHeight / 2), (float)x2, (float)(bottomY + rrHeight));
                    mobilityPath.lineTo((float)(x2 + width), (float)(bottomY + rrHeight));
                    mobilityPath.cubicTo((float)(x2 + width), (float)(bottomY + rrHeight), (float)(x2 + width + rrHeight), (float)(bottomY + rrHeight / 2), (float)(x2 + width), (float)bottomY);
                } else if (mobility.equals("MW")) {
                    centerX = Math.round(RectUtilities.getCenterX(symbolBounds));
                    int angleWidth = rrHeight / 2;
                    mobilityPath.moveTo((float)centerX, (float)(bottomY + rrHeight + 2));
                    mobilityPath.lineTo((float)(centerX - angleWidth), (float)bottomY);
                    mobilityPath.lineTo((float)(centerX - angleWidth * 2), (float)(bottomY + rrHeight + 2));
                    mobilityPath.moveTo((float)centerX, (float)(bottomY + rrHeight + 2));
                    mobilityPath.lineTo((float)(centerX + angleWidth), (float)bottomY);
                    mobilityPath.lineTo((float)(centerX + angleWidth * 2), (float)(bottomY + rrHeight + 2));
                } else if (mobility.equals("MX")) {
                    centerX = Math.round(RectUtilities.getCenterX(symbolBounds));
                    PathUtilties.addLine(mobilityPath, x2 + width, bottomY, x2, bottomY);
                    float quarterX = (centerX - x2) / 2;
                    mobilityPath.moveTo((float)x2, (float)bottomY);
                    mobilityPath.cubicTo((float)x2 + quarterX, (float)(bottomY + rrHeight), (float)centerX + quarterX, (float)(bottomY + rrHeight), (float)(x2 + width), (float)bottomY);
                } else if (mobility.equals("MY")) {
                    float incrementX = width / 7;
                    middleY = bottomY + rrHeight / 2;
                    x2 = Math.round((float)x2 + incrementX / 2.0f);
                    float r = Math.round(incrementX / 2.0f);
                    PathUtilties.arc(mobilityPath, x2, middleY, r, 180.0f, 180.0f);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX, middleY, r, 180.0f, -180.0f, false);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX * 2.0f, middleY, r, 180.0f, 180.0f, false);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX * 3.0f, middleY, r, 180.0f, -180.0f, false);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX * 4.0f, middleY, r, 180.0f, 180.0f, false);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX * 5.0f, middleY, r, 180.0f, -180.0f, false);
                    PathUtilties.arc(mobilityPath, (float)x2 + incrementX * 6.0f, middleY, r, 180.0f, 180.0f, false);
                }
            } else if (symbolID.charAt(10) == 'N') {
                int boxHeight = (int)((float)rrHeight * 0.8f + 0.5f);
                bottomY = y + height + boxHeight / 7;
                mobilityPathFill = new Path();
                offsetY = boxHeight / 7;
                centerX = Math.round(symbolBounds.left + (symbolBounds.right - symbolBounds.left) / 2);
                int squareOffset = Math.round((float)boxHeight * 0.5f);
                middleY = boxHeight / 2 + bottomY + offsetY;
                if (symbolID.substring(10, 12).equals("NS")) {
                    PathUtilties.addLine(mobilityPath, centerX - 1, bottomY - 1, centerX - 1, bottomY + boxHeight + offsetY);
                    PathUtilties.addLine(mobilityPath, x2, middleY, x2 + width, middleY);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(x2 - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(Math.round(centerX - squareOffset), bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(x2 + width - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                } else if (symbolID.substring(10, 12).equals("NL")) {
                    int leftX = x2 + (centerX - x2) / 2;
                    int rightX = centerX + (x2 + width - centerX) / 2;
                    PathUtilties.addLine(mobilityPath, leftX, bottomY - 1, leftX, bottomY + offsetY + boxHeight + offsetY);
                    PathUtilties.addLine(mobilityPath, rightX, bottomY - 1, rightX, bottomY + offsetY + boxHeight + offsetY);
                    PathUtilties.addLine(mobilityPath, x2, middleY, x2 + width, middleY);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(x2 - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(centerX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(x2 + width - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(leftX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                    mobilityPathFill.addRect(PathUtilties.makeRectF(rightX - squareOffset, bottomY + offsetY, boxHeight, boxHeight), Path.Direction.CW);
                }
            }
            if (mobilityPath != null) {
                mobilityBounds = new RectF();
                mobilityPath.computeBounds(mobilityBounds, true);
                RectF mobilityFillBounds = new RectF();
                if (mobilityPathFill != null) {
                    mobilityPathFill.computeBounds(mobilityFillBounds, true);
                    mobilityBounds.union(mobilityFillBounds);
                }
                mobilityBounds.set(mobilityBounds.left - 1.0f, mobilityBounds.top - 1.0f, mobilityBounds.right + 1.0f, mobilityBounds.bottom + 1.0f);
                imageBounds.union(RectUtilities.makeRectFromRectF(mobilityBounds));
            }
        }
        if ((strEchelon = SymbolUtilities.getEchelon(symbolID)) != null) {
            strEchelon = SymbolUtilities.getEchelonText(strEchelon);
        }
        if (strEchelon != null && !SymbolUtilities.hasInstallationModifier(symbolID) && SymbolUtilities.canUnitHaveModifier(symbolID, 2) && strEchelon != null) {
            int echelonOffset = 2;
            int outlineOffset = RS.getTextOutlineWidth();
            tiEchelon = new TextInfo(strEchelon, 0, 0, _modifierFont);
            echelonBounds = tiEchelon.getTextBounds();
            int y = Math.round(symbolBounds.left - echelonOffset);
            x = Math.round(symbolBounds.left + symbolBounds.width() / 2 - echelonBounds.width() / 2);
            tiEchelon.setLocation(x, y);
            tiEchelon.getTextOutlineBounds();
            RectUtilities.grow(echelonBounds, outlineOffset);
            tiEchelon.setLocation(x, y - outlineOffset);
            imageBounds.union(echelonBounds);
        }
        String affiliationModifier = null;
        if (!RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getUnitAffiliationModifier(symbolID, symStd);
        }
        if (affiliationModifier != null) {
            int y;
            int amOffset = 2;
            int outlineOffset = RS.getTextOutlineWidth();
            tiAM = new TextInfo(affiliationModifier, 0, 0, _modifierFont);
            amBounds = tiAM.getTextBounds();
            if (echelonBounds != null && echelonBounds.left + echelonBounds.width() > symbolBounds.left + symbolBounds.width()) {
                y = Math.round(symbolBounds.top - amOffset);
                x = echelonBounds.left + echelonBounds.width();
            } else {
                y = Math.round(symbolBounds.top - amOffset);
                x = Math.round(symbolBounds.left + symbolBounds.width());
            }
            tiAM.setLocation(x, y);
            RectUtilities.grow(amBounds, outlineOffset);
            RectUtilities.shift(amBounds, 0, -outlineOffset);
            tiAM.setLocation(x, y - outlineOffset);
            imageBounds.union(amBounds);
        }
        Rect tfBounds = null;
        Rect tfRectangle = null;
        if (SymbolUtilities.isTaskForce(symbolID) && SymbolUtilities.canUnitHaveModifier(symbolID, 4)) {
            if (echelonBounds != null) {
                tfRectangle = new Rect(echelonBounds.left, echelonBounds.top, echelonBounds.right, symbolBounds.top - 1);
                tfBounds = new Rect(tfRectangle);
            } else {
                int height = Math.round(symbolBounds.height() / 4);
                int width = Math.round(symbolBounds.width() / 3);
                tfRectangle = RectUtilities.makeRect(symbolBounds.left + width, symbolBounds.top - height, width, height);
                tfBounds = RectUtilities.makeRect(tfRectangle.left + -1, tfRectangle.top - 1, tfRectangle.width() + 2, tfRectangle.height() + 2);
            }
            imageBounds.union(tfBounds);
        }
        Rect fdiBounds = null;
        Point fdiTop = null;
        Point fdiLeft = null;
        Point fdiRight = null;
        if ((SymbolUtilities.isFeintDummy(symbolID) || SymbolUtilities.isFeintDummyInstallation(symbolID)) && SymbolUtilities.canUnitHaveModifier(symbolID, 30)) {
            fdiLeft = new Point(symbolBounds.left, symbolBounds.top);
            fdiRight = new Point(symbolBounds.left + symbolBounds.width(), symbolBounds.top);
            char affiliation = symbolID.charAt(1);
            fdiTop = affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' ? new Point(Math.round(RectUtilities.getCenterX(symbolBounds)), Math.round((float)symbolBounds.top - (float)symbolBounds.height() * 0.75f)) : new Point(Math.round(RectUtilities.getCenterX(symbolBounds)), Math.round((float)symbolBounds.top - (float)symbolBounds.height() * 0.54f));
            fdiBounds = RectUtilities.makeRect(fdiLeft.x, fdiLeft.y, 1, 1);
            fdiBounds.union(fdiTop.x, fdiTop.y);
            fdiBounds.union(fdiRight.x, fdiRight.y);
            if (echelonBounds != null) {
                int shiftY = Math.round(symbolBounds.top - echelonBounds.height() - 2);
                fdiLeft.offset(0, shiftY);
                fdiTop.offset(0, shiftY);
                fdiRight.offset(0, shiftY);
                fdiBounds.offset(0, shiftY);
            }
            imageBounds.union(fdiBounds);
        }
        Rect instRectangle = null;
        Rect instBounds = null;
        if (SymbolUtilities.hasInstallationModifier(symbolID) && SymbolUtilities.canUnitHaveModifier(symbolID, 31)) {
            int width;
            int height;
            char affiliation = SymbolUtilities.getAffiliation(symbolID);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K') {
                height = Math.round(symbolBounds.height() / 4);
                width = Math.round(symbolBounds.width() / 3);
            } else if (affiliation == 'H' || affiliation == 'S') {
                height = Math.round(symbolBounds.height() / 6);
                width = Math.round(symbolBounds.width() / 3);
            } else if (affiliation == 'N' || affiliation == 'L') {
                height = Math.round(symbolBounds.height() / 6);
                width = Math.round(symbolBounds.width() / 3);
            } else if (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W') {
                height = Math.round(symbolBounds.height() / 6);
                width = Math.round(symbolBounds.width() / 3);
            } else {
                height = Math.round(symbolBounds.height() / 6);
                width = Math.round(symbolBounds.width() / 3);
            }
            instRectangle = affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L' ? RectUtilities.makeRect(symbolBounds.left + width, symbolBounds.top - height, width, height) : (affiliation == 'H' || affiliation == 'S' ? RectUtilities.makeRect(symbolBounds.left + width, Math.round((float)symbolBounds.top - (float)height * 0.15f), width, height) : (affiliation == 'P' || affiliation == 'U' || affiliation == 'G' || affiliation == 'W' ? RectUtilities.makeRect(symbolBounds.left + width, Math.round((float)symbolBounds.top - (float)height * 0.3f), width, height) : RectUtilities.makeRect(symbolBounds.left + width, Math.round((float)symbolBounds.top - (float)height * 0.3f), width, height)));
            instBounds = new Rect(instRectangle.left + -1, instRectangle.top - 1, instRectangle.width() + 2, instRectangle.height() + 2);
            imageBounds.union(instBounds);
        }
        Point pt1HQ = null;
        Point pt2HQ = null;
        Rect hqBounds = null;
        if (SymbolUtilities.isHQ(symbolID) && SymbolUtilities.canUnitHaveModifier(symbolID, 20)) {
            char affiliation = symbolID.charAt(1);
            if (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'J' || affiliation == 'K' || affiliation == 'N' || affiliation == 'L') {
                pt1HQ = new Point(symbolBounds.left + 1, symbolBounds.top + symbolBounds.height() - 1);
                pt2HQ = new Point(pt1HQ.x, pt1HQ.y + symbolBounds.height());
            } else {
                pt1HQ = new Point(symbolBounds.left + 1, symbolBounds.top + symbolBounds.height() / 2);
                pt2HQ = new Point(pt1HQ.x, pt1HQ.y + symbolBounds.height());
            }
            hqBounds = new Rect(pt1HQ.x, pt1HQ.y, pt1HQ.x + 2, pt2HQ.y);
            imageBounds.union(hqBounds);
            centerPoint.set(pt2HQ.x, pt2HQ.y);
        }
        Point[] domPoints = null;
        Rect domBounds = null;
        if (modifiers.indexOfKey(17) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 17) && (strQ = (String)modifiers.get(17)) != null && SymbolUtilities.isNumber(strQ)) {
            float q = Float.valueOf(strQ).floatValue();
            boolean isY = modifiers.indexOfKey(27) >= 0;
            domPoints = ModifierRenderer.createDOMArrowPoints(symbolID, symbolBounds, symbolCenter, q, isY);
            domBounds = new Rect(domPoints[0].x, domPoints[0].y, 1, 1);
            Point temp = null;
            for (int i = 1; i < 6; ++i) {
                temp = domPoints[i];
                if (temp == null) continue;
                domBounds.union(temp.x, temp.y);
            }
            imageBounds.union(domBounds);
        }
        Rect ociBounds = null;
        RectF ociBoundsF = null;
        Rect ociShape = null;
        Path ociSlashShape = null;
        int ociOffset = 4;
        if (mobilityBounds != null) {
            ociOffset = Math.round(mobilityBounds.bottom - (float)symbolBounds.bottom) + 4;
        }
        if (RendererSettings.getInstance().getOperationalConditionModifierType() == RendererSettings.OperationalConditionModifierType_BAR) {
            ociShape = ModifierRenderer.processOperationalConditionIndicator(symbolID, symbolBounds, ociOffset);
            if (ociShape != null) {
                Rect temp = new Rect(ociShape);
                RectUtilities.grow(temp, 2);
                ociBounds = temp;
                imageBounds.union(ociBounds);
            }
        } else {
            ociSlashShape = ModifierRenderer.processOperationalConditionIndicatorSlash(symbolID, symbolBounds);
            if (ociSlashShape != null) {
                ociBoundsF = new RectF();
                ociBounds = new Rect();
                ociSlashShape.computeBounds(ociBoundsF, true);
                ociBoundsF.roundOut(ociBounds);
                imageBounds.union(ociBounds);
                ociBounds = null;
            }
        }
        if (imageBounds.left < 0 || imageBounds.top < 0) {
            int shiftX = Math.abs(imageBounds.left);
            int shiftY = Math.abs(imageBounds.top);
            if (hqBounds != null) {
                pt1HQ.offset(shiftX, shiftY);
                pt2HQ.offset(shiftX, shiftY);
            }
            if (echelonBounds != null) {
                tiEchelon.setLocation(tiEchelon.getLocation().x + shiftX, tiEchelon.getLocation().y + shiftY);
            }
            if (amBounds != null) {
                tiAM.setLocation(tiAM.getLocation().x + shiftX, tiAM.getLocation().y + shiftY);
            }
            if (tfBounds != null) {
                tfRectangle.offset(shiftX, shiftY);
                tfBounds.offset(shiftX, shiftY);
            }
            if (instBounds != null) {
                instRectangle.offset(shiftX, shiftY);
                instBounds.offset(shiftX, shiftY);
            }
            if (fdiBounds != null) {
                fdiBounds.offset(shiftX, shiftY);
                fdiLeft.offset(shiftX, shiftY);
                fdiTop.offset(shiftX, shiftY);
                fdiRight.offset(shiftX, shiftY);
            }
            if (ociBounds != null) {
                ociBounds.offset(shiftX, shiftY);
                ociShape.offset(shiftX, shiftY);
            }
            if (ociBoundsF != null) {
                ociBoundsF.offset((float)shiftX, (float)shiftY);
                ociSlashShape.offset((float)shiftX, (float)shiftY);
            }
            if (domBounds != null) {
                for (int i = 0; i < 6; ++i) {
                    Point temp = domPoints[i];
                    if (temp == null) continue;
                    temp.offset(shiftX, shiftY);
                }
                domBounds.offset(shiftX, shiftY);
            }
            if (mobilityBounds != null) {
                mobilityPath.offset((float)shiftX, (float)shiftY);
                if (mobilityPathFill != null) {
                    mobilityPathFill.offset((float)shiftX, (float)shiftY);
                }
                mobilityBounds.offset((float)shiftX, (float)shiftY);
            }
            centerPoint.offset(shiftX, shiftY);
            symbolBounds.offset(shiftX, shiftY);
            imageBounds.offset(shiftX, shiftY);
        }
        Bitmap bmp = Bitmap.createBitmap((int)imageBounds.width(), (int)imageBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas ctx = new Canvas(bmp);
        if (echelonBounds != null || amBounds != null) {
            // empty if block
        }
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(lineColor.toInt());
        if (alpha > -1) {
            paint.setAlpha(alpha);
        }
        paint.setStrokeWidth(2.0f);
        if (hqBounds != null) {
            ctx.drawLine((float)pt1HQ.x, (float)pt1HQ.y, (float)pt2HQ.x, (float)pt2HQ.y, paint);
        }
        if (tfBounds != null) {
            ctx.drawRect(tfRectangle, paint);
        }
        if (instBounds != null) {
            paint.setStyle(Paint.Style.FILL);
            ctx.drawRect(instRectangle, paint);
        }
        if (echelonBounds != null) {
            TextInfo[] aTiEchelon = new TextInfo[]{tiEchelon};
            ModifierRenderer.renderText(ctx, aTiEchelon, textColor, textBackgroundColor);
            echelonBounds = null;
            tiEchelon = null;
        }
        if (amBounds != null) {
            TextInfo[] aTiAM = new TextInfo[]{tiAM};
            ModifierRenderer.renderText(ctx, aTiAM, textColor, textBackgroundColor);
            amBounds = null;
            tiAM = null;
        }
        if (fdiBounds != null) {
            Paint fdiPaint = new Paint();
            fdiPaint.setAntiAlias(true);
            fdiPaint.setColor(lineColor.toInt());
            if (alpha > -1) {
                fdiPaint.setAlpha(alpha);
            }
            fdiPaint.setStyle(Paint.Style.STROKE);
            fdiPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 4.0f}, 0.0f));
            if (symbolBounds.width() > 19) {
                fdiPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 4.0f}, 0.0f));
            } else {
                fdiPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{5.0f, 3.0f}, 0.0f));
            }
            fdiPaint.setStrokeCap(Paint.Cap.BUTT);
            fdiPaint.setStrokeJoin(Paint.Join.MITER);
            fdiPaint.setStrokeWidth(2.0f);
            Path fdiPath = new Path();
            fdiPath.moveTo((float)fdiLeft.x, (float)fdiLeft.y);
            fdiPath.lineTo((float)fdiTop.x, (float)fdiTop.y);
            fdiPath.lineTo((float)fdiRight.x, (float)fdiRight.y);
            ctx.drawPath(fdiPath, fdiPaint);
            fdiBounds = null;
        }
        if (mobilityBounds != null) {
            Paint mobilityPaint = new Paint();
            mobilityPaint.setStyle(Paint.Style.STROKE);
            mobilityPaint.setColor(lineColor.toInt());
            if (alpha > -1) {
                mobilityPaint.setAlpha(alpha);
            }
            if (symbolID.charAt(10) == 'M') {
                mobilityPaint.setStrokeWidth(3.0f);
                mobilityPaint.setAntiAlias(true);
            } else {
                mobilityPaint.setStrokeWidth(3.0f);
            }
            ctx.drawPath(mobilityPath, mobilityPaint);
            if (mobilityPathFill != null) {
                mobilityPaint.setStyle(Paint.Style.FILL);
                ctx.drawPath(mobilityPathFill, mobilityPaint);
            }
            mobilityBounds = null;
        }
        if (ociBounds != null) {
            ociPaint = new Paint();
            int statusColor = 0;
            char status = symbolID.charAt(3);
            if (status == 'C') {
                statusColor = Color.green.toInt();
            } else if (status == 'D') {
                statusColor = Color.yellow.toInt();
            } else if (status == 'X') {
                statusColor = Color.red.toInt();
            } else if (status == 'F') {
                statusColor = Color.blue.toInt();
            }
            ociPaint.setColor(Color.black.toInt());
            ociPaint.setStyle(Paint.Style.FILL);
            if (alpha > -1) {
                ociPaint.setAlpha(alpha);
            }
            ctx.drawRect(ociBounds, ociPaint);
            ociPaint.setColor(statusColor);
            if (alpha > -1) {
                ociPaint.setAlpha(alpha);
            }
            ctx.drawRect(ociShape, ociPaint);
            ociBounds = null;
            ociShape = null;
        }
        ctx.drawBitmap(ii.getImage(), null, symbolBounds, null);
        if (domBounds != null) {
            ModifierRenderer.drawDOMArrow(ctx, domPoints, alpha, lineColor);
            domBounds = null;
            domPoints = null;
        }
        if (ociBoundsF != null) {
            ociPaint = new Paint();
            int size = symbolBounds.width();
            float ociStrokeWidth = 3.0f;
            ociStrokeWidth = (float)size / 20.0f;
            if (ociStrokeWidth < 1.0f) {
                ociStrokeWidth = 1.0f;
            }
            ociPaint.setColor(lineColor.toInt());
            if (alpha > -1) {
                ociPaint.setAlpha(alpha);
            }
            ociPaint.setStrokeWidth(ociStrokeWidth);
            ociPaint.setStrokeCap(Paint.Cap.BUTT);
            ociPaint.setStyle(Paint.Style.STROKE);
            ociPaint.setAntiAlias(true);
            ctx.drawPath(ociSlashShape, ociPaint);
            ociBoundsF = null;
            ociSlashShape = null;
        }
        if ((newii = new ImageInfo(bmp, centerPoint, symbolBounds)) != null) {
            return newii;
        }
        return null;
    }

    private static double getYPositionForSCC(String symbolID) {
        double yPosition = 0.32;
        String temp = symbolID.substring(4, 10);
        char affiliation = symbolID.charAt(1);
        if (temp.equals("WMGC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.29 : (affiliation == 'N' || affiliation == 'L' ? 0.32 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.32 : 0.34));
        } else if (temp.equals("WMMC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.25 : (affiliation == 'N' || affiliation == 'L' ? 0.25 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.25 : 0.28));
        } else if (temp.equals("WMFC--")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.29 : (affiliation == 'N' || affiliation == 'L' ? 0.32 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.32 : 0.34));
        } else if (temp.equals("WMC---")) {
            yPosition = affiliation == 'H' || affiliation == 'S' ? 0.33 : (affiliation == 'N' || affiliation == 'L' ? 0.36 : (affiliation == 'F' || affiliation == 'A' || affiliation == 'D' || affiliation == 'M' || affiliation == 'K' || affiliation == 'J' ? 0.36 : 0.36));
        }
        return yPosition;
    }

    private static Point[] createDOMArrowPoints(String symbolID, Rect bounds, Point center, float angle, boolean isY) {
        Point[] arrowPoints = new Point[6];
        Point pt1 = null;
        Point pt2 = null;
        Point pt3 = null;
        int length = 40;
        length = SymbolUtilities.isNBC(symbolID) ? Math.round(bounds.height() / 2) : bounds.height();
        int x1 = Math.round(center.x);
        int y1 = Math.round(center.y);
        pt1 = new Point(x1, y1);
        char scheme = symbolID.charAt(0);
        if (SymbolUtilities.isNBC(symbolID) || scheme == 'S' && symbolID.charAt(2) == 'G' || scheme == 'O' || scheme == 'E') {
            y1 = bounds.top + bounds.height();
            pt1 = new Point(x1, y1);
            if (isY && SymbolUtilities.isNBC(symbolID)) {
                int yModifierOffset = (int)_modifierFontHeight;
                pt1.offset(0, yModifierOffset += RS.getTextOutlineWidth());
            }
            pt2 = new Point(x1, y1 += length);
        }
        double radians = 0.0;
        radians = (double)(angle -= 90.0f) * (Math.PI / 180);
        int dx2 = x1 + (int)((double)length * Math.cos(radians));
        int dy2 = y1 + (int)((double)length * Math.sin(radians));
        int x2 = Math.round(dx2);
        int y2 = Math.round(dy2);
        float arrowWidth = 16.0f;
        float theta = 0.423f;
        if (length < 50) {
            theta = 0.55f;
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int[] vecLine = new int[2];
        int[] vecLeft = new int[2];
        xPoints[0] = x2;
        yPoints[0] = y2;
        vecLine[0] = xPoints[0] - x1;
        vecLine[1] = yPoints[0] - y1;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        double fLength = Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        double th = (double)arrowWidth / (2.0 * fLength);
        double ta = (double)arrowWidth / (2.0 * (Math.tan(theta) / 2.0) * fLength);
        double baseX = (double)xPoints[0] - ta * (double)vecLine[0];
        double baseY = (double)yPoints[0] - ta * (double)vecLine[1];
        xPoints[1] = (int)Math.round(baseX + th * (double)vecLeft[0]);
        yPoints[1] = (int)Math.round(baseY + th * (double)vecLeft[1]);
        xPoints[2] = (int)Math.round(baseX - th * (double)vecLeft[0]);
        yPoints[2] = (int)Math.round(baseY - th * (double)vecLeft[1]);
        pt3 = new Point((int)Math.round(baseX), (int)Math.round(baseY));
        arrowPoints[0] = pt1;
        arrowPoints[1] = pt2;
        arrowPoints[2] = pt3;
        arrowPoints[3] = new Point(xPoints[0], yPoints[0]);
        arrowPoints[4] = new Point(xPoints[1], yPoints[1]);
        arrowPoints[5] = new Point(xPoints[2], yPoints[2]);
        return arrowPoints;
    }

    private static void drawDOMArrow(Canvas ctx, Point[] domPoints, int alpha, Color lineColor) {
        Paint domPaint = new Paint();
        domPaint.setStrokeCap(Paint.Cap.BUTT);
        domPaint.setStrokeJoin(Paint.Join.MITER);
        domPaint.setStrokeWidth(3.0f);
        domPaint.setColor(lineColor.toInt());
        domPaint.setStyle(Paint.Style.STROKE);
        if (alpha > -1) {
            domPaint.setAlpha(alpha);
        }
        Path domPath = new Path();
        domPath.moveTo((float)domPoints[0].x, (float)domPoints[0].y);
        if (domPoints[1] != null) {
            domPath.lineTo((float)domPoints[1].x, (float)domPoints[1].y);
        }
        if (domPoints[2] != null) {
            domPath.lineTo((float)domPoints[2].x, (float)domPoints[2].y);
        }
        ctx.drawPath(domPath, domPaint);
        domPath.reset();
        domPaint.setStyle(Paint.Style.FILL);
        domPath.moveTo((float)domPoints[3].x, (float)domPoints[3].y);
        domPath.lineTo((float)domPoints[4].x, (float)domPoints[4].y);
        domPath.lineTo((float)domPoints[5].x, (float)domPoints[5].y);
        ctx.drawPath(domPath, domPaint);
    }

    private static Rect processOperationalConditionIndicator(String symbolID, Rect symbolBounds, int offsetY) {
        Rect bar = null;
        int barSize = 0;
        int pixelSize = symbolBounds.height();
        char status = symbolID.charAt(3);
        if (status == 'C' || status == 'D' || status == 'X' || status == 'F') {
            if (pixelSize > 0) {
                barSize = Math.round(pixelSize / 5);
            }
            if (barSize < 2) {
                barSize = 2;
            }
            bar = RectUtilities.makeRect(symbolBounds.left + 2, offsetY += Math.round(symbolBounds.top + symbolBounds.height()), Math.round(symbolBounds.width()) - 4, barSize);
        }
        return bar;
    }

    private static Path processOperationalConditionIndicatorSlash(String symbolID, Rect symbolBounds) {
        Path path = null;
        char status = symbolID.charAt(3);
        if (status == 'D' || status == 'X') {
            int fillCode = UnitFontLookup.getFillCode(symbolID, 1);
            float widthRatio = UnitFontLookup.getUnitRatioWidth(fillCode);
            float heightRatio = UnitFontLookup.getUnitRatioHeight(fillCode);
            float slashHeight = (float)symbolBounds.height() / heightRatio * 1.47f;
            float slashWidth = (float)symbolBounds.width() / widthRatio * 0.85f;
            float centerX = symbolBounds.exactCenterX();
            float centerY = symbolBounds.exactCenterY();
            path = new Path();
            if (status == 'D') {
                path.moveTo(centerX - slashWidth / 2.0f, centerY + slashHeight / 2.0f);
                path.lineTo(centerX + slashWidth / 2.0f, centerY - slashHeight / 2.0f);
            } else if (status == 'X') {
                path.moveTo(centerX - slashWidth / 2.0f, centerY + slashHeight / 2.0f);
                path.lineTo(centerX + slashWidth / 2.0f, centerY - slashHeight / 2.0f);
                path.moveTo(centerX - slashWidth / 2.0f, centerY - slashHeight / 2.0f);
                path.lineTo(centerX + slashWidth / 2.0f, centerY + slashHeight / 2.0f);
            }
            return path;
        }
        return path;
    }

    public static ImageInfo processUnitTextModifiers(ImageInfo ii, String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        int labelWidth;
        String text;
        int bufferXL = 5;
        int bufferXR = 5;
        int bufferY = 2;
        int bufferText = 2;
        int x = 0;
        int y = 0;
        int cpofNameX = 0;
        ImageInfo newii = null;
        int alpha = -1;
        Color textColor = Color.BLACK;
        Color textBackgroundColor = null;
        ArrayList<TextInfo> tiArray = new ArrayList<TextInfo>(modifiers.size());
        int descent = (int)((double)_modifierFontDescent + 0.5);
        int symStd = RS.getSymbologyStandard();
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        if (attributes.indexOfKey(6) >= 0) {
            alpha = Integer.parseInt((String)attributes.get(6));
        }
        Rect labelBounds = null;
        Rect bounds = new Rect(ii.getSymbolBounds());
        Rect symbolBounds = new Rect(ii.getSymbolBounds());
        Point centerPoint = new Point(ii.getCenterPoint());
        Rect imageBounds = new Rect(ii.getImageBounds());
        Rect imageBoundsOld = new Rect(ii.getImageBounds());
        String echelon = SymbolUtilities.getEchelon(symbolID);
        String echelonText = SymbolUtilities.getEchelonText(echelon);
        String amText = SymbolUtilities.getUnitAffiliationModifier(symbolID, symStd);
        if (modifiers.indexOfKey(17) < 0 || !SymbolUtilities.canUnitHaveModifier(symbolID, 17)) {
            bounds = RectUtilities.makeRect(imageBounds.left, symbolBounds.top, imageBounds.width(), symbolBounds.height());
        } else if (echelonText != null || amText != null) {
            bounds = RectUtilities.makeRect(imageBounds.left, bounds.top, imageBounds.width(), bounds.height());
        } else if (symbolID.substring(10, 12).equals("MR") && (x = -(Math.round((symbolBounds.width() - 1) / 7) * 2)) < bounds.left) {
            bounds.set(x, 0, bounds.right, bounds.bottom);
        }
        cpofNameX = bounds.left + bounds.width() + bufferXR;
        boolean byLabelHeight = false;
        int labelHeight = (int)((double)_modifierFontHeight + 0.5);
        int maxHeight = bounds.height();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        String affiliationModifier = null;
        if (RS.getDrawAffiliationModifierAsLabel()) {
            affiliationModifier = SymbolUtilities.getUnitAffiliationModifier(symbolID, symStd);
        }
        if (affiliationModifier != null) {
            modifiers.put(5, (Object)affiliationModifier);
        }
        if (SymbolUtilities.hasValidCountryCode(symbolID).booleanValue()) {
            modifiers.put(42, (Object)symbolID.substring(12, 14));
        }
        String modifierValue = null;
        TextInfo tiTemp = null;
        if (modifiers.indexOfKey(3) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 3) && (text = (String)modifiers.get(3)) != null) {
            tiTemp = new TextInfo(text, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = Math.round((float)symbolBounds.left + (float)symbolBounds.width() * 0.5f - (float)labelWidth * 0.5f);
            y = Math.round(symbolBounds.top - bufferY - descent);
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.indexOfKey(26) >= 0 || modifiers.indexOfKey(27) >= 0) {
            modifierValue = null;
            String xm = null;
            String ym = null;
            if (modifiers.indexOfKey(26) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 26)) {
                xm = (String)modifiers.get(26);
            }
            if (modifiers.indexOfKey(27) >= 0) {
                ym = (String)modifiers.get(27);
            }
            if (xm == null && ym != null) {
                modifierValue = ym;
            } else if (xm != null && ym == null) {
                modifierValue = xm;
            } else if (xm != null && ym != null) {
                modifierValue = xm + "  " + ym;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = labelBounds.width();
                if (!byLabelHeight) {
                    x = bounds.left - labelBounds.width() - bufferXL;
                    y = bounds.top + labelHeight - descent;
                } else {
                    x = bounds.left - labelBounds.width() - bufferXL;
                    y = bounds.height();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y -= labelHeight + bufferText;
                    y = bounds.top + y;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.indexOfKey(7) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 7) && (modifierValue = (String)modifiers.get(7)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = bounds.left + bounds.width() + bufferXR;
            if (!byLabelHeight) {
                y = bounds.top + labelHeight - descent;
            } else {
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= labelHeight + bufferText;
                y = bounds.top + y;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
            if (x + labelWidth + 3 > cpofNameX) {
                cpofNameX = x + labelWidth + 3;
            }
        }
        if (modifiers.indexOfKey(23) >= 0 || modifiers.indexOfKey(32) >= 0 || modifiers.indexOfKey(33) >= 0) {
            String vm = null;
            String adm = null;
            String aem = null;
            if (modifiers.indexOfKey(23) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 23)) {
                vm = (String)modifiers.get(23);
            }
            if (modifiers.indexOfKey(32) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 32)) {
                adm = (String)modifiers.get(32);
            }
            if (modifiers.indexOfKey(33) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 33)) {
                aem = (String)modifiers.get(33);
            }
            modifierValue = "";
            if (vm != null && !vm.equals("")) {
                modifierValue = vm;
            }
            if (adm != null && !adm.equals("")) {
                modifierValue = modifierValue + " " + adm;
            }
            if (aem != null && !aem.equals("")) {
                modifierValue = modifierValue + " " + aem;
            }
            if (modifierValue != null) {
                modifierValue = modifierValue.trim();
            }
            if (modifierValue != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = labelBounds.width();
                x = bounds.left - labelBounds.width() - bufferXL;
                y = bounds.height();
                y = (int)((float)y * 0.5f + (float)(labelHeight - descent) * 0.5f);
                y = bounds.top + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.indexOfKey(8) >= 0 || modifiers.indexOfKey(34) >= 0) {
            modifierValue = "";
            String hm = "";
            String afm = "";
            hm = (String)modifiers.get(8);
            if (modifiers.indexOfKey(8) >= 0) {
                hm = (String)modifiers.get(8);
            }
            if (modifiers.indexOfKey(34) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 34)) {
                afm = (String)modifiers.get(34);
            }
            modifierValue = hm + " " + afm;
            if ((modifierValue = modifierValue.trim()) != null && !modifierValue.equals("")) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = labelBounds.width();
                x = bounds.left + bounds.width() + bufferXR;
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
                y = bounds.top + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
                if (x + labelWidth + 3 > cpofNameX) {
                    cpofNameX = x + labelWidth + 3;
                }
            }
        }
        if (modifiers.indexOfKey(21) >= 0 && (modifierValue = (String)modifiers.get(21)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            if (!byLabelHeight) {
                x = bounds.left - labelWidth - bufferXL;
                y = bounds.top + bounds.height();
            } else {
                x = bounds.left - labelWidth - bufferXL;
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = bounds.top + y;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.indexOfKey(14) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 14) || modifiers.indexOfKey(42) >= 0) {
            modifierValue = "";
            if (modifiers.indexOfKey(14) >= 0) {
                modifierValue = modifierValue + (String)modifiers.get(14);
            }
            if (modifiers.indexOfKey(42) >= 0) {
                if (modifierValue.length() > 0) {
                    modifierValue = modifierValue + " ";
                }
                modifierValue = modifierValue + (String)modifiers.get(42);
            }
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = bounds.left + bounds.width() + bufferXR;
            if (!byLabelHeight) {
                y = bounds.top + bounds.height();
            } else {
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y += labelHeight + bufferText - descent;
                y = bounds.top + y;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
            if (x + labelWidth + 3 > cpofNameX) {
                cpofNameX = x + labelWidth + 3;
            }
        }
        if (modifiers.indexOfKey(28) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 28) && (modifierValue = (String)modifiers.get(28)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = bounds.left - labelWidth - bufferXL;
            if (!byLabelHeight) {
                y = Math.round(bounds.top + bounds.height() + labelHeight + bufferText);
            } else {
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round(bounds.top + y);
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.indexOfKey(11) >= 0 || modifiers.indexOfKey(12) >= 0 || modifiers.indexOfKey(13) >= 0 || modifiers.indexOfKey(15) >= 0 || modifiers.indexOfKey(16) >= 0) {
            modifierValue = null;
            String jm = null;
            String km = null;
            String lm = null;
            String nm = null;
            String pm = null;
            if (modifiers.indexOfKey(11) >= 0) {
                jm = (String)modifiers.get(11);
            }
            if (modifiers.indexOfKey(12) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 12)) {
                km = (String)modifiers.get(12);
            }
            if (modifiers.indexOfKey(13) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 13)) {
                lm = (String)modifiers.get(13);
            }
            if (modifiers.indexOfKey(15) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 15)) {
                nm = (String)modifiers.get(15);
            }
            if (modifiers.indexOfKey(16) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 16)) {
                pm = (String)modifiers.get(16);
            }
            modifierValue = "";
            if (jm != null && !jm.equals("")) {
                modifierValue = modifierValue + jm;
            }
            if (km != null && !km.equals("")) {
                modifierValue = modifierValue + " " + km;
            }
            if (lm != null && !lm.equals("")) {
                modifierValue = modifierValue + " " + lm;
            }
            if (nm != null && !nm.equals("")) {
                modifierValue = modifierValue + " " + nm;
            }
            if (pm != null && !pm.equals("")) {
                modifierValue = modifierValue + " " + pm;
            }
            if (modifierValue.length() > 2 && modifierValue.charAt(0) == ' ') {
                modifierValue = modifierValue.substring(1);
            }
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = bounds.left + bounds.width() + bufferXR;
            if (!byLabelHeight) {
                y = Math.round(bounds.top + bounds.height() + labelHeight + bufferText);
            } else {
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y = y + (labelHeight + bufferText) * 2 - descent * 2;
                y = Math.round(bounds.top + y);
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
            if (x + labelWidth + 3 > cpofNameX) {
                cpofNameX = x + labelWidth + 3;
            }
        }
        if (modifiers.indexOfKey(24) >= 0 && (modifierValue = (String)modifiers.get(24)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            if (!byLabelHeight) {
                x = bounds.left - labelWidth - bufferXL;
                y = bounds.top - bufferY - descent;
            } else {
                x = bounds.left - labelWidth - bufferXL;
                y = bounds.height();
                y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                y -= (labelHeight + bufferText) * 2;
                y = bounds.top + y;
            }
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.indexOfKey(6) >= 0 || modifiers.indexOfKey(5) >= 0) {
            modifierValue = null;
            String E = null;
            String F = null;
            if (modifiers.indexOfKey(5) >= 0) {
                E = (String)modifiers.get(5);
                modifiers.delete(5);
            }
            if (modifiers.indexOfKey(6) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 6)) {
                F = (String)modifiers.get(6);
            }
            if (E != null && !E.equals("")) {
                modifierValue = E;
            }
            if (F != null && !F.equals("")) {
                if (F.toUpperCase(Locale.US) == "R") {
                    F = "(+)";
                } else if (F.toUpperCase(Locale.US) == "D") {
                    F = "(-)";
                } else if (F.toUpperCase(Locale.US) == "RD") {
                    F = "(\u00b1)";
                }
            }
            if (F != null && !F.equals("")) {
                modifierValue = modifierValue != null && !modifierValue.equals("") ? modifierValue + " " + F : F;
            }
            if (modifierValue != null) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = labelBounds.width();
                if (!byLabelHeight) {
                    x = bounds.left + bounds.width() + bufferXR;
                    y = bounds.top - bufferY - descent;
                } else {
                    x = bounds.left + bounds.width() + bufferXR;
                    y = bounds.height();
                    y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
                    y -= (labelHeight + bufferText) * 2;
                    y = bounds.top + y;
                }
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
                if (x + labelWidth + 3 > cpofNameX) {
                    cpofNameX = x + labelWidth + 3;
                }
            }
        }
        if (modifiers.indexOfKey(29) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 29) && (modifierValue = (String)modifiers.get(29)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = (int)((float)symbolBounds.left + (float)symbolBounds.width() * 0.5f - (float)labelWidth * 0.5f);
            y = symbolBounds.height();
            y = (int)((double)y * 0.5 + (double)(labelHeight - descent) * 0.5);
            y = symbolBounds.top + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        if (modifiers.indexOfKey(50) >= 0 && SymbolUtilities.canUnitHaveModifier(symbolID, 50)) {
            boolean scc = false;
            modifierValue = (String)modifiers.get(50);
            if (modifierValue != null && SymbolUtilities.isNumber(modifierValue) && SymbolUtilities.hasModifier(symbolID, 50).booleanValue()) {
                tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
                labelBounds = tiTemp.getTextBounds();
                labelWidth = labelBounds.width();
                x = (int)((float)symbolBounds.left + (float)symbolBounds.width() * 0.5f - (float)labelWidth * 0.5f);
                double yPosition = ModifierRenderer.getYPositionForSCC(symbolID);
                y = bounds.height();
                y = (int)((double)y * yPosition + (double)(labelHeight - descent) * 0.5);
                y = bounds.top + y;
                tiTemp.setLocation(x, y);
                tiArray.add(tiTemp);
            }
        }
        if (modifiers.indexOfKey(60) >= 0 && (modifierValue = (String)modifiers.get(60)) != null) {
            tiTemp = new TextInfo(modifierValue, 0, 0, _modifierFont);
            labelBounds = tiTemp.getTextBounds();
            labelWidth = labelBounds.width();
            x = cpofNameX;
            y = bounds.height();
            y = (int)((double)y * 0.5 + (double)labelHeight * 0.5);
            y = bounds.top + y;
            tiTemp.setLocation(x, y);
            tiArray.add(tiTemp);
        }
        Rect modifierBounds = null;
        if (tiArray != null && tiArray.size() > 0) {
            modifierBounds = ((TextInfo)tiArray.get(0)).getTextOutlineBounds();
            int size = tiArray.size();
            TextInfo tempShape = null;
            for (int i = 1; i < size; ++i) {
                tempShape = (TextInfo)tiArray.get(i);
                modifierBounds.union(tempShape.getTextOutlineBounds());
            }
        }
        if (modifierBounds != null) {
            imageBounds.union(modifierBounds);
            if (imageBounds.left < 0 || imageBounds.top < 0) {
                int shiftX = Math.round(Math.abs(imageBounds.left));
                int shiftY = Math.round(Math.abs(imageBounds.top));
                int size = tiArray.size();
                TextInfo tempShape = null;
                for (int i = 0; i < size; ++i) {
                    tempShape = (TextInfo)tiArray.get(i);
                    tempShape.shift(shiftX, shiftY);
                }
                RectUtilities.shift(modifierBounds, shiftX, shiftY);
                centerPoint.offset(shiftX, shiftY);
                RectUtilities.shift(symbolBounds, shiftX, shiftY);
                RectUtilities.shift(imageBounds, shiftX, shiftY);
                RectUtilities.shift(imageBoundsOld, shiftX, shiftY);
            }
            Bitmap bmp = Bitmap.createBitmap((int)imageBounds.width(), (int)imageBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas ctx = new Canvas(bmp);
            ctx.drawBitmap(ii.getImage(), (float)imageBoundsOld.left, (float)imageBoundsOld.top, null);
            if (attributes.indexOfKey(13) >= 0) {
                textColor = SymbolUtilities.getColorFromHexString((String)attributes.get(13));
                if (alpha > -1) {
                    textColor.setAlpha(alpha);
                }
            }
            if (attributes.indexOfKey(14) >= 0) {
                textBackgroundColor = SymbolUtilities.getColorFromHexString((String)attributes.get(14));
                if (alpha > -1) {
                    textBackgroundColor.setAlpha(alpha);
                }
            }
            ModifierRenderer.renderText(ctx, tiArray, textColor, textBackgroundColor);
            newii = new ImageInfo(bmp, centerPoint, symbolBounds);
        }
        tiArray = null;
        tiTemp = null;
        imageBoundsOld = null;
        return newii;
    }

    public static ImageInfo ProcessTGSPWithSpecialModifierLayout(ImageInfo ii, String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes, Color lineColor) {
        int i;
        int bufferXL = 6;
        int bufferXR = 4;
        int bufferY = 2;
        int bufferText = 2;
        boolean centerOffset = true;
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        int symStd = RS.getSymbologyStandard();
        int outlineOffset = RS.getTextOutlineWidth();
        int labelHeight = 0;
        int labelWidth = 0;
        int alpha = -1;
        ImageInfo newii = null;
        Color textColor = lineColor;
        Color textBackgroundColor = null;
        ArrayList<TextInfo> arrMods = new ArrayList<TextInfo>();
        boolean duplicate = false;
        Rect bounds = new Rect(ii.getSymbolBounds());
        Rect symbolBounds = new Rect(ii.getSymbolBounds());
        Point centerPoint = new Point(ii.getCenterPoint());
        Rect imageBounds = new Rect(ii.getImageBounds());
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        if (attributes.indexOfKey(6) >= 0) {
            alpha = Integer.parseInt((String)attributes.get(6));
            textColor.setAlpha(alpha);
        }
        centerPoint = new Point(Math.round(ii.getCenterPoint().x), Math.round(ii.getCenterPoint().y));
        boolean byLabelHeight = false;
        labelHeight = (int)(_modifierFontHeight + 0.5f);
        int maxHeight = symbolBounds.height();
        if (labelHeight * 3 > maxHeight) {
            byLabelHeight = true;
        }
        int descent = (int)(_modifierFontDescent + 0.5f);
        int yForY = -1;
        Rect labelBounds1 = null;
        Rect labelBounds2 = null;
        String strText = "";
        String strText1 = "";
        String strText2 = "";
        TextInfo text1 = null;
        TextInfo text2 = null;
        String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
        outlineOffset = outlineOffset > 2 ? (outlineOffset - 1) / 2 : 0;
        if (basicID.equals("G*G*GPRD--****X")) {
            strText1 = "D";
            text1 = new TextInfo(strText1, 0, 0, _modifierFont);
            labelBounds1 = text1.getTextBounds();
            if (symStd == 0) {
                y = symbolBounds.top + symbolBounds.height();
                x = symbolBounds.left - labelBounds1.width() - bufferXL;
                text1.setLocation(Math.round(x), Math.round(y));
            } else {
                text1 = null;
            }
        } else if (basicID.equals("G*G*APU---****X")) {
            strText1 = "PUP";
            text1 = new TextInfo(strText1, 0, 0, _modifierFont);
            labelBounds1 = text1.getTextBounds();
            y = RectUtilities.getCenterY(symbolBounds) + (labelBounds1.height() - descent) / 2;
            x = symbolBounds.left + symbolBounds.width() + bufferXR;
            text1.setLocation(Math.round(x), Math.round(y));
        } else if (!basicID.equals("G*M*NZ----****X") && !basicID.equals("G*M*NF----****X")) {
            int offset;
            if (basicID.equals("G*M*NEB---****X")) {
                offset = 1;
                strText2 = "BIO";
                text2 = new TextInfo(strText2, 0, 0, _modifierFont);
                labelBounds2 = text2.getTextBounds();
                y2 = (int)((float)RectUtilities.getCenterY(symbolBounds) + (float)(labelBounds2.height() - descent) * 0.5f);
                x2 = symbolBounds.left - labelBounds2.width() - bufferXL;
                text2.setLocation(Math.round(x2), Math.round(y2 - offset));
            } else if (basicID.equals("G*M*NEC---****X")) {
                offset = 1;
                strText2 = "CML";
                text2 = new TextInfo(strText2, 0, 0, _modifierFont);
                labelBounds2 = text2.getTextBounds();
                y2 = RectUtilities.getCenterY(symbolBounds) + (labelBounds2.height() - descent) / 2;
                x2 = symbolBounds.left - labelBounds2.width() - bufferXL;
                text2.setLocation(Math.round(x2), Math.round(y2 - offset));
            }
        }
        if (text1 != null) {
            arrMods.add(text1);
        }
        if (text2 != null) {
            arrMods.add(text2);
        }
        TextInfo ti = null;
        if ((basicID.equals("G*M*NZ----****X") || basicID.equals("G*M*NEB---****X") || basicID.equals("G*M*NEC---****X")) && labelHeight * 3 > bounds.height()) {
            byLabelHeight = true;
        }
        if (basicID.equals("G*G*GPPC--****X") || basicID.equals("G*G*GPPD--****X")) {
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.4f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*G*GPH---****X")) {
            if (modifiers.indexOfKey(3) >= 0 && (strText = (String)modifiers.get(3)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*G*GPRI--****X")) {
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.25f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*G*GPPW--****X") || basicID.equals("G*F*PCF---****X")) {
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                x = bounds.left + (int)((float)bounds.width() * 0.75f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x), Math.round(y += (int)((float)(labelHeight - descent) * 0.5f)));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*G*APP---****X") || basicID.equals("G*G*APC---****X")) {
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = ti.getTextBounds().width();
                x = bounds.left + (int)((double)bounds.width() * 0.5);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                y = y + (int)(((float)bounds.height() * 0.5f - (float)labelHeight) / 2.0f) + labelHeight - descent;
                ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*G*DPT---****X") || basicID.equals("G*F*PTS---****X") || basicID.equals("G*F*PTN---****X")) {
            if (modifiers.indexOfKey(3) >= 0 && basicID.equals("G*F*PTS---****X") && (strText = (String)modifiers.get(3)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                x = RectUtilities.getCenterX(bounds) + (int)((float)bounds.width() * 0.15f);
                y = bounds.top + (int)((float)bounds.height() * 0.75f);
                ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(4) >= 0 && basicID.equals("G*F*PTS---****X") && (strText = (String)modifiers.get(4)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = RectUtilities.getCenterX(bounds) - (int)((float)bounds.width() * 0.15f);
                y = bounds.top + (int)((float)bounds.height() * 0.75f);
                ti.setLocation(Math.round(x -= labelWidth), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                x = RectUtilities.getCenterX(bounds) + (int)((float)bounds.width() * 0.15f);
                y = bounds.top + (int)((float)bounds.height() * 0.25f);
                ti.setLocation(Math.round(x), Math.round(y += (int)((float)labelHeight * 0.5f)));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*M*NZ----****X") || basicID.equals("G*M*NEB---****X") || basicID.equals("G*M*NEC---****X")) {
            if (modifiers.indexOfKey(6) >= 0 && (strText = (String)modifiers.get(6)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                x = bounds.left + bounds.width() + bufferXR;
                y = !byLabelHeight ? bounds.top + bounds.height() : bounds.top + (int)((double)((float)bounds.height() * 0.5f) + (double)(labelHeight - descent) * 0.5 + (double)(labelHeight - descent + bufferText));
                ti.setLocation(Math.round(x), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(3) >= 0 && (strText = (String)modifiers.get(3)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                x = bounds.left + bounds.width() + bufferXR;
                y = !byLabelHeight ? bounds.top + labelHeight - descent : bounds.top + (int)((double)((float)bounds.height() * 0.5f) - (double)(labelHeight - descent) * 0.5 + (double)(-descent - bufferText));
                ti.setLocation(Math.round(x), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(12) >= 0 && (strText = (String)modifiers.get(12)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left - labelWidth - bufferXL;
                y = !byLabelHeight ? bounds.top + labelHeight - descent : bounds.top + (int)((double)bounds.height() * 0.5 - (double)(labelHeight - descent) * 0.5 + (double)(-descent - bufferText));
                ti.setLocation(Math.round(x), Math.round(y));
                arrMods.add(ti);
            }
            if (basicID.equals("G*M*NZ----****X") && modifiers.indexOfKey(11) >= 0 && (strText = (String)modifiers.get(11)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left - labelWidth - bufferXL;
                y = bounds.top + (int)((double)bounds.height() * 0.5 + (double)(labelHeight - descent) * 0.5);
                ti.setLocation(Math.round(x), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left - labelWidth - bufferXL;
                y = !byLabelHeight ? bounds.top + bounds.height() : bounds.top + (int)((double)bounds.height() * 0.5 + (double)(labelHeight - descent) * 0.5 + (double)(labelHeight - descent + bufferText));
                ti.setLocation(Math.round(x), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(15) >= 0 && (strText = (String)modifiers.get(15)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = !byLabelHeight ? bounds.top + bounds.height() + labelHeight - descent + bufferY : bounds.top + (int)((double)bounds.height() * 0.5 + (double)(labelHeight - descent) * 0.5 + (double)((labelHeight + bufferText) * 2) - (double)descent);
                yForY = y + descent;
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(2) >= 0 && (strText = (String)modifiers.get(2)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((double)bounds.width() * 0.5);
                y = bounds.top - descent;
                ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                arrMods.add(ti);
            }
        } else if (basicID.equals("G*M*OFS---****X")) {
            if (modifiers.indexOfKey(3) >= 0 && (strText = (String)modifiers.get(3)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((double)bounds.width() * 0.5);
                y = bounds.top - descent;
                ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(12) >= 0 && (strText = (String)modifiers.get(12)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((double)bounds.width() * 0.5);
                y = bounds.top + bounds.height();
                ti.setLocation(Math.round(x -= (int)((double)labelWidth * 0.5)), Math.round(y += labelHeight));
                arrMods.add(ti);
            }
            if (modifiers.indexOfKey(6) >= 0 && (strText = (String)modifiers.get(6)) != null) {
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                TextInfo ti2 = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + bounds.width() + bufferXR;
                duplicate = true;
                x2 = bounds.left;
                x2 = x2 - labelWidth - bufferXL;
                y = bounds.top + (int)((double)bounds.height() * 0.5);
                y2 = y += (int)((double)(labelHeight - descent) * 0.5);
                ti.setLocation(Math.round(x), Math.round(y));
                ti2.setLocation(Math.round(x2), Math.round(y2));
                arrMods.add(ti);
                arrMods.add(ti2);
            }
        } else if (basicID.charAt(0) == 'W') {
            String modX = null;
            if (modifiers.indexOfKey(14) > -1) {
                modX = (String)modifiers.get(14);
            }
            if (basicID.equals("WAS-WSF-LVP----")) {
                strText = "0\u00b0:";
                strText = modX != null ? strText + modX : strText + "?";
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)(((float)labelHeight - _modifierFontDescent) * 0.5f)));
                arrMods.add(ti);
            } else if (basicID.equals("WAS-WST-LVP----")) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)(((float)labelHeight - _modifierFontDescent) * 0.5f)));
                arrMods.add(ti);
            } else if (basicID.equals("WAS-PLT---P----")) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y -= descent));
                arrMods.add(ti);
            } else if (basicID.equals("WAS-PHT---P----")) {
                strText = "X?";
                if (modX != null) {
                    strText = modX;
                }
                ti = new TextInfo(strText, 0, 0, _modifierFont);
                labelWidth = Math.round(ti.getTextBounds().width());
                x = bounds.left + (int)((float)bounds.width() * 0.5f);
                y = bounds.top + (int)((float)bounds.height() * 0.5f);
                ti.setLocation(Math.round(x -= (int)((float)labelWidth * 0.5f)), Math.round(y += (int)((float)labelHeight * 0.5f - (float)(labelHeight / 2) + (float)labelHeight - (float)descent)));
                arrMods.add(ti);
            }
        }
        Point[] domPoints = null;
        Rect domBounds = null;
        if (modifiers.indexOfKey(7) >= 0 && (basicID.equals("G*M*NZ----****X") || basicID.equals("G*M*NEB---****X") || basicID.equals("G*M*NEC---****X")) && (strText = (String)modifiers.get(7)) != null && SymbolUtilities.isNumber(strText)) {
            float q = Float.parseFloat(strText);
            Rect tempBounds = new Rect(bounds);
            tempBounds.union(RectUtilities.getCenterX(bounds), yForY);
            domPoints = ModifierRenderer.createDOMArrowPoints(symbolID, tempBounds, ii.getCenterPoint(), q, false);
            domBounds = RectUtilities.makeRect(domPoints[0].x, domPoints[0].y, 1, 1);
            Point temp = null;
            for (i = 1; i < 6; ++i) {
                temp = domPoints[i];
                if (temp == null) continue;
                domBounds.union(temp.x, temp.y);
            }
            imageBounds.union(domBounds);
        }
        Rect modifierBounds = null;
        if (arrMods != null && arrMods.size() > 0) {
            modifierBounds = ((TextInfo)arrMods.get(0)).getTextOutlineBounds();
            int size = arrMods.size();
            TextInfo tempShape = null;
            for (i = 1; i < size; ++i) {
                tempShape = (TextInfo)arrMods.get(i);
                modifierBounds.union(tempShape.getTextOutlineBounds());
            }
        }
        if (modifierBounds != null || domBounds != null) {
            if (modifierBounds != null) {
                imageBounds.union(modifierBounds);
            }
            if (domBounds != null) {
                imageBounds.union(domBounds);
            }
            if (imageBounds.left < 0 || imageBounds.top < 0) {
                int i2;
                int shiftX = Math.abs(imageBounds.left);
                int shiftY = Math.abs(imageBounds.top);
                int size = arrMods.size();
                TextInfo tempShape = null;
                for (i2 = 0; i2 < size; ++i2) {
                    tempShape = (TextInfo)arrMods.get(i2);
                    tempShape.shift(shiftX, shiftY);
                }
                modifierBounds.offset(shiftX, shiftY);
                if (domBounds != null) {
                    for (i2 = 0; i2 < 6; ++i2) {
                        Point temp = domPoints[i2];
                        if (temp == null) continue;
                        temp.offset(shiftX, shiftY);
                    }
                    domBounds.offset(shiftX, shiftY);
                }
                centerPoint.offset(shiftX, shiftY);
                symbolBounds.offset(shiftX, shiftY);
                imageBounds.offset(shiftX, shiftY);
            }
            Bitmap bmp = Bitmap.createBitmap((int)imageBounds.width(), (int)imageBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas ctx = new Canvas(bmp);
            ctx.drawBitmap(ii.getImage(), (float)symbolBounds.left, (float)symbolBounds.top, null);
            if (attributes.indexOfKey(13) >= 0) {
                textColor = SymbolUtilities.getColorFromHexString((String)attributes.get(13));
                if (alpha > -1) {
                    textColor.setAlpha(alpha);
                }
            }
            if (attributes.indexOfKey(14) >= 0) {
                textBackgroundColor = SymbolUtilities.getColorFromHexString((String)attributes.get(14));
                if (alpha > -1) {
                    textBackgroundColor.setAlpha(alpha);
                }
            }
            ModifierRenderer.renderText(ctx, arrMods, textColor, textBackgroundColor);
            newii = new ImageInfo(bmp, centerPoint, symbolBounds);
            if (domBounds != null) {
                ModifierRenderer.drawDOMArrow(ctx, domPoints, alpha, lineColor);
            }
            newii = new ImageInfo(bmp, centerPoint, symbolBounds);
            ctx = null;
            return newii;
        }
        return null;
    }

    public static ImageInfo ProcessTGSPModifiers(ImageInfo ii, String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes, Color lineColor) {
        int maxHeight;
        int bufferXL = 6;
        int bufferXR = 4;
        int bufferY = 2;
        int bufferText = 2;
        boolean centerOffset = true;
        int x = 0;
        int y = 0;
        boolean x2 = false;
        boolean y2 = false;
        int symStd = RS.getSymbologyStandard();
        int outlineOffset = RS.getTextOutlineWidth();
        int labelHeight = 0;
        int labelWidth = 0;
        int alpha = -1;
        ImageInfo newii = null;
        Color textColor = lineColor;
        Color textBackgroundColor = null;
        ArrayList<TextInfo> arrMods = new ArrayList<TextInfo>();
        boolean duplicate = false;
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        if (attributes.indexOfKey(6) >= 0) {
            alpha = Integer.parseInt((String)attributes.get(6));
        }
        Rect bounds = new Rect(ii.getSymbolBounds());
        Rect symbolBounds = new Rect(ii.getSymbolBounds());
        Point centerPoint = new Point(ii.getCenterPoint());
        Rect imageBounds = new Rect(ii.getImageBounds());
        centerPoint = new Point(Math.round(ii.getCenterPoint().x), Math.round(ii.getCenterPoint().y));
        boolean byLabelHeight = false;
        labelHeight = Math.round(_modifierFontHeight + 0.5f);
        if (labelHeight * 3 > (maxHeight = symbolBounds.height())) {
            byLabelHeight = true;
        }
        int descent = (int)(_modifierFontDescent + 0.5f);
        int yForY = -1;
        Object labelBounds1 = null;
        Object labelBounds2 = null;
        String strText = "";
        String strText1 = "";
        String strText2 = "";
        Object text1 = null;
        Object text2 = null;
        String basicID = SymbolUtilities.getBasicSymbolID(symbolID);
        outlineOffset = outlineOffset > 2 ? (outlineOffset - 1) / 2 : 0;
        TextInfo ti = null;
        if (modifiers.indexOfKey(6) >= 0 && (strText = (String)modifiers.get(6)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            x = bounds.left + bounds.width() + bufferXR;
            if (!byLabelHeight) {
                y = bounds.height() / 3 * 2;
                y = bounds.top + y;
            } else {
                y = bounds.top + bounds.height();
            }
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(3) >= 0 && (strText = (String)modifiers.get(3)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            labelWidth = Math.round(ti.getTextBounds().width());
            x = bounds.left + (int)((float)bounds.width() * 0.5f);
            y = bounds.top - descent;
            ti.setLocation(x -= (int)((float)labelWidth * 0.5f), y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(4) >= 0 && (strText = (String)modifiers.get(4)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            labelWidth = Math.round(ti.getTextBounds().width());
            x = bounds.left + (int)((double)bounds.width() * 0.5);
            y = bounds.top + labelHeight + (int)((double)bounds.height() * 0.2);
            ti.setLocation(x -= (int)((double)labelWidth * 0.5), y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(12) >= 0 && (strText = (String)modifiers.get(12)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            labelWidth = Math.round(ti.getTextBounds().width());
            x = bounds.left - labelWidth - bufferXL;
            y = bounds.top + labelHeight - descent;
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(13) >= 0 && (strText = (String)modifiers.get(13)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            labelWidth = Math.round(ti.getTextBounds().width());
            x = bounds.left - labelWidth - bufferXL;
            y = (labelHeight - descent + bufferText) * 2;
            y = bounds.top + y;
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(9) >= 0 && (strText = (String)modifiers.get(9)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            x = bounds.left + bounds.width() + bufferXR;
            y = bounds.top + labelHeight - descent;
            ti.setLocation(x, y);
            arrMods.add(ti);
        }
        if (modifiers.indexOfKey(10) >= 0 && (basicID.equals("G*O*ES----****X") || basicID.equals("G*S*PP----****X") || basicID.equals("G*S*PX----****X")) && (strText = (String)modifiers.get(10)) != null) {
            ti = new TextInfo(strText, 0, 0, _modifierFont);
            labelWidth = Math.round(ti.getTextBounds().width());
            x = bounds.left + (int)((double)bounds.width() * 0.5);
            y = (int)((double)bounds.height() * 0.6);
            y = bounds.top + y;
            ti.setLocation(x -= (int)((double)labelWidth * 0.5), y);
            arrMods.add(ti);
        }
        Rect modifierBounds = null;
        if (arrMods != null && arrMods.size() > 0) {
            modifierBounds = ((TextInfo)arrMods.get(0)).getTextOutlineBounds();
            int size = arrMods.size();
            TextInfo tempShape = null;
            for (int i = 1; i < size; ++i) {
                tempShape = (TextInfo)arrMods.get(i);
                modifierBounds.union(tempShape.getTextOutlineBounds());
            }
        }
        if (modifierBounds != null) {
            imageBounds.union(modifierBounds);
            if (imageBounds.left < 0 || imageBounds.top < 0) {
                int shiftX = Math.abs(imageBounds.left);
                int shiftY = Math.abs(imageBounds.top);
                int size = arrMods.size();
                TextInfo tempShape = null;
                for (int i = 0; i < size; ++i) {
                    tempShape = (TextInfo)arrMods.get(i);
                    tempShape.shift(shiftX, shiftY);
                }
                modifierBounds.offset(shiftX, shiftY);
                centerPoint.offset(shiftX, shiftY);
                symbolBounds.offset(shiftX, shiftY);
                imageBounds.offset(shiftX, shiftY);
            }
            Bitmap bmp = Bitmap.createBitmap((int)imageBounds.width(), (int)imageBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas ctx = new Canvas(bmp);
            ctx.drawBitmap(ii.getImage(), (float)symbolBounds.left, (float)symbolBounds.top, null);
            if (attributes.indexOfKey(13) >= 0) {
                textColor = SymbolUtilities.getColorFromHexString((String)attributes.get(13));
                if (alpha > -1) {
                    textColor.setAlpha(alpha);
                }
            }
            if (attributes.indexOfKey(14) >= 0) {
                textBackgroundColor = SymbolUtilities.getColorFromHexString((String)attributes.get(14));
                if (alpha > -1) {
                    textBackgroundColor.setAlpha(alpha);
                }
            }
            ModifierRenderer.renderText(ctx, arrMods, textColor, textBackgroundColor);
            newii = new ImageInfo(bmp, centerPoint, symbolBounds);
            ctx = null;
        }
        return newii;
    }

    private static void renderText(Canvas ctx, ArrayList<TextInfo> tiArray, Color color, Color backgroundColor) {
        ModifierRenderer.renderText(ctx, tiArray.toArray(new TextInfo[0]), color, backgroundColor);
    }

    public static void renderText(Canvas ctx, TextInfo[] tiArray, Color color, Color backgroundColor) {
        block14: {
            int tbm;
            int size;
            block16: {
                TextInfo textInfo;
                Color outlineColor;
                block15: {
                    TextInfo textInfo2;
                    int outlineWidth;
                    block13: {
                        TextInfo textInfo3;
                        size = tiArray.length;
                        tbm = RS.getTextBackgroundMethod();
                        outlineWidth = RS.getTextOutlineWidth();
                        if (color != null) {
                            _modifierFont.setColor(color.toInt());
                        } else {
                            _modifierFont.setColor(Color.BLACK.toInt());
                        }
                        outlineColor = null;
                        outlineColor = backgroundColor != null ? backgroundColor : RendererUtilities.getIdealOutlineColor(color);
                        if (tbm != 3) break block13;
                        _modifierFont.setStyle(Paint.Style.FILL);
                        _modifierFont.setStrokeWidth((float)RS.getTextOutlineWidth());
                        _modifierFont.setColor(outlineColor.toInt());
                        if (outlineWidth > 0) {
                            for (int i = 0; i < size; ++i) {
                                textInfo3 = tiArray[i];
                                if (outlineWidth <= 0) continue;
                                for (int j = 1; j <= outlineWidth; ++j) {
                                    if (j % 2 == 1) {
                                        ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x - j), (float)textInfo3.getLocation().y, _modifierFont);
                                        ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x + j), (float)textInfo3.getLocation().y, _modifierFont);
                                        ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x - j), (float)(textInfo3.getLocation().y + j), _modifierFont);
                                        ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x - j), (float)(textInfo3.getLocation().y - j), _modifierFont);
                                        continue;
                                    }
                                    ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x - j), (float)(textInfo3.getLocation().y - j), _modifierFont);
                                    ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x + j), (float)(textInfo3.getLocation().y - j), _modifierFont);
                                    ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x - j), (float)(textInfo3.getLocation().y + j), _modifierFont);
                                    ctx.drawText(textInfo3.getText(), (float)(textInfo3.getLocation().x + j), (float)(textInfo3.getLocation().y + j), _modifierFont);
                                }
                            }
                        }
                        _modifierFont.setColor(color.toInt());
                        for (int j = 0; j < size; ++j) {
                            textInfo3 = tiArray[j];
                            ctx.drawText(textInfo3.getText(), (float)textInfo3.getLocation().x, (float)textInfo3.getLocation().y, _modifierFont);
                        }
                        break block14;
                    }
                    if (tbm != 2) break block15;
                    _modifierFont.setStyle(Paint.Style.STROKE);
                    _modifierFont.setStrokeWidth((float)RS.getTextOutlineWidth());
                    _modifierFont.setColor(outlineColor.toInt());
                    if (outlineWidth > 0) {
                        for (int i = 0; i < size; ++i) {
                            textInfo2 = tiArray[i];
                            ctx.drawText(textInfo2.getText(), (float)textInfo2.getLocation().x, (float)textInfo2.getLocation().y, _modifierFont);
                        }
                    }
                    _modifierFont.setColor(color.toInt());
                    _modifierFont.setStyle(Paint.Style.FILL);
                    for (int j = 0; j < size; ++j) {
                        textInfo2 = tiArray[j];
                        ctx.drawText(textInfo2.getText(), (float)textInfo2.getLocation().x, (float)textInfo2.getLocation().y, _modifierFont);
                    }
                    break block14;
                }
                if (tbm != 1) break block16;
                Paint rectFill = new Paint();
                rectFill.setStyle(Paint.Style.FILL);
                rectFill.setColor(outlineColor.toARGB());
                for (int k = 0; k < size; ++k) {
                    textInfo = tiArray[k];
                    ctx.drawRect(textInfo.getTextOutlineBounds(), rectFill);
                }
                _modifierFont.setColor(color.toInt());
                _modifierFont.setStyle(Paint.Style.FILL);
                for (int j = 0; j < size; ++j) {
                    textInfo = tiArray[j];
                    ctx.drawText(textInfo.getText(), (float)textInfo.getLocation().x, (float)textInfo.getLocation().y, _modifierFont);
                }
                break block14;
            }
            if (tbm != 0) break block14;
            _modifierFont.setColor(color.toInt());
            _modifierFont.setStyle(Paint.Style.FILL);
            for (int j = 0; j < size; ++j) {
                TextInfo textInfo = tiArray[j];
                ctx.drawText(textInfo.getText(), (float)textInfo.getLocation().x, (float)textInfo.getLocation().y, _modifierFont);
            }
        }
    }

    public static boolean hasDisplayModifiers(String symbolID, SparseArray<String> modifiers) {
        boolean hasModifiers = false;
        char scheme = symbolID.charAt(0);
        char status = symbolID.charAt(3);
        char affiliation = symbolID.charAt(1);
        if (scheme != 'W') {
            if (scheme != 'G' && !SymbolUtilities.isEMSNaturalEvent(symbolID)) {
                switch (status) {
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'X': {
                        hasModifiers = true;
                    }
                }
                if (!symbolID.substring(10, 12).equals("--") && !symbolID.substring(10, 12).equals("**") || modifiers.indexOfKey(17) >= 0) {
                    hasModifiers = true;
                }
                if (SymbolUtilities.isHQ(symbolID)) {
                    hasModifiers = true;
                }
            } else if (SymbolUtilities.isNBC(symbolID) && modifiers.indexOfKey(7) >= 0) {
                hasModifiers = true;
            }
        }
        return hasModifiers;
    }

    public static boolean hasTextModifiers(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        char scheme;
        int symStd = RS.getSymbologyStandard();
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        if ((scheme = symbolID.charAt(0)) == 'W') {
            return symbolID.equals("WAS-WSF-LVP----") || symbolID.equals("WAS-PHT---P----") || symbolID.equals("WAS-PLT---P----") || symbolID.equals("WAS-WST-LVP----");
        }
        if (scheme == 'G') {
            if (modifiers.indexOfKey(7) >= 0 ? modifiers.size() > 1 : modifiers.size() > 0) {
                return true;
            }
        } else if (!SymbolUtilities.isEMSNaturalEvent(symbolID)) {
            if (SymbolUtilities.getUnitAffiliationModifier(symbolID, symStd) != null) {
                return true;
            }
            if (SymbolUtilities.hasValidCountryCode(symbolID).booleanValue()) {
                return true;
            }
            if (SymbolUtilities.isEMSNaturalEvent(symbolID)) {
                return false;
            }
            if (modifiers.indexOfKey(17) >= 0 ? modifiers.size() > 1 : modifiers.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

