/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c2sd.renderer;

import android.util.Log;
import android.util.SparseArray;
import armyc2.c2sd.renderer.SinglePointRenderer;
import armyc2.c2sd.renderer.SinglePointSVGRenderer;
import armyc2.c2sd.renderer.TacticalGraphicIconRenderer;
import armyc2.c2sd.renderer.utilities.Color;
import armyc2.c2sd.renderer.utilities.ErrorLogger;
import armyc2.c2sd.renderer.utilities.FontManager;
import armyc2.c2sd.renderer.utilities.ImageInfo;
import armyc2.c2sd.renderer.utilities.RendererSettings;
import armyc2.c2sd.renderer.utilities.SinglePointLookup;
import armyc2.c2sd.renderer.utilities.SymbolDef;
import armyc2.c2sd.renderer.utilities.SymbolDefTable;
import armyc2.c2sd.renderer.utilities.SymbolUtilities;
import armyc2.c2sd.renderer.utilities.TacticalGraphicLookup;
import armyc2.c2sd.renderer.utilities.UnitDef;
import armyc2.c2sd.renderer.utilities.UnitDefTable;
import armyc2.c2sd.renderer.utilities.UnitFontLookup;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class MilStdIconRenderer {
    private String TAG = "MilStdIconRenderer";
    private String _cacheDir = null;
    private static MilStdIconRenderer _instance = null;
    private AtomicBoolean _initSucces = new AtomicBoolean(false);
    private SinglePointRenderer _SPR = null;
    private SinglePointSVGRenderer _SPSVGR = null;

    public static synchronized MilStdIconRenderer getInstance() {
        if (_instance == null) {
            _instance = new MilStdIconRenderer();
        }
        return _instance;
    }

    public synchronized void init(String cacheDir) {
        try {
            if (!this._initSucces.get()) {
                this._cacheDir = cacheDir;
                FontManager.getInstance().init(cacheDir);
                String unitcontantsb = this.getXML("unitconstantsb.xml");
                String unitconstantsc = this.getXML("unitconstantsc.xml");
                String symbolconstantsb = this.getXML("symbolconstantsb.xml");
                String singlepointmappingsb = this.getXML("singlepointb.xml");
                String symbolconstantsc = this.getXML("symbolconstantsc.xml");
                String singlepointmappingsc = this.getXML("singlepointc.xml");
                String tacticalgraphics = this.getXML("tacticalgraphics.xml");
                String unitfontmappingsb = this.getXML("unitfontmappingsb.xml");
                String unitfontmappingsc = this.getXML("unitfontmappingsc.xml");
                String[] unitConstants = new String[]{unitcontantsb, unitconstantsc};
                String[] unitMappings = new String[]{unitfontmappingsb, unitfontmappingsc};
                String[] symbolConstants = new String[]{symbolconstantsb, symbolconstantsc};
                String[] symbolMappings = new String[]{singlepointmappingsb, singlepointmappingsc};
                UnitDefTable.getInstance().init(unitConstants);
                UnitFontLookup.getInstance().init(unitMappings);
                SymbolDefTable.getInstance().init(symbolConstants);
                SinglePointLookup.getInstance().init(symbolMappings);
                TacticalGraphicLookup.getInstance().init(tacticalgraphics);
                this._SPR = SinglePointRenderer.getInstance();
                this._initSucces.set(true);
            }
        }
        catch (Exception exc) {
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
        }
    }

    public synchronized boolean isReady() {
        return this._initSucces.get();
    }

    private String getXML(String xmlName) {
        String xmlFolder = "res/raw/";
        String xml = null;
        Object tf = null;
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(xmlFolder + xmlName);
            if (is != null) {
                String line;
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader r = new BufferedReader(isr);
                StringBuilder total = new StringBuilder();
                while ((line = r.readLine()) != null) {
                    total.append(line);
                }
                xml = total.toString();
                r.close();
                isr.close();
                is.close();
                r = null;
                isr = null;
                is = null;
                total = null;
            }
        }
        catch (Exception exc) {
            Log.e((String)this.TAG, (String)exc.getMessage(), (Throwable)exc);
        }
        return xml;
    }

    public Boolean CanRender(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        String temp;
        String message = null;
        String basicSymbolID = symbolID;
        basicSymbolID = SymbolUtilities.getBasicSymbolID(basicSymbolID);
        int symStd = -1;
        if (attributes.indexOfKey(11) >= 0 && SymbolUtilities.isNumber(temp = (String)attributes.get(11))) {
            symStd = Integer.parseInt(temp);
        }
        if (symStd < 0 || symStd > 1) {
            symStd = RendererSettings.getInstance().getSymbologyStandard();
        }
        try {
            SymbolDefTable sdt = SymbolDefTable.getInstance();
            if (SymbolUtilities.isTacticalGraphic(basicSymbolID)) {
                SymbolDef sd = sdt.getSymbolDef(basicSymbolID, symStd);
                if (sd != null) {
                    if (sd.getDrawCategory() == 8) {
                        int index = -1;
                        index = SinglePointLookup.getInstance().getCharCodeFromSymbol(symbolID, symStd);
                        if (index > 0) {
                            return true;
                        }
                        message = "Bad font lookup for: " + symbolID + " (" + basicSymbolID + ")";
                    } else {
                        message = "Cannot draw: " + symbolID + " (" + basicSymbolID + ")";
                    }
                } else {
                    message = "Cannot draw symbolID: " + symbolID + " (" + basicSymbolID + ")";
                }
            } else {
                UnitDef ud = UnitDefTable.getInstance().getUnitDef(basicSymbolID, symStd);
                if (ud != null) {
                    return true;
                }
                message = "JavaRenderer.CanRender() - Cannot draw symbolID: " + symbolID + " (" + basicSymbolID + ")";
            }
            if (message != null && !message.equals("")) {
                ErrorLogger.LogMessage(this.getClass().getName(), "CanRender()", message, Level.FINE);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "CanRender", exc);
        }
        return false;
    }

    private ImageInfo renderTacticalMultipointIcon(String symbolID, SparseArray<String> attributes) {
        Color lineColor = SymbolUtilities.getLineColorOfAffiliation(symbolID);
        if (attributes.indexOfKey(0) >= 0) {
            lineColor = new Color((String)attributes.get(0));
        }
        int size = RendererSettings.getInstance().getDefaultPixelSize();
        if (attributes.indexOfKey(3) >= 0) {
            size = Integer.parseInt((String)attributes.get(3));
        }
        int symStd = RendererSettings.getInstance().getSymbologyStandard();
        if (attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        ImageInfo ii = TacticalGraphicIconRenderer.getIcon(symbolID, size, lineColor, symStd);
        return ii;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageInfo RenderIcon(String symbolID, SparseArray<String> modifiers, SparseArray<String> attributes) {
        int symStd = 1;
        if (attributes != null && attributes.indexOfKey(11) >= 0) {
            symStd = Integer.parseInt((String)attributes.get(11));
        }
        ImageInfo temp = null;
        if (!SymbolUtilities.isTacticalGraphic(symbolID)) return this._SPR.RenderUnit(symbolID, modifiers, attributes);
        String basicSymbolID = SymbolUtilities.getBasicSymbolIDStrict(symbolID);
        SymbolDef sd = SymbolDefTable.getInstance().getSymbolDef(basicSymbolID, symStd);
        if (sd == null) {
            symbolID = SymbolUtilities.reconcileSymbolID(symbolID);
            basicSymbolID = SymbolUtilities.getBasicSymbolIDStrict(symbolID);
            sd = SymbolDefTable.getInstance().getSymbolDef(basicSymbolID, symStd);
        }
        if (sd == null) return this._SPR.RenderUnit(symbolID, modifiers, attributes);
        if (sd.getDrawCategory() != 8) return this.renderTacticalMultipointIcon(symbolID, attributes);
        return this._SPR.RenderSP(symbolID, modifiers, attributes);
    }

    public String getRendererID() {
        return "milstd2525";
    }

    private SparseArray<String> getDefaultAttributes(String symbolID) {
        SparseArray map = new SparseArray();
        try {
            if (symbolID == null || symbolID.length() != 15) {
                if (symbolID == null) {
                    symbolID = "null";
                }
                ErrorLogger.LogMessage("MilStdIconRenderer", "getDefaultAttributes", "getDefaultAttributes passed bad symbolID: " + symbolID);
                return null;
            }
            map.put(6, (Object)"1.0");
            if (SymbolUtilities.hasDefaultFill(symbolID)) {
                map.put(1, (Object)SymbolUtilities.getFillColorOfAffiliation(symbolID).toHexString());
            }
            map.put(0, (Object)SymbolUtilities.getLineColorOfAffiliation(symbolID).toHexString());
            map.put(7, (Object)"false");
            map.put(10, (Object)"false");
            RendererSettings rs = RendererSettings.getInstance();
            if (SymbolUtilities.isWarfighting(symbolID)) {
                if (rs != null) {
                    map.put(2, (Object)String.valueOf(rs.getUnitFontSize()));
                } else {
                    map.put(2, (Object)"50");
                }
                map.put(3, (Object)"-1");
            } else {
                if (rs != null) {
                    map.put(2, (Object)String.valueOf(rs.getSPFontSize()));
                } else {
                    map.put(2, (Object)"60");
                }
                map.put(3, (Object)"-1");
            }
            map.put(5, (Object)"true");
            return map;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("MilStdIconRenderer", "getDefaultAttributes", exc);
            return map;
        }
    }
}

